;   BGE
;---------------------------------------------------------------
;          Burial Graphics Editor 4.0
;---------------------------------------------------------------
;     PgnAdr (#A500) 
;     #1B00 (6912) 
; Plug-in is placed at PgnAdr (#A500), max size=#1B00 (6912)
;----------------------------------------------------------------------------------------------------
;     (at plug-in entry):   /  !    HL  DE  / DA
; HL -     (address or plug-in exit):
;      SCF -    (    ..) (don't keep the plug-in - error etc)
;      A = 0      (redraw the Main menu and screen)
;      A = 1         (close all the windows and go to Main menu)
;-----------------------------------------------------------------------------------------------------

;  (constants) BGE
;
BeginGUI EQU #C800
SCREEN   EQU #C000
UNDOSCR  EQU #C000+6912      ; Undo address
ScrPage  EQU 0           ;  SCREE, UNDOSCR (page for SCREE, UNDOSCR)
SuxPage  EQU 1           ; ,    
                 ;    
                 ;    (windows swap page, you can use it)
GUIPage  EQU 3           ;  SupremeGUI (SupremeGUI page)
AddPage  EQU 4           ;   BGE, 
                 ;     
                 ;  ,   
                 ;  ,   
                 ;    
                 ;  (datapage common for all the plug-ins, you can use it)
PgnPage1 EQU 6
PgnPage2 EQU 7
RamPage  EQU 7           ;    (screen 2 page)
PgnAdr   EQU #A500       ;    (current plug-in address)
;---------------------------------------------------------------
;   Burial,   ,
;   :
;   CALL "__"
; All the functions of BGE described below are called this way:
;   CALL "address_in_kernel"
;---------------------------------------------------------------
; ---- functions in BGE v3.o5 original ----

KERNEL      EQU #6000

;   GUI (call GUI function)
GUI     EQU KERNEL

;  BGE  (restart BGE)
BGE_RUN     EQU GUI+3

;    (picture to screen)
LOADSCR     EQU BGE_RUN+3

;     (screen to memory)
SAVESCR     EQU LOADSCR+3

;   Undo (exchange with Undo)
LD_UNDO     EQU SAVESCR+3

;   Undo (copy to Undo)
SV_UNDO     EQU LD_UNDO+3

;   x8 (draw x8 frame)
; IX -      (data for frame)
; DB x,y, (width),  (height)
;       256... (zero size means 256)
BoxCol      EQU SV_UNDO+3

;   x1 (draw x1 frame)
; IX -      (data for frame)
; DB x,y, (width),  (height)
;       ,  =  (1) (zero size means 1)
BoxPix      EQU BoxCol+3

;   x8 (select window x8)
;   BoxCol (parameters as in BoxCol)
;    Cancel,   
;      [IX]
; (Cancel sets CY and returns the old parameters in [IX])
R8Sel       EQU BoxPix+3

;   x1 (select window x1)
;   BoxPix (parameters as in BoxPix)
;    Cancel,   
;      [IX]
; (Cancel sets CY and returns the old parameters in [IX])
R1Sel       EQU R8Sel+3

;  ,       GUI
;(open a page and remember it to work with GUI)
RAM     EQU R1Sel+3

;   [IX]      
;  
;(save window [IX] with saving window address in the descriptor of saved windows)
GETBLK      EQU RAM+3

;   ,    
; 
;(close the last window listed in the descriptor of saved windows)
CLOSE       EQU GETBLK+3

; A  <-   (item number)
; BC <-    (address of word table) (DEFW)
; HL ->    (value from table)
TAB_HL      EQU CLOSE+3

;  TAB_HL,    JP (HL)
;(calls TAB_HL then does JP (HL))
TAB_JP      EQU TAB_HL+3

;     (call filename editor)
; HL <-  ,     (11 )
;        ,  
;    Ext.Mode,   
; 
;       23773
FNEdit      EQU TAB_JP+3

;   (call file selector)
; HL <-    
;  :
;
; DB #00,_1, _2, ..., #FF
;   _1, _2, ...
;
; DB #01,"p..","ex.","txt","...", ..., #FF
;    , "." -  
;
; DB #02,".....scr",#FF
;    "......scr", "." -  
FilerE      EQU FNEdit+3

;     OnFire  OnCancel
; (Check keys for OnFire and OnCancel)
; A ->  :
;    bit 0 -  Fire
;    bit 1 -  Cancel
;    bit 2 -    (pressed on mouse)
; F ->      (CY=1) - Cancel
BREAK       EQU FilerE+3

;      (install plot table)
; HL <-   ( 256) (table address, multiple of 256)
; DE <-   (screen address)
install_plot    EQU BREAK+3

;   ,    SET_SNP (draw line with that plot)
; DE <- X1, Y1
; BC <- X2, Y2
LINE        EQU install_plot+3

;    LINE (install plot for LINE)
; HL <-     (address of plot procedure),   
;     DE <- X1, Y1
SET_SNP     EQU LINE+3

;       (remove all the windows from the descriptor of saved windows)
ERASE_ALLW  EQU SET_SNP+3

;      (close all windows)
CLOSE_ALLW  EQU ERASE_ALLW+3

;  (multiply)
; HL = A*H
MULS        EQU CLOSE_ALLW+3

;  (multiply)
; HL = B*C
Mult        EQU MULS+3

;  (divide)
; HL = HL/DE
DIV     EQU Mult+3

;  (multiply)
; DE=DE/BC
Div     EQU DIV+3

;    (save sprite from screen)
; [IX] <- DB x, y,  (width),  (height)
; DE   <-   (save address)
; DE   ->  +  (save address+sprite size)
SaveWS      EQU Div+3

;   
; [IX] <- DB x, y,  (width),  (height)
; DE   <-   (save address)
; DE   ->  +  (save address+sprite size)
SaveWA      EQU SaveWS+3

;   
; [IX] <- DB x, y,  (width),  (height)
; DE   <-   (save address)
; DE   ->  +  (save address+sprite size)
LoadWS      EQU SaveWA+3

;   
; [IX] <- DB x, y,  (width),  (height)
; DE   <-   (save address)
; DE   ->  +  (save address+sprite size)
LoadWA      EQU LoadWS+3

;     (call menu for changing drives) (A,B,C,D,E)
;      ,   
;  Cancel (CY=1 on exit means Cancel or error)
Driver      EQU LoadWA+3

;         (show message "data lost")
NoData_     EQU Driver+3

;   " ?" (prompt "Are you sure?")
;      ,   ,
;   (CY=1 means No, CY=0 means yes)
ASK     EQU NoData_+3

;   (clear window)
CLSVV       EQU ASK+3

;    (set window attributes)
setv        EQU CLSVV+3

;   ,    RAM (get current page number)
; A ->   (0,1,2,3,4,5,6,7)
GetRAM      EQU setv+3

;     RGB (get attribute selected in RGB)
; A ->  RGB
GetATR      EQU GetRAM+3

;     RGB (mix attribute with attribute selected in RGB)
; A -> 
; A <-       RGB
MIXCOL      EQU GetATR+3

;     #07 (clear screen with attribute #07)
CLS     EQU MIXCOL+3

;    , . 2,5 (set page except 2,5)
ONPAGE      EQU CLS+3

;   (invert window)
INV     EQU ONPAGE+3

;    0 (set current screen 0, i.e. 1)
SET_SCR1    EQU INV+3

;    1 (set current screen 1, i.e. 2)
SET_SCR2    EQU SET_SCR1+3

;       RGB (set window attributes with attributes selected in RGB?)
SETV        EQU SET_SCR2+3

;  LaserCompact 5.2   #4000 (depack to screen)
; HL <-  (from)
DECOMPR     EQU SETV+3

;     ,   
;  (exchange screens)
SwpSRam     EQU DECOMPR+3

;   (pop-up menu)
; IX <-    (parent window)
; HL <-    () (child window)
;    Win (calls Win)
PupMnu      EQU SwpSRam+3

;   ,    Win,    (the same, but doesn't call Win, just sets the window)
pupmnu      EQU PupMnu+3

;  11   23773 (    )
;  ,    DE (copy 11 bytes of file name from 23773 (filename from file selector) to (DE))
; DE <-     (filename buffer addr)
ToName      EQU pupmnu+3

;    ToName (reverse to ToName)
; HL <-     (filename buffer addr)
FromName    EQU ToName+3

;    1x1 (print sprite pixel perfect)
; HL -   (sprite address)
; BC - x,y
OutPix      EQU FromName+3

;    OutPix (output methods for OutPix)
OR_Pix      EQU OutPix+3
XOR_Pix     EQU OR_Pix+3
AND_Pix     EQU XOR_Pix+3

;      BGE (cursor settings)
IniVar      EQU AND_Pix+3

;  (frame)
; SCF   <-   (size selection)
; XOR A <-    (moving on screen)
Ramka8      EQU IniVar+3
Ramka8_     EQU Ramka8+3
Ramka1      EQU Ramka8_+3

;        (call palette with printing main screen)
PRGB        EQU Ramka1+3

;        (call palette without printing main screen)
PRGB2       EQU PRGB+3

;   (sprite editor)
;  
; HL <-    (address of parameter table)
; IX ->    (sprite editor window)
; A  ->  ,     Win  Winn (as after Win or Winn call)
;TBFnt1 DB #07,#04   ; X,Y  (X,Y of window)
;   DB #11,#08   ;  (width),  (height)
;   DW FBuff     ;   (sprite address)
;   DW #0103     ; X,Y   (X,Y of editor window)
;   DW #0101     ;   (sprite size)
;   DW #0603     ; X,Y preview
;   DW BEText    ;  (text)
;   DW BESel     ;  (highlighting)
;   DW BEHot     ;   (hotkeys)

;  !       #BC00  #BFFF   .
;        

;     ,    ,
;     (window can be moved by screen and can be closed by clicking outside)
SPEdit      EQU PRGB2+3
;   (static window)
SPEdit_     EQU SPEdit+3

;  HRUST  1.oo, 1.o1, 1.o2, 1.o3 (depacker for HRUST1.x files)
; HL <-  (from)
; DE <-  (to)

DEHRUST     EQU SPEdit_+3

;     (re-count coordinates relative to the window)
; DE <-   (relative coords)
; DE ->   (absolute coords)
RealWin     EQU DEHRUST+3

;  GUI ,    ,  -
; -  GUI,    GUIPage
;(call GUI function, for procedures working from GUI outside GUIPage)
GUI_        EQU RealWin+3

;   (border color) (byte)
BORDER      EQU GUI_+3

;  " " ("error" window)
; A <-   (error number)
GET_MSG_    EQU BORDER+1

;  ProgessBar, ..      -
;         
; CLOSE (init ProgressBar, show it on screen with 0% and saving the background to recover it by CLOSE)
PERCINI     EQU GET_MSG_+3

;  ProgressBar (show ProgressBar)
; A <-   (0-100%)
PRCN        EQU PERCINI+3


;-------- add in BGE v3.09 ---------


;    . ,     ! /DA
LOUPE           EQU PRCN+3


;-------- add in BGE v3.11 ---------


;   
PMask           EQU LOUPE+3

;   
PMskInit        EQU PMask+3

;  
Texture         EQU PMskInit+3

;    
; [IX] <- DB x, y,  (width),  (height)
; A  <- color attribute
SetWA           EQU Texture+3

;       /DA
; [IX] <- DB x,y,  (width),   (height),   X,   Y,  
;                      .
; DE   <-    
; HL   <-           
; A    <-     ; >=1
;     <-       ; >=1
WSseries        EQU SetWA+3


;-------- add in BGE v4.0 ---------


;    
; [IX] <-    ( DB x, y,  (width),  (height),...)
; DE <-   :  D - x , E - y
; BC <- :  B - sx , C - sy
CleanWS         EQU WSseries+3

;       
; in: DE <- name addres , HL <- sort tab.
; out: -> filename to name addres, file parameters in FILE_PARAM,
; A -> file number or #FF for not filer used
; scf for error
FNSelect        EQU CleanWS+3

;   "     !" (prompt "AddPage data may be corrupted !")
;      ,   ,
;   (CY=1 means No, CY=0 means yes)
AskAddP         EQU FNSelect+3

;     
; in:  HL <-    (38  ,  )
;      ,   ,
;   (CY=1 means No, CY=0 means yes)
AskQ            EQU AskAddP+3

;        (     x8,x1 )
;  :  CALL WinFunc : DB Function_Number  ;    
WinFunc         EQU AskQ+3

;      ( )
; out: A -> char of current drive
GetDrive        EQU WinFunc+3