!!ARBvp1.0

	PARAM mvinv[4] = { state.matrix.modelview.invtrans };
	PARAM mvp[4] = { state.matrix.mvp };

	ATTRIB iPos = vertex.position;
	ATTRIB iNormal = vertex.normal;
	ATTRIB iColor = vertex.color;

	PARAM lightDir = state.light[0].position;
	PARAM halfDir = state.light[0].half;
	PARAM ambientCol = state.lightprod[0].ambient;
	PARAM diffuseCol = state.lightprod[0].diffuse;
	TEMP eyeNormal;
	TEMP temp;
	TEMP dots;
	TEMP lightcoefs;

	TEMP Temp0;
	TEMP Temp1;
	TEMP Temp2;

	OUTPUT oPos = result.position;
	OUTPUT oColor = result.color;

	PARAM Const0 = { 0.04, 0.2, 0.5, 1 };
	PARAM Const2 = { -2, 0, -0.2, 0 };
	PARAM Const1 = program.local[0];

	ADD Temp0.x, Const2.z, -iPos.y;
	SGE Temp0.x, Temp0.x, Const2.y;
	MAD Temp0.x, Temp0.x, Const2.x, Const0.w;
	MAD Temp0.x, Temp0.x, Const0.z, Const0.z;
	MAD Temp0.y, iPos.y, Const0.y, Const0.x;
	MOV Temp1, iPos;
	MAD Temp1.x, Const1.x, Temp0.y, iPos.x;
	ADD Temp1, Temp1, -iPos;
	MAD Temp0, Temp1, Temp0.x, iPos;
	MOV Temp1, Const2.y;
	DP4 Temp1.x, mvp[0], Temp0;
	DP4 Temp1.y, mvp[1], Temp0;
	DP4 Temp1.z, mvp[2], Temp0;
	DP4 Temp1.w, mvp[3], Temp0;
	MOV oPos, Temp1;

	DP3 eyeNormal.x, mvinv[0], iNormal;
	DP3 eyeNormal.y, mvinv[1], iNormal;
	DP3 eyeNormal.z, mvinv[2], iNormal; 

	DP3 dots.x, eyeNormal, lightDir;
	LIT lightcoefs, dots.x; 

	# Accumulate color contributions.
	MAD temp, lightcoefs.y, diffuseCol, ambientCol;
	MUL oColor, temp, iColor;

END
