; ------------------------------------------------------
; Skybox And Camera
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Bmp.asm
                        include ..\Common_Src\Textures.asm
                        include ..\Common_Src\Camera.asm

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotY                    real4   0.0
RotZ                    real4   0.0

Texture_Front           BMP     <>
Texture_Back            BMP     <>
Texture_Left            BMP     <>
Texture_Right           BMP     <>
Texture_Top             BMP     <>
Texture_Bottom          BMP     <>

My_Mouse_Y              dd      0

Textures_Datas          dd      6 dup (0)
Textures_Id             dd      6 dup (0)

Cam_Pitch               real4   0.0
Cam_Heading             real4   0.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        invoke  Load_BMP, CSTR("..\..\Media\sky_front.bmp"), addr Texture_Front, -1
                        .if     eax == FALSE
Err_Texture:                    invoke  Set_Error_Msg, CSTR("Can't load texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        invoke  Load_BMP, CSTR("..\..\Media\sky_back.bmp"), addr Texture_Back, -1
                        test    eax, eax
                        jz      Err_Texture
                        invoke  Load_BMP, CSTR("..\..\Media\sky_left.bmp"), addr Texture_Left, -1
                        test    eax, eax
                        jz      Err_Texture
                        invoke  Load_BMP, CSTR("..\..\Media\sky_right.bmp"), addr Texture_Right, -1
                        test    eax, eax
                        jz      Err_Texture
                        invoke  Load_BMP, CSTR("..\..\Media\sky_top.bmp"), addr Texture_Top, -1
                        test    eax, eax
                        jz      Err_Texture
                        invoke  Load_BMP, CSTR("..\..\Media\sky_bottom.bmp"), addr Texture_Bottom, -1
                        test    eax, eax
                        jz      Err_Texture

                        mov     eax, Texture_Left.Datas
                        mov     Textures_Datas[SKYBOX_LEFT], eax
                        mov     eax, Texture_Right.Datas
                        mov     Textures_Datas[SKYBOX_RIGHT], eax
                        mov     eax, Texture_Top.Datas
                        mov     Textures_Datas[SKYBOX_TOP], eax
                        mov     eax, Texture_Bottom.Datas
                        mov     Textures_Datas[SKYBOX_BOTTOM], eax
                        mov     eax, Texture_Back.Datas
                        mov     Textures_Datas[SKYBOX_BACK], eax
                        mov     eax, Texture_Front.Datas
                        mov     Textures_Datas[SKYBOX_FRONT], eax

                        invoke  Init_Textures_Context
                        
                        invoke  Create_Skybox_Texture, addr Textures_Datas, addr Textures_Id, Texture_Front._Width, TRUE, GL_RGBA, GL_RGBA
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create texture")
                                mov     eax, FALSE
                                ret
                        .endif

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  Destroy_Skybox, addr Textures_Id

                        invoke  Unload_BMP, addr Texture_Front
                        invoke  Unload_BMP, addr Texture_Back
                        invoke  Unload_BMP, addr Texture_Left
                        invoke  Unload_BMP, addr Texture_Right
                        invoke  Unload_BMP, addr Texture_Top
                        invoke  Unload_BMP, addr Texture_Bottom
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        invoke  DInput_Clamp_Mouse, Mouse_Y, addr My_Mouse_Y, -90, 90

                        ; Update scene here
                        fild    Mouse_X
                        fadd    Cam_Heading
                        fstp    Cam_Heading

                        fild    My_Mouse_Y
                        fstp    Cam_Pitch
                        
                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  glPushMatrix
                                invoke  Cam_Orientation, Cam_Pitch, Cam_Heading
                                
                                invoke  glColor4f, CFLT(1.0), CFLT(1.0), CFLT(1.0), CFLT(0.0)
                                invoke  glEnable, GL_TEXTURE_2D
                                invoke  glDisable, GL_LIGHTING
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR
                                invoke  glTexParameteri, GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR
                                invoke  Draw_Skybox, addr Textures_Id
                                invoke  glDisable, GL_TEXTURE_2D
                        invoke  glPopMatrix

                        ret
Draw                    endp

end start
