; ++ BUILD Version: 0004    - Increment this if a change has global effects
;
;Copyright (c) 1985-96, Microsoft Corporation
;
;Module Name:
;
;    gl.h
;
;Abstract:
;
;    Procedure declarations, constant definitions and macros for the OpenGL
;    component.
;
;
; Copyright 1996 Silicon Graphics, Inc.
; All Rights Reserved.
; This is UNPUBLISHED PROPRIETARY SOURCE CODE of Silicon Graphics, Inc.;
; the contents of this file may not be disclosed to third parties, copied or
; duplicated in any form, in whole or in part, without the prior written
; permission of Silicon Graphics, Inc.
;
; RESTRICTED RIGHTS LEGEND:
; Use, duplication or disclosure by the Government is subject to restrictions
; as set forth in subdivision (c)(1)(ii) of the Rights in Technical Data
; and Computer Software clause at DFARS 252.227-7013, and/or in similar or
; successor clauses in the FAR, DOD or NASA FAR Supplement. Unpublished -
; rights reserved under the Copyright Laws of the United States.
;
; Converted to asm by Franck Charlet.

GLenum                          typedef dword
GLboolean                       typedef dword
GLbitfield                      typedef dword
GLbyte                          typedef byte
GLshort                         typedef word
GLint                           typedef dword
GLsizei                         typedef dword
GLubyte                         typedef byte
GLushort                        typedef word
GLuint                          typedef dword
GLfloat                         typedef real4
GLclampf                        typedef real4
GLdouble                        typedef real8
GLclampd                        typedef real8
GLvoid                          typedef dword

;*************************************************************

; Version
GL_VERSION_1_1 equ 1

; AccumOp
GL_ACCUM                        equ     00100h
GL_LOAD                         equ     00101h
GL_RETURN                       equ     00102h
GL_MULT                         equ     00103h
GL_ADD                          equ     00104h

; AlphaFunction
GL_NEVER                        equ     00200h
GL_LESS                         equ     00201h
GL_EQUAL                        equ     00202h
GL_LEQUAL                       equ     00203h
GL_GREATER                      equ     00204h
GL_NOTEQUAL                     equ     00205h
GL_GEQUAL                       equ     00206h
GL_ALWAYS                       equ     00207h

; AttribMask
GL_CURRENT_BIT                  equ     000000001h
GL_POINT_BIT                    equ     000000002h
GL_LINE_BIT                     equ     000000004h
GL_POLYGON_BIT                  equ     000000008h
GL_POLYGON_STIPPLE_BIT          equ     000000010h
GL_PIXEL_MODE_BIT               equ     000000020h
GL_LIGHTING_BIT                 equ     000000040h
GL_FOG_BIT                      equ     000000080h
GL_DEPTH_BUFFER_BIT             equ     000000100h
GL_ACCUM_BUFFER_BIT             equ     000000200h
GL_STENCIL_BUFFER_BIT           equ     000000400h
GL_VIEWPORT_BIT                 equ     000000800h
GL_TRANSFORM_BIT                equ     000001000h
GL_ENABLE_BIT                   equ     000002000h
GL_COLOR_BUFFER_BIT             equ     000004000h
GL_HINT_BIT                     equ     000008000h
GL_EVAL_BIT                     equ     000010000h
GL_LIST_BIT                     equ     000020000h
GL_TEXTURE_BIT                  equ     000040000h
GL_SCISSOR_BIT                  equ     000080000h
GL_ALL_ATTRIB_BITS              equ     0000fffffh

; BeginMode
GL_POINTS                       equ     00000h
GL_LINES                        equ     00001h
GL_LINE_LOOP                    equ     00002h
GL_LINE_STRIP                   equ     00003h
GL_TRIANGLES                    equ     00004h
GL_TRIANGLE_STRIP               equ     00005h
GL_TRIANGLE_FAN                 equ     00006h
GL_QUADS                        equ     00007h
GL_QUAD_STRIP                   equ     00008h
GL_POLYGON                      equ     00009h

; BlendingFactorDest
GL_ZERO                         equ     0
GL_ONE                          equ     1
GL_SRC_COLOR                    equ     00300h
GL_ONE_MINUS_SRC_COLOR          equ     00301h
GL_SRC_ALPHA                    equ     00302h
GL_ONE_MINUS_SRC_ALPHA          equ     00303h
GL_DST_ALPHA                    equ     00304h
GL_ONE_MINUS_DST_ALPHA          equ     00305h

; BlendingFactorSrc
;      GL_ZERO
;      GL_ONE
GL_DST_COLOR                    equ     00306h
GL_ONE_MINUS_DST_COLOR          equ     00307h
GL_SRC_ALPHA_SATURATE           equ     00308h
;      GL_SRC_ALPHA
;      GL_ONE_MINUS_SRC_ALPHA
;      GL_DST_ALPHA
;      GL_ONE_MINUS_DST_ALPHA

; Boolean
GL_TRUE                         equ     1
GL_FALSE                        equ     0

; ClearBufferMask
;      GL_COLOR_BUFFER_BIT
;      GL_ACCUM_BUFFER_BIT
;      GL_STENCIL_BUFFER_BIT
;      GL_DEPTH_BUFFER_BIT

; ClientArrayType
;      GL_VERTEX_ARRAY
;      GL_NORMAL_ARRAY
;      GL_COLOR_ARRAY
;      GL_INDEX_ARRAY
;      GL_TEXTURE_COORD_ARRAY
;      GL_EDGE_FLAG_ARRAY

; ClipPlaneName
GL_CLIP_PLANE0                  equ     03000h
GL_CLIP_PLANE1                  equ     03001h
GL_CLIP_PLANE2                  equ     03002h
GL_CLIP_PLANE3                  equ     03003h
GL_CLIP_PLANE4                  equ     03004h
GL_CLIP_PLANE5                  equ     03005h

; ColorMaterialFace
;      GL_FRONT
;      GL_BACK
;      GL_FRONT_AND_BACK

; ColorMaterialParameter
;      GL_AMBIENT
;      GL_DIFFUSE
;      GL_SPECULAR
;      GL_EMISSION
;      GL_AMBIENT_AND_DIFFUSE

; ColorPointerType
;      GL_BYTE
;      GL_UNSIGNED_BYTE
;      GL_SHORT
;      GL_UNSIGNED_SHORT
;      GL_INT
;      GL_UNSIGNED_INT
;      GL_FLOAT
;      GL_DOUBLE

; CullFaceMode
;      GL_FRONT
;      GL_BACK
;      GL_FRONT_AND_BACK

; DataType
GL_BYTE                         equ     01400h
GL_UNSIGNED_BYTE                equ     01401h
GL_SHORT                        equ     01402h
GL_UNSIGNED_SHORT               equ     01403h
GL_INT                          equ     01404h
GL_UNSIGNED_INT                 equ     01405h
GL_FLOAT                        equ     01406h
GL_2_BYTES                      equ     01407h
GL_3_BYTES                      equ     01408h
GL_4_BYTES                      equ     01409h
GL_DOUBLE                       equ     0140Ah

; DepthFunction
;      GL_NEVER
;      GL_LESS
;      GL_EQUAL
;      GL_LEQUAL
;      GL_GREATER
;      GL_NOTEQUAL
;      GL_GEQUAL
;      GL_ALWAYS

; DrawBufferMode
GL_NONE                         equ     0
GL_FRONT_LEFT                   equ     00400h
GL_FRONT_RIGHT                  equ     00401h
GL_BACK_LEFT                    equ     00402h
GL_BACK_RIGHT                   equ     00403h
GL_FRONT                        equ     00404h
GL_BACK                         equ     00405h
GL_LEFT                         equ     00406h
GL_RIGHT                        equ     00407h
GL_FRONT_AND_BACK               equ     00408h
GL_AUX0                         equ     00409h
GL_AUX1                         equ     0040Ah
GL_AUX2                         equ     0040Bh
GL_AUX3                         equ     0040Ch

; Enable
;      GL_FOG
;      GL_LIGHTING
;      GL_TEXTURE_1D
;      GL_TEXTURE_2D
;      GL_LINE_STIPPLE
;      GL_POLYGON_STIPPLE
;      GL_CULL_FACE
;      GL_ALPHA_TEST
;      GL_BLEND
;      GL_INDEX_LOGIC_OP
;      GL_COLOR_LOGIC_OP
;      GL_DITHER
;      GL_STENCIL_TEST
;      GL_DEPTH_TEST
;      GL_CLIP_PLANE0
;      GL_CLIP_PLANE1
;      GL_CLIP_PLANE2
;      GL_CLIP_PLANE3
;      GL_CLIP_PLANE4
;      GL_CLIP_PLANE5
;      GL_LIGHT0
;      GL_LIGHT1
;      GL_LIGHT2
;      GL_LIGHT3
;      GL_LIGHT4
;      GL_LIGHT5
;      GL_LIGHT6
;      GL_LIGHT7
;      GL_TEXTURE_GEN_S
;      GL_TEXTURE_GEN_T
;      GL_TEXTURE_GEN_R
;      GL_TEXTURE_GEN_Q
;      GL_MAP1_VERTEX_3
;      GL_MAP1_VERTEX_4
;      GL_MAP1_COLOR_4
;      GL_MAP1_INDEX
;      GL_MAP1_NORMAL
;      GL_MAP1_TEXTURE_COORD_1
;      GL_MAP1_TEXTURE_COORD_2
;      GL_MAP1_TEXTURE_COORD_3
;      GL_MAP1_TEXTURE_COORD_4
;      GL_MAP2_VERTEX_3
;      GL_MAP2_VERTEX_4
;      GL_MAP2_COLOR_4
;      GL_MAP2_INDEX
;      GL_MAP2_NORMAL
;      GL_MAP2_TEXTURE_COORD_1
;      GL_MAP2_TEXTURE_COORD_2
;      GL_MAP2_TEXTURE_COORD_3
;      GL_MAP2_TEXTURE_COORD_4
;      GL_POINT_SMOOTH
;      GL_LINE_SMOOTH
;      GL_POLYGON_SMOOTH
;      GL_SCISSOR_TEST
;      GL_COLOR_MATERIAL
;      GL_NORMALIZE
;      GL_AUTO_NORMAL
;      GL_VERTEX_ARRAY
;      GL_NORMAL_ARRAY
;      GL_COLOR_ARRAY
;      GL_INDEX_ARRAY
;      GL_TEXTURE_COORD_ARRAY
;      GL_EDGE_FLAG_ARRAY
;      GL_POLYGON_OFFSET_POINT
;      GL_POLYGON_OFFSET_LINE
;      GL_POLYGON_OFFSET_FILL

; ErrorCode
GL_NO_ERROR                     equ     0
GL_INVALID_ENUM                 equ     00500h
GL_INVALID_VALUE                equ     00501h
GL_INVALID_OPERATION            equ     00502h
GL_STACK_OVERFLOW               equ     00503h
GL_STACK_UNDERFLOW              equ     00504h
GL_OUT_OF_MEMORY                equ     00505h

; FeedBackMode
GL_2D                           equ     00600h
GL_3D                           equ     00601h
GL_3D_COLOR                     equ     00602h
GL_3D_COLOR_TEXTURE             equ     00603h
GL_4D_COLOR_TEXTURE             equ     00604h

; FeedBackToken
GL_PASS_THROUGH_TOKEN           equ     00700h
GL_POINT_TOKEN                  equ     00701h
GL_LINE_TOKEN                   equ     00702h
GL_POLYGON_TOKEN                equ     00703h
GL_BITMAP_TOKEN                 equ     00704h
GL_DRAW_PIXEL_TOKEN             equ     00705h
GL_COPY_PIXEL_TOKEN             equ     00706h
GL_LINE_RESET_TOKEN             equ     00707h

; FogMode
;      GL_LINEAR
GL_EXP                          equ     00800h
GL_EXP2                         equ     00801h

; FogParameter
;      GL_FOG_COLOR
;      GL_FOG_DENSITY
;      GL_FOG_END
;      GL_FOG_INDEX
;      GL_FOG_MODE
;      GL_FOG_START

; FrontFaceDirection
GL_CW                           equ     00900h
GL_CCW                          equ     00901h

; GetMapTarget
GL_COEFF                        equ     00A00h
GL_ORDER                        equ     00A01h
GL_DOMAIN                       equ     00A02h

; GetPixelMap
;      GL_PIXEL_MAP_I_TO_I
;      GL_PIXEL_MAP_S_TO_S
;      GL_PIXEL_MAP_I_TO_R
;      GL_PIXEL_MAP_I_TO_G
;      GL_PIXEL_MAP_I_TO_B
;      GL_PIXEL_MAP_I_TO_A
;      GL_PIXEL_MAP_R_TO_R
;      GL_PIXEL_MAP_G_TO_G
;      GL_PIXEL_MAP_B_TO_B
;      GL_PIXEL_MAP_A_TO_A

; GetPointerTarget
;      GL_VERTEX_ARRAY_POINTER
;      GL_NORMAL_ARRAY_POINTER
;      GL_COLOR_ARRAY_POINTER
;      GL_INDEX_ARRAY_POINTER
;      GL_TEXTURE_COORD_ARRAY_POINTER
;      GL_EDGE_FLAG_ARRAY_POINTER

; GetTarget
GL_CURRENT_COLOR                        equ     00B00h
GL_CURRENT_INDEX                        equ     00B01h
GL_CURRENT_NORMAL                       equ     00B02h
GL_CURRENT_TEXTURE_COORDS               equ     00B03h
GL_CURRENT_RASTER_COLOR                 equ     00B04h
GL_CURRENT_RASTER_INDEX                 equ     00B05h
GL_CURRENT_RASTER_TEXTURE_COORDS        equ     00B06h
GL_CURRENT_RASTER_POSITION              equ     00B07h
GL_CURRENT_RASTER_POSITION_VALID        equ     00B08h
GL_CURRENT_RASTER_DISTANCE              equ     00B09h
GL_POINT_SMOOTH                         equ     00B10h
GL_POINT_SIZE                           equ     00B11h
GL_POINT_SIZE_RANGE                     equ     00B12h
GL_POINT_SIZE_GRANULARITY               equ     00B13h
GL_LINE_SMOOTH                          equ     00B20h
GL_LINE_WIDTH                           equ     00B21h
GL_LINE_WIDTH_RANGE                     equ     00B22h
GL_LINE_WIDTH_GRANULARITY               equ     00B23h
GL_LINE_STIPPLE                         equ     00B24h
GL_LINE_STIPPLE_PATTERN                 equ     00B25h
GL_LINE_STIPPLE_REPEAT                  equ     00B26h
GL_LIST_MODE                            equ     00B30h
GL_MAX_LIST_NESTING                     equ     00B31h
GL_LIST_BASE                            equ     00B32h
GL_LIST_INDEX                           equ     00B33h
GL_POLYGON_MODE                         equ     00B40h
GL_POLYGON_SMOOTH                       equ     00B41h
GL_POLYGON_STIPPLE                      equ     00B42h
GL_EDGE_FLAG                            equ     00B43h
GL_CULL_FACE                            equ     00B44h
GL_CULL_FACE_MODE                       equ     00B45h
GL_FRONT_FACE                           equ     00B46h
GL_LIGHTING                             equ     00B50h
GL_LIGHT_MODEL_LOCAL_VIEWER             equ     00B51h
GL_LIGHT_MODEL_TWO_SIDE                 equ     00B52h
GL_LIGHT_MODEL_AMBIENT                  equ     00B53h
GL_SHADE_MODEL                          equ     00B54h
GL_COLOR_MATERIAL_FACE                  equ     00B55h
GL_COLOR_MATERIAL_PARAMETER             equ     00B56h
GL_COLOR_MATERIAL                       equ     00B57h
GL_FOG                                  equ     00B60h
GL_FOG_INDEX                            equ     00B61h
GL_FOG_DENSITY                          equ     00B62h
GL_FOG_START                            equ     00B63h
GL_FOG_END                              equ     00B64h
GL_FOG_MODE                             equ     00B65h
GL_FOG_COLOR                            equ     00B66h
GL_DEPTH_RANGE                          equ     00B70h
GL_DEPTH_TEST                           equ     00B71h
GL_DEPTH_WRITEMASK                      equ     00B72h
GL_DEPTH_CLEAR_VALUE                    equ     00B73h
GL_DEPTH_FUNC                           equ     00B74h
GL_ACCUM_CLEAR_VALUE                    equ     00B80h
GL_STENCIL_TEST                         equ     00B90h
GL_STENCIL_CLEAR_VALUE                  equ     00B91h
GL_STENCIL_FUNC                         equ     00B92h
GL_STENCIL_VALUE_MASK                   equ     00B93h
GL_STENCIL_FAIL                         equ     00B94h
GL_STENCIL_PASS_DEPTH_FAIL              equ     00B95h
GL_STENCIL_PASS_DEPTH_PASS              equ     00B96h
GL_STENCIL_REF                          equ     00B97h
GL_STENCIL_WRITEMASK                    equ     00B98h
GL_MATRIX_MODE                          equ     00BA0h
GL_NORMALIZE                            equ     00BA1h
GL_VIEWPORT                             equ     00BA2h
GL_MODELVIEW_STACK_DEPTH                equ     00BA3h
GL_PROJECTION_STACK_DEPTH               equ     00BA4h
GL_TEXTURE_STACK_DEPTH                  equ     00BA5h
GL_MODELVIEW_MATRIX                     equ     00BA6h
GL_PROJECTION_MATRIX                    equ     00BA7h
GL_TEXTURE_MATRIX                       equ     00BA8h
GL_ATTRIB_STACK_DEPTH                   equ     00BB0h
GL_CLIENT_ATTRIB_STACK_DEPTH            equ     00BB1h
GL_ALPHA_TEST                           equ     00BC0h
GL_ALPHA_TEST_FUNC                      equ     00BC1h
GL_ALPHA_TEST_REF                       equ     00BC2h
GL_DITHER                               equ     00BD0h
GL_BLEND_DST                            equ     00BE0h
GL_BLEND_SRC                            equ     00BE1h
GL_BLEND                                equ     00BE2h
GL_LOGIC_OP_MODE                        equ     00BF0h
GL_INDEX_LOGIC_OP                       equ     00BF1h
GL_COLOR_LOGIC_OP                       equ     00BF2h
GL_AUX_BUFFERS                          equ     00C00h
GL_DRAW_BUFFER                          equ     00C01h
GL_READ_BUFFER                          equ     00C02h
GL_SCISSOR_BOX                          equ     00C10h
GL_SCISSOR_TEST                         equ     00C11h
GL_INDEX_CLEAR_VALUE                    equ     00C20h
GL_INDEX_WRITEMASK                      equ     00C21h
GL_COLOR_CLEAR_VALUE                    equ     00C22h
GL_COLOR_WRITEMASK                      equ     00C23h
GL_INDEX_MODE                           equ     00C30h
GL_RGBA_MODE                            equ     00C31h
GL_DOUBLEBUFFER                         equ     00C32h
GL_STEREO                               equ     00C33h
GL_RENDER_MODE                          equ     00C40h
GL_PERSPECTIVE_CORRECTION_HINT          equ     00C50h
GL_POINT_SMOOTH_HINT                    equ     00C51h
GL_LINE_SMOOTH_HINT                     equ     00C52h
GL_POLYGON_SMOOTH_HINT                  equ     00C53h
GL_FOG_HINT                             equ     00C54h
GL_TEXTURE_GEN_S                        equ     00C60h
GL_TEXTURE_GEN_T                        equ     00C61h
GL_TEXTURE_GEN_R                        equ     00C62h
GL_TEXTURE_GEN_Q                        equ     00C63h
GL_PIXEL_MAP_I_TO_I                     equ     00C70h
GL_PIXEL_MAP_S_TO_S                     equ     00C71h
GL_PIXEL_MAP_I_TO_R                     equ     00C72h
GL_PIXEL_MAP_I_TO_G                     equ     00C73h
GL_PIXEL_MAP_I_TO_B                     equ     00C74h
GL_PIXEL_MAP_I_TO_A                     equ     00C75h
GL_PIXEL_MAP_R_TO_R                     equ     00C76h
GL_PIXEL_MAP_G_TO_G                     equ     00C77h
GL_PIXEL_MAP_B_TO_B                     equ     00C78h
GL_PIXEL_MAP_A_TO_A                     equ     00C79h
GL_PIXEL_MAP_I_TO_I_SIZE                equ     00CB0h
GL_PIXEL_MAP_S_TO_S_SIZE                equ     00CB1h
GL_PIXEL_MAP_I_TO_R_SIZE                equ     00CB2h
GL_PIXEL_MAP_I_TO_G_SIZE                equ     00CB3h
GL_PIXEL_MAP_I_TO_B_SIZE                equ     00CB4h
GL_PIXEL_MAP_I_TO_A_SIZE                equ     00CB5h
GL_PIXEL_MAP_R_TO_R_SIZE                equ     00CB6h
GL_PIXEL_MAP_G_TO_G_SIZE                equ     00CB7h
GL_PIXEL_MAP_B_TO_B_SIZE                equ     00CB8h
GL_PIXEL_MAP_A_TO_A_SIZE                equ     00CB9h
GL_UNPACK_SWAP_BYTES                    equ     00CF0h
GL_UNPACK_LSB_FIRST                     equ     00CF1h
GL_UNPACK_ROW_LENGTH                    equ     00CF2h
GL_UNPACK_SKIP_ROWS                     equ     00CF3h
GL_UNPACK_SKIP_PIXELS                   equ     00CF4h
GL_UNPACK_ALIGNMENT                     equ     00CF5h
GL_PACK_SWAP_BYTES                      equ     00D00h
GL_PACK_LSB_FIRST                       equ     00D01h
GL_PACK_ROW_LENGTH                      equ     00D02h
GL_PACK_SKIP_ROWS                       equ     00D03h
GL_PACK_SKIP_PIXELS                     equ     00D04h
GL_PACK_ALIGNMENT                       equ     00D05h
GL_MAP_COLOR                            equ     00D10h
GL_MAP_STENCIL                          equ     00D11h
GL_INDEX_SHIFT                          equ     00D12h
GL_INDEX_OFFSET                         equ     00D13h
GL_RED_SCALE                            equ     00D14h
GL_RED_BIAS                             equ     00D15h
GL_ZOOM_X                               equ     00D16h
GL_ZOOM_Y                               equ     00D17h
GL_GREEN_SCALE                          equ     00D18h
GL_GREEN_BIAS                           equ     00D19h
GL_BLUE_SCALE                           equ     00D1Ah
GL_BLUE_BIAS                            equ     00D1Bh
GL_ALPHA_SCALE                          equ     00D1Ch
GL_ALPHA_BIAS                           equ     00D1Dh
GL_DEPTH_SCALE                          equ     00D1Eh
GL_DEPTH_BIAS                           equ     00D1Fh
GL_MAX_EVAL_ORDER                       equ     00D30h
GL_MAX_LIGHTS                           equ     00D31h
GL_MAX_CLIP_PLANES                      equ     00D32h
GL_MAX_TEXTURE_SIZE                     equ     00D33h
GL_MAX_PIXEL_MAP_TABLE                  equ     00D34h
GL_MAX_ATTRIB_STACK_DEPTH               equ     00D35h
GL_MAX_MODELVIEW_STACK_DEPTH            equ     00D36h
GL_MAX_NAME_STACK_DEPTH                 equ     00D37h
GL_MAX_PROJECTION_STACK_DEPTH           equ     00D38h
GL_MAX_TEXTURE_STACK_DEPTH              equ     00D39h
GL_MAX_VIEWPORT_DIMS                    equ     00D3Ah
GL_MAX_CLIENT_ATTRIB_STACK_DEPTH        equ     00D3Bh
GL_SUBPIXEL_BITS                        equ     00D50h
GL_INDEX_BITS                           equ     00D51h
GL_RED_BITS                             equ     00D52h
GL_GREEN_BITS                           equ     00D53h
GL_BLUE_BITS                            equ     00D54h
GL_ALPHA_BITS                           equ     00D55h
GL_DEPTH_BITS                           equ     00D56h
GL_STENCIL_BITS                         equ     00D57h
GL_ACCUM_RED_BITS                       equ     00D58h
GL_ACCUM_GREEN_BITS                     equ     00D59h
GL_ACCUM_BLUE_BITS                      equ     00D5Ah
GL_ACCUM_ALPHA_BITS                     equ     00D5Bh
GL_NAME_STACK_DEPTH                     equ     00D70h
GL_AUTO_NORMAL                          equ     00D80h
GL_MAP1_COLOR_4                         equ     00D90h
GL_MAP1_INDEX                           equ     00D91h
GL_MAP1_NORMAL                          equ     00D92h
GL_MAP1_TEXTURE_COORD_1                 equ     00D93h
GL_MAP1_TEXTURE_COORD_2                 equ     00D94h
GL_MAP1_TEXTURE_COORD_3                 equ     00D95h
GL_MAP1_TEXTURE_COORD_4                 equ     00D96h
GL_MAP1_VERTEX_3                        equ     00D97h
GL_MAP1_VERTEX_4                        equ     00D98h
GL_MAP2_COLOR_4                         equ     00DB0h
GL_MAP2_INDEX                           equ     00DB1h
GL_MAP2_NORMAL                          equ     00DB2h
GL_MAP2_TEXTURE_COORD_1                 equ     00DB3h
GL_MAP2_TEXTURE_COORD_2                 equ     00DB4h
GL_MAP2_TEXTURE_COORD_3                 equ     00DB5h
GL_MAP2_TEXTURE_COORD_4                 equ     00DB6h
GL_MAP2_VERTEX_3                        equ     00DB7h
GL_MAP2_VERTEX_4                        equ     00DB8h
GL_MAP1_GRID_DOMAIN                     equ     00DD0h
GL_MAP1_GRID_SEGMENTS                   equ     00DD1h
GL_MAP2_GRID_DOMAIN                     equ     00DD2h
GL_MAP2_GRID_SEGMENTS                   equ     00DD3h
GL_TEXTURE_1D                           equ     00DE0h
GL_TEXTURE_2D                           equ     00DE1h
GL_FEEDBACK_BUFFER_POINTER              equ     00DF0h
GL_FEEDBACK_BUFFER_SIZE                 equ     00DF1h
GL_FEEDBACK_BUFFER_TYPE                 equ     00DF2h
GL_SELECTION_BUFFER_POINTER             equ     00DF3h
GL_SELECTION_BUFFER_SIZE                equ     00DF4h
;      GL_TEXTURE_BINDING_1D
;      GL_TEXTURE_BINDING_2D
;      GL_VERTEX_ARRAY
;      GL_NORMAL_ARRAY
;      GL_COLOR_ARRAY
;      GL_INDEX_ARRAY
;      GL_TEXTURE_COORD_ARRAY
;      GL_EDGE_FLAG_ARRAY
;      GL_VERTEX_ARRAY_SIZE
;      GL_VERTEX_ARRAY_TYPE
;      GL_VERTEX_ARRAY_STRIDE
;      GL_NORMAL_ARRAY_TYPE
;      GL_NORMAL_ARRAY_STRIDE
;      GL_COLOR_ARRAY_SIZE
;      GL_COLOR_ARRAY_TYPE
;      GL_COLOR_ARRAY_STRIDE
;      GL_INDEX_ARRAY_TYPE
;      GL_INDEX_ARRAY_STRIDE
;      GL_TEXTURE_COORD_ARRAY_SIZE
;      GL_TEXTURE_COORD_ARRAY_TYPE
;      GL_TEXTURE_COORD_ARRAY_STRIDE
;      GL_EDGE_FLAG_ARRAY_STRIDE
;      GL_POLYGON_OFFSET_FACTOR
;      GL_POLYGON_OFFSET_UNITS

; GetTextureParameter
;      GL_TEXTURE_MAG_FILTER
;      GL_TEXTURE_MIN_FILTER
;      GL_TEXTURE_WRAP_S
;      GL_TEXTURE_WRAP_T
GL_TEXTURE_WIDTH                        equ     01000h
GL_TEXTURE_HEIGHT                       equ     01001h
GL_TEXTURE_INTERNAL_FORMAT              equ     01003h
GL_TEXTURE_BORDER_COLOR                 equ     01004h
GL_TEXTURE_BORDER                       equ     01005h
;      GL_TEXTURE_RED_SIZE
;      GL_TEXTURE_GREEN_SIZE
;      GL_TEXTURE_BLUE_SIZE
;      GL_TEXTURE_ALPHA_SIZE
;      GL_TEXTURE_LUMINANCE_SIZE
;      GL_TEXTURE_INTENSITY_SIZE
;      GL_TEXTURE_PRIORITY
;      GL_TEXTURE_RESIDENT

; HintMode
GL_DONT_CARE                            equ     01100h
GL_FASTEST                              equ     01101h
GL_NICEST                               equ     01102h

; HintTarget
;      GL_PERSPECTIVE_CORRECTION_HINT
;      GL_POINT_SMOOTH_HINT
;      GL_LINE_SMOOTH_HINT
;      GL_POLYGON_SMOOTH_HINT
;      GL_FOG_HINT
;      GL_PHONG_HINT

; IndexPointerType
;      GL_SHORT
;      GL_INT
;      GL_FLOAT
;      GL_DOUBLE

; LightModelParameter
;      GL_LIGHT_MODEL_AMBIENT
;      GL_LIGHT_MODEL_LOCAL_VIEWER
;      GL_LIGHT_MODEL_TWO_SIDE

; LightName
GL_LIGHT0                               equ     04000h
GL_LIGHT1                               equ     04001h
GL_LIGHT2                               equ     04002h
GL_LIGHT3                               equ     04003h
GL_LIGHT4                               equ     04004h
GL_LIGHT5                               equ     04005h
GL_LIGHT6                               equ     04006h
GL_LIGHT7                               equ     04007h

; LightParameter
GL_AMBIENT                              equ     01200h
GL_DIFFUSE                              equ     01201h
GL_SPECULAR                             equ     01202h
GL_POSITION                             equ     01203h
GL_SPOT_DIRECTION                       equ     01204h
GL_SPOT_EXPONENT                        equ     01205h
GL_SPOT_CUTOFF                          equ     01206h
GL_CONSTANT_ATTENUATION                 equ     01207h
GL_LINEAR_ATTENUATION                   equ     01208h
GL_QUADRATIC_ATTENUATION                equ     01209h

; InterleavedArrays
;      GL_V2F
;      GL_V3F
;      GL_C4UB_V2F
;      GL_C4UB_V3F
;      GL_C3F_V3F
;      GL_N3F_V3F
;      GL_C4F_N3F_V3F
;      GL_T2F_V3F
;      GL_T4F_V4F
;      GL_T2F_C4UB_V3F
;      GL_T2F_C3F_V3F
;      GL_T2F_N3F_V3F
;      GL_T2F_C4F_N3F_V3F
;      GL_T4F_C4F_N3F_V4F

; ListMode
GL_COMPILE                              equ     01300h
GL_COMPILE_AND_EXECUTE                  equ     01301h

; ListNameType
;      GL_BYTE
;      GL_UNSIGNED_BYTE
;      GL_SHORT
;      GL_UNSIGNED_SHORT
;      GL_INT
;      GL_UNSIGNED_INT
;      GL_FLOAT
;      GL_2_BYTES
;      GL_3_BYTES
;      GL_4_BYTES

; LogicOp
GL_CLEAR                                equ     01500h
GL_AND                                  equ     01501h
GL_AND_REVERSE                          equ     01502h
GL_COPY                                 equ     01503h
GL_AND_INVERTED                         equ     01504h
GL_NOOP                                 equ     01505h
GL_XOR                                  equ     01506h
GL_OR                                   equ     01507h
GL_NOR                                  equ     01508h
GL_EQUIV                                equ     01509h
GL_INVERT                               equ     0150Ah
GL_OR_REVERSE                           equ     0150Bh
GL_COPY_INVERTED                        equ     0150Ch
GL_OR_INVERTED                          equ     0150Dh
GL_NAND                                 equ     0150Eh
GL_SET                                  equ     0150Fh

; MapTarget
;      GL_MAP1_COLOR_4
;      GL_MAP1_INDEX
;      GL_MAP1_NORMAL
;      GL_MAP1_TEXTURE_COORD_1
;      GL_MAP1_TEXTURE_COORD_2
;      GL_MAP1_TEXTURE_COORD_3
;      GL_MAP1_TEXTURE_COORD_4
;      GL_MAP1_VERTEX_3
;      GL_MAP1_VERTEX_4
;      GL_MAP2_COLOR_4
;      GL_MAP2_INDEX
;      GL_MAP2_NORMAL
;      GL_MAP2_TEXTURE_COORD_1
;      GL_MAP2_TEXTURE_COORD_2
;      GL_MAP2_TEXTURE_COORD_3
;      GL_MAP2_TEXTURE_COORD_4
;      GL_MAP2_VERTEX_3
;      GL_MAP2_VERTEX_4

; MaterialFace
;      GL_FRONT
;      GL_BACK
;      GL_FRONT_AND_BACK

; MaterialParameter
GL_EMISSION                             equ     01600h
GL_SHININESS                            equ     01601h
GL_AMBIENT_AND_DIFFUSE                  equ     01602h
GL_COLOR_INDEXES                        equ     01603h
;      GL_AMBIENT
;      GL_DIFFUSE
;      GL_SPECULAR

; MatrixMode
GL_MODELVIEW                            equ     01700h
GL_PROJECTION                           equ     01701h
GL_TEXTURE                              equ     01702h

; MeshMode1
;      GL_POINT
;      GL_LINE

; MeshMode2
;      GL_POINT
;      GL_LINE
;      GL_FILL

; NormalPointerType
;      GL_BYTE
;      GL_SHORT
;      GL_INT
;      GL_FLOAT
;      GL_DOUBLE

; PixelCopyType
GL_COLOR                                equ     01800h
GL_DEPTH                                equ     01801h
GL_STENCIL                              equ     01802h

; PixelFormat
GL_COLOR_INDEX                          equ     01900h
GL_STENCIL_INDEX                        equ     01901h
GL_DEPTH_COMPONENT                      equ     01902h
GL_RED                                  equ     01903h
GL_GREEN                                equ     01904h
GL_BLUE                                 equ     01905h
GL_ALPHA                                equ     01906h
GL_RGB                                  equ     01907h
GL_RGBA                                 equ     01908h
GL_LUMINANCE                            equ     01909h
GL_LUMINANCE_ALPHA                      equ     0190Ah

; PixelMap
;      GL_PIXEL_MAP_I_TO_I
;      GL_PIXEL_MAP_S_TO_S
;      GL_PIXEL_MAP_I_TO_R
;      GL_PIXEL_MAP_I_TO_G
;      GL_PIXEL_MAP_I_TO_B
;      GL_PIXEL_MAP_I_TO_A
;      GL_PIXEL_MAP_R_TO_R
;      GL_PIXEL_MAP_G_TO_G
;      GL_PIXEL_MAP_B_TO_B
;      GL_PIXEL_MAP_A_TO_A

; PixelStore
;      GL_UNPACK_SWAP_BYTES
;      GL_UNPACK_LSB_FIRST
;      GL_UNPACK_ROW_LENGTH
;      GL_UNPACK_SKIP_ROWS
;      GL_UNPACK_SKIP_PIXELS
;      GL_UNPACK_ALIGNMENT
;      GL_PACK_SWAP_BYTES
;      GL_PACK_LSB_FIRST
;      GL_PACK_ROW_LENGTH
;      GL_PACK_SKIP_ROWS
;      GL_PACK_SKIP_PIXELS
;      GL_PACK_ALIGNMENT

; PixelTransfer
;      GL_MAP_COLOR
;      GL_MAP_STENCIL
;      GL_INDEX_SHIFT
;      GL_INDEX_OFFSET
;      GL_RED_SCALE
;      GL_RED_BIAS
;      GL_GREEN_SCALE
;      GL_GREEN_BIAS
;      GL_BLUE_SCALE
;      GL_BLUE_BIAS
;      GL_ALPHA_SCALE
;      GL_ALPHA_BIAS
;      GL_DEPTH_SCALE
;      GL_DEPTH_BIAS

; PixelType
GL_BITMAP                               equ     01A00h
;      GL_BYTE
;      GL_UNSIGNED_BYTE
;      GL_SHORT
;      GL_UNSIGNED_SHORT
;      GL_INT
;      GL_UNSIGNED_INT
;      GL_FLOAT

; PolygonMode
GL_POINT                                equ     01B00h
GL_LINE                                 equ     01B01h
GL_FILL                                 equ     01B02h

; ReadBufferMode
;      GL_FRONT_LEFT
;      GL_FRONT_RIGHT
;      GL_BACK_LEFT
;      GL_BACK_RIGHT
;      GL_FRONT
;      GL_BACK
;      GL_LEFT
;      GL_RIGHT
;      GL_AUX0
;      GL_AUX1
;      GL_AUX2
;      GL_AUX3

; RenderingMode
GL_RENDER                               equ     01C00h
GL_FEEDBACK                             equ     01C01h
GL_SELECT                               equ     01C02h

; ShadingModel
GL_FLAT                                 equ     01D00h
GL_SMOOTH                               equ     01D01h


; StencilFunction
;      GL_NEVER
;      GL_LESS
;      GL_EQUAL
;      GL_LEQUAL
;      GL_GREATER
;      GL_NOTEQUAL
;      GL_GEQUAL
;      GL_ALWAYS

; StencilOp
;      GL_ZERO
GL_KEEP                                 equ     01E00h
GL_REPLACE                              equ     01E01h
GL_INCR                                 equ     01E02h
GL_DECR                                 equ     01E03h
;      GL_INVERT

; StringName
GL_VENDOR                               equ     01F00h
GL_RENDERER                             equ     01F01h
GL_VERSION                              equ     01F02h
GL_EXTENSIONS                           equ     01F03h

; TextureCoordName      
GL_S                                    equ     02000h
GL_T                                    equ     02001h
GL_R                                    equ     02002h
GL_Q                                    equ     02003h

; TexCoordPointerType
;      GL_SHORT
;      GL_INT
;      GL_FLOAT
;      GL_DOUBLE

; TextureEnvMode
GL_MODULATE                             equ     02100h
GL_DECAL                                equ     02101h
;      GL_BLEND
;      GL_REPLACE

; TextureEnvParameter
GL_TEXTURE_ENV_MODE                     equ     02200h
GL_TEXTURE_ENV_COLOR                    equ     02201h

; TextureEnvTarget
GL_TEXTURE_ENV                          equ     02300h

; TextureGenMode
GL_EYE_LINEAR                           equ     02400h
GL_OBJECT_LINEAR                        equ     02401h
GL_SPHERE_MAP                           equ     02402h

; TextureGenParameter
GL_TEXTURE_GEN_MODE                     equ     02500h
GL_OBJECT_PLANE                         equ     02501h
GL_EYE_PLAN                             equ     02502h

; TextureMagFilter
GL_NEAREST                              equ     02600h
GL_LINEAR                               equ     02601h

; TextureMinFilter
;      GL_NEAREST
;      GL_LINEAR
GL_NEAREST_MIPMAP_NEAREST               equ     02700h
GL_LINEAR_MIPMAP_NEAREST                equ     02701h
GL_NEAREST_MIPMAP_LINEAR                equ     02702h
GL_LINEAR_MIPMAP_LINEAR                 equ     02703h

; TextureParameterName
GL_TEXTURE_MAG_FILTER                   equ     02800h
GL_TEXTURE_MIN_FILTER                   equ     02801h
GL_TEXTURE_WRAP_S                       equ     02802h
GL_TEXTURE_WRAP_T                       equ     02803h
;      GL_TEXTURE_BORDER_COLOR
;      GL_TEXTURE_PRIORITY

; TextureTarget
;      GL_TEXTURE_1D
;      GL_TEXTURE_2D
;      GL_PROXY_TEXTURE_1D
;      GL_PROXY_TEXTURE_2D

; TextureWrapMode
GL_CLAMP                                equ     02900h
GL_REPEAT                               equ     02901h

; VertexPointerType
;      GL_SHORT
;      GL_INT
;      GL_FLOAT
;      GL_DOUBLE

; ClientAttribMask
GL_CLIENT_PIXEL_STORE_BIT               equ     000000001h
GL_CLIENT_VERTEX_ARRAY_BIT              equ     000000002h
GL_CLIENT_ALL_ATTRIB_BITS               equ     0ffffffffh

; polygon_offset
GL_POLYGON_OFFSET_FACTOR                equ     08038h
GL_POLYGON_OFFSET_UNITS                 equ     02A00h
GL_POLYGON_OFFSET_POINT                 equ     02A01h
GL_POLYGON_OFFSET_LINE                  equ     02A02h
GL_POLYGON_OFFSET_FILL                  equ     08037h

; texture
GL_ALPHA4                               equ     0803Bh
GL_ALPHA8                               equ     0803Ch
GL_ALPHA12                              equ     0803Dh
GL_ALPHA16                              equ     0803Eh
GL_LUMINANCE4                           equ     0803Fh
GL_LUMINANCE8                           equ     08040h
GL_LUMINANCE12                          equ     08041h
GL_LUMINANCE16                          equ     08042h
GL_LUMINANCE4_ALPHA4                    equ     08043h
GL_LUMINANCE6_ALPHA2                    equ     08044h
GL_LUMINANCE8_ALPHA8                    equ     08045h
GL_LUMINANCE12_ALPHA4                   equ     08046h
GL_LUMINANCE12_ALPHA12                  equ     08047h
GL_LUMINANCE16_ALPHA16                  equ     08048h
GL_INTENSITY                            equ     08049h
GL_INTENSITY4                           equ     0804Ah
GL_INTENSITY8                           equ     0804Bh
GL_INTENSITY12                          equ     0804Ch
GL_INTENSITY16                          equ     0804Dh
GL_R3_G3_B2                             equ     02A10h
GL_RGB4                                 equ     0804Fh
GL_RGB5                                 equ     08050h
GL_RGB8                                 equ     08051h
GL_RGB10                                equ     08052h
GL_RGB12                                equ     08053h
GL_RGB16                                equ     08054h
GL_RGBA2                                equ     08055h
GL_RGBA4                                equ     08056h
GL_RGB5_A1                              equ     08057h
GL_RGBA8                                equ     08058h
GL_RGB10_A2                             equ     08059h
GL_RGBA12                               equ     0805Ah
GL_RGBA16                               equ     0805Bh
GL_TEXTURE_RED_SIZE                     equ     0805Ch
GL_TEXTURE_GREEN_SIZE                   equ     0805Dh
GL_TEXTURE_BLUE_SIZE                    equ     0805Eh
GL_TEXTURE_ALPHA_SIZE                   equ     0805Fh
GL_TEXTURE_LUMINANCE_SIZE               equ     08060h
GL_TEXTURE_INTENSITY_SIZE               equ     08061h
GL_PROXY_TEXTURE_1D                     equ     08063h
GL_PROXY_TEXTURE_2D                     equ     08064h

; texture_object
GL_TEXTURE_PRIORITY                     equ     08066h
GL_TEXTURE_RESIDENT                     equ     08067h
GL_TEXTURE_BINDING_1D                   equ     08068h
GL_TEXTURE_BINDING_2D                   equ     08069h

; vertex_array
GL_VERTEX_ARRAY                         equ     08074h
GL_NORMAL_ARRAY                         equ     08075h
GL_COLOR_ARRAY                          equ     08076h
GL_INDEX_ARRAY                          equ     08077h
GL_TEXTURE_COORD_ARRAY                  equ     08078h
GL_EDGE_FLAG_ARRAY                      equ     08079h
GL_VERTEX_ARRAY_SIZE                    equ     0807Ah
GL_VERTEX_ARRAY_TYPE                    equ     0807Bh
GL_VERTEX_ARRAY_STRIDE                  equ     0807Ch
GL_NORMAL_ARRAY_TYPE                    equ     0807Eh
GL_NORMAL_ARRAY_STRIDE                  equ     0807Fh
GL_COLOR_ARRAY_SIZE                     equ     08081h
GL_COLOR_ARRAY_TYPE                     equ     08082h
GL_COLOR_ARRAY_STRIDE                   equ     08083h
GL_INDEX_ARRAY_TYPE                     equ     08085h
GL_INDEX_ARRAY_STRIDE                   equ     08086h
GL_TEXTURE_COORD_ARRAY_SIZE             equ     08088h
GL_TEXTURE_COORD_ARRAY_TYPE             equ     08089h
GL_TEXTURE_COORD_ARRAY_STRIDE           equ     0808Ah
GL_EDGE_FLAG_ARRAY_STRIDE               equ     0808Ch
GL_VERTEX_ARRAY_POINTER                 equ     0808Eh
GL_NORMAL_ARRAY_POINTER                 equ     0808Fh
GL_COLOR_ARRAY_POINTER                  equ     08090h
GL_INDEX_ARRAY_POINTER                  equ     08091h
GL_TEXTURE_COORD_ARRAY_POINTER          equ     08092h
GL_EDGE_FLAG_ARRAY_POINTER              equ     08093h
GL_V2F                                  equ     02A20h
GL_V3F                                  equ     02A21h
GL_C4UB_V2F                             equ     02A22h
GL_C4UB_V3F                             equ     02A23h
GL_C3F_V3F                              equ     02A24h
GL_N3F_V3F                              equ     02A25h
GL_C4F_N3F_V3F                          equ     02A26h
GL_T2F_V3F                              equ     02A27h
GL_T4F_V4F                              equ     02A28h
GL_T2F_C4UB_V3F                         equ     02A29h
GL_T2F_C3F_V3F                          equ     02A2Ah
GL_T2F_N3F_V3F                          equ     02A2Bh
GL_T2F_C4F_N3F_V3F                      equ     02A2Ch
GL_T4F_C4F_N3F_V4F                      equ     02A2Dh

; Extensions
GL_EXT_vertex_array                     equ     1
GL_EXT_bgra                             equ     1
GL_EXT_paletted_texture                 equ     1
GL_WIN_swap_hint                        equ     1
GL_WIN_draw_range_elements              equ     1
; GL_WIN_phong_shading              1
; GL_WIN_specular_fog               1

; EXT_vertex_array
GL_VERTEX_ARRAY_EXT                     equ     08074h
GL_NORMAL_ARRAY_EXT                     equ     08075h
GL_COLOR_ARRAY_EXT                      equ     08076h
GL_INDEX_ARRAY_EXT                      equ     08077h
GL_TEXTURE_COORD_ARRAY_EXT              equ     08078h
GL_EDGE_FLAG_ARRAY_EXT                  equ     08079h
GL_VERTEX_ARRAY_SIZE_EXT                equ     0807Ah
GL_VERTEX_ARRAY_TYPE_EXT                equ     0807Bh
GL_VERTEX_ARRAY_STRIDE_EXT              equ     0807Ch
GL_VERTEX_ARRAY_COUNT_EXT               equ     0807Dh
GL_NORMAL_ARRAY_TYPE_EXT                equ     0807Eh
GL_NORMAL_ARRAY_STRIDE_EXT              equ     0807Fh
GL_NORMAL_ARRAY_COUNT_EXT               equ     08080h
GL_COLOR_ARRAY_SIZE_EXT                 equ     08081h
GL_COLOR_ARRAY_TYPE_EXT                 equ     08082h
GL_COLOR_ARRAY_STRIDE_EXT               equ     08083h
GL_COLOR_ARRAY_COUNT_EXT                equ     08084h
GL_INDEX_ARRAY_TYPE_EXT                 equ     08085h
GL_INDEX_ARRAY_STRIDE_EXT               equ     08086h
GL_INDEX_ARRAY_COUNT_EXT                equ     08087h
GL_TEXTURE_COORD_ARRAY_SIZE_EXT         equ     08088h
GL_TEXTURE_COORD_ARRAY_TYPE_EXT         equ     08089h
GL_TEXTURE_COORD_ARRAY_STRIDE_EXT       equ     0808Ah
GL_TEXTURE_COORD_ARRAY_COUNT_EXT        equ     0808Bh
GL_EDGE_FLAG_ARRAY_STRIDE_EXT           equ     0808Ch
GL_EDGE_FLAG_ARRAY_COUNT_EXT            equ     0808Dh
GL_VERTEX_ARRAY_POINTER_EXT             equ     0808Eh
GL_NORMAL_ARRAY_POINTER_EXT             equ     0808Fh
GL_COLOR_ARRAY_POINTER_EXT              equ     08090h
GL_INDEX_ARRAY_POINTER_EXT              equ     08091h
GL_TEXTURE_COORD_ARRAY_POINTER_EXT      equ     08092h
GL_EDGE_FLAG_ARRAY_POINTER_EXT          equ     08093h
GL_DOUBLE_EXT                           equ     GL_DOUBLE

; EXT_bgra
GL_BGR_EXT                              equ     080E0h
GL_BGRA_EXT                             equ     080E1h

; EXT_paletted_texture

; These must match the GL_COLOR_TABLE_*_SGI enumerants
GL_COLOR_TABLE_FORMAT_EXT               equ     080D8h
GL_COLOR_TABLE_WIDTH_EXT                equ     080D9h
GL_COLOR_TABLE_RED_SIZE_EXT             equ     080DAh
GL_COLOR_TABLE_GREEN_SIZE_EXT           equ     080DBh
GL_COLOR_TABLE_BLUE_SIZE_EXT            equ     080DCh
GL_COLOR_TABLE_ALPHA_SIZE_EXT           equ     080DDh
GL_COLOR_TABLE_LUMINANCE_SIZE_EXT       equ     080DEh
GL_COLOR_TABLE_INTENSITY_SIZE_EXT       equ     080DFh

GL_COLOR_INDEX1_EXT                     equ     080E2h
GL_COLOR_INDEX2_EXT                     equ     080E3h
GL_COLOR_INDEX4_EXT                     equ     080E4h
GL_COLOR_INDEX8_EXT                     equ     080E5h
GL_COLOR_INDEX12_EXT                    equ     080E6h
GL_COLOR_INDEX16_EXT                    equ     080E7h

; WIN_draw_range_elements
GL_MAX_ELEMENTS_VERTICES_WIN            equ     080E8h
GL_MAX_ELEMENTS_INDICES_WIN             equ     080E9h

; WIN_phong_shading
GL_PHONG_WIN                            equ     080EAh
GL_PHONG_HINT_WIN                       equ     080EBh

; WIN_specular_fog
GL_FOG_SPECULAR_TEXTURE_WIN             equ     080ECh

; For compatibility with OpenGL v1.0
GL_LOGIC_OP                             equ     GL_INDEX_LOGIC_OP
GL_TEXTURE_COMPONENTS                   equ     GL_TEXTURE_INTERNAL_FORMAT

;************************************************************/

glAccum                 proto   :dword, :dword
glAlphaFunc             proto   :dword, :dword
glAreTexturesResident   proto   :dword, :dword, :dword
glArrayElement          proto   :dword
glBegin                 proto   :dword
glBindTexture           proto   :dword, :dword
glBitmap                proto   :dword, :dword, :dword, :dword, :dword, :dword, :dword
glBlendFunc             proto   :dword, :dword
glCallList              proto   :dword
glCallLists             proto   :dword, :dword, :dword
glClear                 proto   :dword
glClearAccum            proto   :dword, :dword, :dword, :dword
glClearColor            proto   :dword, :dword, :dword, :dword
glClearDepth            proto   :qword
glClearIndex            proto   :dword
glClearStencil          proto   :dword
glClipPlane             proto   :dword, :dword
glColor3b               proto   :dword, :dword, :dword 
glColor3bv              proto   :dword
glColor3d               proto   :qword, :qword, :qword
glColor3dv              proto   :dword
glColor3f               proto   :dword, :dword, :dword
glColor3fv              proto   :dword
glColor3i               proto   :dword, :dword, :dword
glColor3iv              proto   :dword
glColor3s               proto   :dword, :dword, :dword
glColor3sv              proto   :dword
glColor3ub              proto   :dword, :dword, :dword
glColor3ubv             proto   :dword
glColor3ui              proto   :dword, :dword, :dword
glColor3uiv             proto   :dword
glColor3us              proto   :dword, :dword, :dword
glColor3usv             proto   :dword
glColor4b               proto   :dword, :dword, :dword, :dword
glColor4bv              proto   :dword
glColor4d               proto   :qword, :qword, :qword, :qword
glColor4dv              proto   :dword
glColor4f               proto   :dword, :dword, :dword, :dword
glColor4fv              proto   :dword
glColor4i               proto   :dword, :dword, :dword, :dword
glColor4iv              proto   :dword
glColor4s               proto   :dword, :dword, :dword, :dword
glColor4sv              proto   :dword
glColor4ub              proto   :dword, :dword, :dword, :dword
glColor4ubv             proto   :dword
glColor4ui              proto   :dword, :dword, :dword, :dword
glColor4uiv             proto   :dword
glColor4us              proto   :dword, :dword, :dword, :dword
glColor4usv             proto   :dword
glColorMask             proto   :dword, :dword, :dword, :dword
glColorMaterial         proto   :dword, :dword
glColorPointer          proto   :dword, :dword, :dword, :dword
glCopyPixels            proto   :dword, :dword, :dword, :dword, :dword
glCopyTexImage1D        proto   :dword, :dword, :dword, :dword, :dword, :dword, :dword
glCopyTexImage2D        proto   :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
glCopyTexSubImage1D     proto   :dword, :dword, :dword, :dword, :dword, :dword
glCopyTexSubImage2D     proto   :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
glCullFace              proto   :dword
glDeleteLists           proto   :dword, :dword
glDeleteTextures        proto   :dword, :dword
glDepthFunc             proto   :dword
glDepthMask             proto   :dword
glDepthRange            proto   :qword, :qword
glDisable               proto   :dword
glDisableClientState    proto   :dword
glDrawArrays            proto   :dword, :dword, :dword
glDrawBuffer            proto   :dword
glDrawElements          proto   :dword, :dword, :dword, :dword
glDrawPixels            proto   :dword, :dword, :dword, :dword, :dword
glEdgeFlag              proto   :dword
glEdgeFlagPointer       proto   :dword, :dword
glEdgeFlagv             proto   :dword
glEnable                proto   :dword
glEnableClientState     proto   :dword
glEnd                   proto
glEndList               proto
glEvalCoord1d           proto   :qword
glEvalCoord1dv          proto   :qword
glEvalCoord1f           proto   :dword
glEvalCoord1fv          proto   :dword
glEvalCoord2d           proto   :qword, :qword
glEvalCoord2dv          proto   :qword
glEvalCoord2f           proto   :dword, :dword
glEvalCoord2fv          proto   :dword
glEvalMesh1             proto   :dword, :dword, :dword
glEvalMesh2             proto   :dword, :dword, :dword, :dword, :dword
glEvalPoint1            proto   :dword
glEvalPoint2            proto   :dword, :dword
glFeedbackBuffer        proto   :dword, :dword, :dword
glFinish                proto
glFlush                 proto
glFogf                  proto   :dword, :dword
glFogfv                 proto   :dword, :dword
glFogi                  proto   :dword, :dword
glFogiv                 proto   :dword, :dword
glFrontFace             proto   :dword
glFrustum               proto   :qword, :qword, :qword, :qword, :qword, :qword
glGenLists              proto   :dword
glGenTextures           proto   :dword, :dword
glGetBooleanv           proto   :dword, :dword
glGetClipPlane          proto   :dword, :qword
glGetDoublev            proto   :dword, :qword
glGetError              proto
glGetFloatv             proto   :dword, :dword
glGetIntegerv           proto   :dword, :dword
glGetLightfv            proto   :dword, :dword, :dword
glGetLightiv            proto   :dword, :dword, :dword
glGetMapdv              proto   :dword, :dword, :dword
glGetMapfv              proto   :dword, :dword, :dword
glGetMapiv              proto   :dword, :dword, :dword
glGetMaterialfv         proto   :dword, :dword, :dword
glGetMaterialiv         proto   :dword, :dword, :dword
glGetPixelMapfv         proto   :dword, :dword
glGetPixelMapuiv        proto   :dword, :dword
glGetPixelMapusv        proto   :dword, :dword
glGetPointerv           proto   :dword, :dword
glGetPolygonStipple     proto   :dword
glGetString             proto   :dword
glGetTexEnvfv           proto   :dword, :dword, :dword
glGetTexEnviv           proto   :dword, :dword, :dword
glGetTexGendv           proto   :dword, :dword, :dword
glGetTexGenfv           proto   :dword, :dword, :dword
glGetTexGeniv           proto   :dword, :dword, :dword
glGetTexImage           proto   :dword, :dword, :dword, :dword, :dword
glGetTexLevelParameterfv proto  :dword, :dword, :dword, :dword
glGetTexLevelParameteriv proto  :dword, :dword, :dword, :dword
glGetTexParameterfv     proto   :dword, :dword, :dword
glGetTexParameteriv     proto   :dword, :dword, :dword
glHint                  proto   :dword, :dword
glIndexMask             proto   :dword
glIndexPointer          proto   :dword, :dword, :dword
glIndexd                proto   :qword
glIndexdv               proto   :dword
glIndexf                proto   :dword
glIndexfv               proto   :dword
glIndexi                proto   :dword
glIndexiv               proto   :dword
glIndexs                proto   :dword
glIndexsv               proto   :dword
glIndexub               proto   :dword
glIndexubv              proto   :dword
glInitNames             proto
glInterleavedArrays     proto   :dword, :dword, :dword
glIsEnabled             proto   :dword
glIsList                proto   :dword
glIsTexture             proto   :dword
glLightModelf           proto   :dword, :dword
glLightModelfv          proto   :dword, :dword
glLightModeli           proto   :dword, :dword
glLightModeliv          proto   :dword, :dword
glLightf                proto   :dword, :dword, :dword
glLightfv               proto   :dword, :dword, :dword
glLighti                proto   :dword, :dword, :dword
glLightiv               proto   :dword, :dword, :dword
glLineStipple           proto   :dword, :dword
glLineWidth             proto   :dword
glListBase              proto   :dword
glLoadIdentity          proto
glLoadMatrixd           proto   :dword
glLoadMatrixf           proto   :dword
glLoadName              proto   :dword
glLogicOp               proto   :dword
glMap1d                 proto   :dword, :qword, :qword, :dword, :dword, :dword
glMap1f                 proto   :dword, :dword, :dword, :dword, :dword, :dword
glMap2d                 proto   :dword, :qword, :qword, :dword, :dword, :qword, :qword, :dword, :dword, :dword
glMap2f                 proto   :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
glMapGrid1d             proto   :dword, :qword, :qword
glMapGrid1f             proto   :dword, :dword, :dword
glMapGrid2d             proto   :dword, :qword, :qword, :dword, :qword, :qword
glMapGrid2f             proto   :dword, :dword, :dword, :dword, :dword, :dword
glMaterialf             proto   :dword, :dword, :dword
glMaterialfv            proto   :dword, :dword, :dword
glMateriali             proto   :dword, :dword, :dword
glMaterialiv            proto   :dword, :dword, :dword
glMatrixMode            proto   :dword
glMultMatrixd           proto   :dword
glMultMatrixf           proto   :dword
glNewList               proto   :dword, :dword
glNormal3b              proto   :dword, :dword, :dword
glNormal3bv             proto   :dword
glNormal3d              proto   :qword, :qword, :qword
glNormal3dv             proto   :dword
glNormal3f              proto   :dword, :dword, :dword
glNormal3fv             proto   :dword
glNormal3i              proto   :dword, :dword, :dword
glNormal3iv             proto   :dword
glNormal3s              proto   :dword, :dword, :dword
glNormal3sv             proto   :dword
glNormalPointer         proto   :dword, :dword, :dword
glOrtho                 proto   :qword, :qword, :qword, :qword, :qword, :qword
glPassThrough           proto   :dword
glPixelMapfv            proto   :dword, :dword, :dword
glPixelMapuiv           proto   :dword, :dword, :dword
glPixelMapusv           proto   :dword, :dword, :dword
glPixelStoref           proto   :dword, :dword
glPixelStorei           proto   :dword, :dword
glPixelTransferf        proto   :dword, :dword
glPixelTransferi        proto   :dword, :dword
glPixelZoom             proto   :dword, :dword
glPointSize             proto   :dword
glPolygonMode           proto   :dword, :dword
glPolygonOffset         proto   :dword, :dword
glPolygonStipple        proto   :dword
glPopAttrib             proto
glPopClientAttrib       proto
glPopMatrix             proto
glPopName               proto
glPrioritizeTextures    proto   :dword, :dword, :dword
glPushAttrib            proto   :dword
glPushClientAttrib      proto   :dword
glPushMatrix            proto
glPushName              proto   :dword
glRasterPos2d           proto   :qword, :qword
glRasterPos2dv          proto   :dword
glRasterPos2f           proto   :dword, :dword
glRasterPos2fv          proto   :dword
glRasterPos2i           proto   :dword, :dword
glRasterPos2iv          proto   :dword
glRasterPos2s           proto   :dword, :dword
glRasterPos2sv          proto   :dword
glRasterPos3d           proto   :qword, :qword, :qword
glRasterPos3dv          proto   :dword
glRasterPos3f           proto   :dword, :dword, :dword
glRasterPos3fv          proto   :dword
glRasterPos3i           proto   :dword, :dword, :dword
glRasterPos3iv          proto   :dword
glRasterPos3s           proto   :dword, :dword, :dword
glRasterPos3sv          proto   :dword
glRasterPos4d           proto   :qword, :qword, :qword, :qword
glRasterPos4dv          proto   :dword
glRasterPos4f           proto   :dword, :dword, :dword, :dword
glRasterPos4fv          proto   :dword
glRasterPos4i           proto   :dword, :dword, :dword, :dword
glRasterPos4iv          proto   :dword
glRasterPos4s           proto   :dword, :dword, :dword, :dword
glRasterPos4sv          proto   :dword
glReadBuffer            proto   :dword
glReadPixels            proto   :dword, :dword, :dword, :dword, :dword, :dword, :dword
glRectd                 proto   :qword, :qword, :qword, :qword
glRectdv                proto   :dword, :dword
glRectf                 proto   :dword, :dword, :dword, :dword
glRectfv                proto   :dword, :dword
glRecti                 proto   :dword, :dword, :dword, :dword
glRectiv                proto   :dword, :dword
glRects                 proto   :dword, :dword, :dword, :dword
glRectsv                proto   :dword, :dword
glRenderMode            proto   :dword
glRotated               proto   :qword, :qword, :qword, :qword
glRotatef               proto   :dword, :dword, :dword, :dword
glScaled                proto   :qword, :qword, :qword
glScalef                proto   :dword, :dword, :dword
glScissor               proto   :dword, :dword, :dword, :dword
glSelectBuffer          proto   :dword, :dword
glShadeModel            proto   :dword
glStencilFunc           proto   :dword, :dword, :dword
glStencilMask           proto   :dword
glStencilOp             proto   :dword, :dword, :dword
glTexCoord1d            proto   :qword
glTexCoord1dv           proto   :dword
glTexCoord1f            proto   :dword
glTexCoord1fv           proto   :dword
glTexCoord1i            proto   :dword
glTexCoord1iv           proto   :dword
glTexCoord1s            proto   :dword
glTexCoord1sv           proto   :dword
glTexCoord2d            proto   :qword, :qword
glTexCoord2dv           proto   :dword
glTexCoord2f            proto   :dword, :dword
glTexCoord2fv           proto   :dword
glTexCoord2i            proto   :dword, :dword
glTexCoord2iv           proto   :dword
glTexCoord2s            proto   :dword, :dword
glTexCoord2sv           proto   :dword
glTexCoord3d            proto   :qword, :qword, :qword
glTexCoord3dv           proto   :dword
glTexCoord3f            proto   :dword, :dword, :dword
glTexCoord3fv           proto   :dword
glTexCoord3i            proto   :dword, :dword, :dword
glTexCoord3iv           proto   :dword
glTexCoord3s            proto   :dword, :dword, :dword
glTexCoord3sv           proto   :dword
glTexCoord4d            proto   :qword, :qword, :qword, :qword
glTexCoord4dv           proto   :dword
glTexCoord4f            proto   :dword, :dword, :dword, :dword
glTexCoord4fv           proto   :dword
glTexCoord4i            proto   :dword, :dword, :dword, :dword
glTexCoord4iv           proto   :dword
glTexCoord4s            proto   :dword, :dword, :dword, :dword
glTexCoord4sv           proto   :dword
glTexCoordPointer       proto   :dword, :dword, :dword, :dword
glTexEnvf               proto   :dword, :dword, :dword
glTexEnvfv              proto   :dword, :dword, :dword
glTexEnvi               proto   :dword, :dword, :dword
glTexEnviv              proto   :dword, :dword, :dword
glTexGend               proto   :dword, :dword, :qword
glTexGendv              proto   :dword, :dword, :dword
glTexGenf               proto   :dword, :dword, :dword
glTexGenfv              proto   :dword, :dword, :dword
glTexGeni               proto   :dword, :dword, :dword
glTexGeniv              proto   :dword, :dword, :dword
glTexImage1D            proto   :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
glTexImage2D            proto   :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
glTexParameterf         proto   :dword, :dword, :dword
glTexParameterfv        proto   :dword, :dword, :dword
glTexParameteri         proto   :dword, :dword, :dword
glTexParameteriv        proto   :dword, :dword, :dword
glTexSubImage1D         proto   :dword, :dword, :dword, :dword, :dword, :dword, :dword
glTexSubImage2D         proto   :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword, :dword
glTranslated            proto   :qword, :qword, :qword
glTranslatef            proto   :dword, :dword, :dword
glVertex2d              proto   :qword, :qword
glVertex2dv             proto   :dword
glVertex2f              proto   :dword, :dword
glVertex2fv             proto   :dword
glVertex2i              proto   :dword, :dword
glVertex2iv             proto   :dword
glVertex2s              proto   :dword, :dword
glVertex2sv             proto   :dword
glVertex3d              proto   :qword, :qword, :qword
glVertex3dv             proto   :dword
glVertex3f              proto   :dword, :dword, :dword
glVertex3fv             proto   :dword
glVertex3i              proto   :dword, :dword, :dword
glVertex3iv             proto   :dword
glVertex3s              proto   :dword, :dword, :dword
glVertex3sv             proto   :dword
glVertex4d              proto   :qword, :qword, :qword, :qword
glVertex4dv             proto   :dword
glVertex4f              proto   :dword, :dword, :dword, :dword
glVertex4fv             proto   :dword
glVertex4i              proto   :dword, :dword, :dword, :dword
glVertex4iv             proto   :dword
glVertex4s              proto   :dword, :dword, :dword, :dword
glVertex4sv             proto   :dword
glVertexPointer         proto   :dword, :dword, :dword, :dword
glViewport              proto   :dword, :dword, :dword, :dword

; EXT_vertex_array
PFNGLARRAYELEMENTEXTPROC_proto typedef proto :dword
PFNGLARRAYELEMENTEXTPROC typedef ptr PFNGLARRAYELEMENTEXTPROC_proto
PFNGLDRAWARRAYSEXTPROC_proto typedef proto :dword, :dword, :dword
PFNGLDRAWARRAYSEXTPROC typedef ptr PFNGLDRAWARRAYSEXTPROC_proto
PFNGLVERTEXPOINTEREXTPROC_proto typedef proto   :dword, :dword, :dword, :dword, :dword
PFNGLVERTEXPOINTEREXTPROC typedef ptr PFNGLVERTEXPOINTEREXTPROC_proto
PFNGLNORMALPOINTEREXTPROC_proto typedef proto   :dword, :dword, :dword, :dword
PFNGLNORMALPOINTEREXTPROC typedef ptr PFNGLNORMALPOINTEREXTPROC_proto
PFNGLCOLORPOINTEREXTPROC_proto typedef  proto   :dword, :dword, :dword, :dword, :dword
PFNGLCOLORPOINTEREXTPROC typedef ptr PFNGLCOLORPOINTEREXTPROC_proto
PFNGLINDEXPOINTEREXTPROC_proto typedef  proto   :dword, :dword, :dword, :dword
PFNGLINDEXPOINTEREXTPROC typedef ptr PFNGLINDEXPOINTEREXTPROC_proto
PFNGLTEXCOORDPOINTEREXTPROC_proto typedef       proto   :dword, :dword, :dword, :dword, :dword
PFNGLTEXCOORDPOINTEREXTPROC typedef ptr PFNGLTEXCOORDPOINTEREXTPROC_proto
PFNGLEDGEFLAGPOINTEREXTPROC_proto typedef       proto   :dword, :dword, :dword
PFNGLEDGEFLAGPOINTEREXTPROC typedef ptr PFNGLEDGEFLAGPOINTEREXTPROC_proto
PFNGLGETPOINTERVEXTPROC_proto typedef   proto   :dword, :dword
PFNGLGETPOINTERVEXTPROC typedef ptr PFNGLGETPOINTERVEXTPROC_proto
PFNGLARRAYELEMENTARRAYEXTPROC_proto typedef     proto   :dword, :dword, :dword
PFNGLARRAYELEMENTARRAYEXTPROC typedef ptr PFNGLARRAYELEMENTARRAYEXTPROC_proto

; WIN_draw_range_elements
PFNGLDRAWRANGEELEMENTSWINPROC_proto typedef     proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLDRAWRANGEELEMENTSWINPROC typedef ptr PFNGLDRAWRANGEELEMENTSWINPROC_proto

; WIN_swap_hint
PFNGLADDSWAPHINTRECTWINPROC_proto typedef       proto :dword, :dword, :dword, :dword
PFNGLADDSWAPHINTRECTWINPROC typedef ptr PFNGLADDSWAPHINTRECTWINPROC_proto

; EXT_paletted_texture
PFNGLCOLORTABLEEXTPROC_proto typedef    proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOLORTABLEEXTPROC typedef ptr PFNGLCOLORTABLEEXTPROC_proto
PFNGLCOLORSUBTABLEEXTPROC_proto typedef proto :dword, :dword, :dword, :dword, :dword, :dword
PFNGLCOLORSUBTABLEEXTPROC typedef ptr PFNGLCOLORSUBTABLEEXTPROC_proto
PFNGLGETCOLORTABLEEXTPROC_proto typedef proto :dword, :dword, :dword, :dword
PFNGLGETCOLORTABLEEXTPROC typedef ptr PFNGLGETCOLORTABLEEXTPROC_proto
PFNGLGETCOLORTABLEPARAMETERIVEXTPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETCOLORTABLEPARAMETERIVEXTPROC typedef ptr PFNGLGETCOLORTABLEPARAMETERIVEXTPROC_proto
PFNGLGETCOLORTABLEPARAMETERFVEXTPROC_proto typedef proto :dword, :dword, :dword
PFNGLGETCOLORTABLEPARAMETERFVEXTPROC typedef ptr PFNGLGETCOLORTABLEPARAMETERFVEXTPROC_proto
