; ------------------------------------------------------
; Flat Rendering
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm

; ------------------------------------------------------
; Variables
RotX                    real4   0.0
RotXSpeed               real4   40.0
RotY                    real4   0.0
RotYSpeed               real4   30.0
RotZ                    real4   0.0
RotZSpeed               real4   50.0

lst_Sphere              dd      0
Quadric_Sphere          dd      0

Light_Position          real4   -1.0, 1.0, 0.5, 1.0
Light_Diffuse           real4   0.6, 0.8, 0.9, 1.0
Light_Ambient           real4   0.2, 0.5, 0.6, 1.0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        ; Create a sphere
                        invoke  glGenLists, 1
                        mov     lst_Sphere, eax

                        invoke  glNewList, eax, GL_COMPILE
                                invoke  gluNewQuadric
                                mov     Quadric_Sphere, eax
                                ; Note: These 2 are the default values for quadric objects
                                invoke  gluQuadricDrawStyle, Quadric_Sphere, GLU_FILL
                                invoke  gluQuadricNormals, Quadric_Sphere, GLU_SMOOTH
                                
                                invoke  gluSphere, Quadric_Sphere, CDBL(1.0), 36, 36
                        invoke  glEndList

                        invoke  glEnable, GL_LIGHTING

                        mov     eax, TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc

                        invoke  glDeleteLists, lst_Sphere, 1

                        invoke  gluDeleteQuadric, Quadric_Sphere

                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here
                        fld     RotXSpeed
                        fmul    FrameRate
                        fadd    RotX
                        fstp    RotX

                        fld     RotYSpeed
                        fmul    FrameRate
                        fadd    RotY
                        fstp    RotY

                        fld     RotZSpeed
                        fmul    FrameRate
                        fadd    RotZ
                        fstp    RotZ

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  glLightfv, GL_LIGHT0, GL_DIFFUSE, addr Light_Diffuse
                        invoke  glLightfv, GL_LIGHT0, GL_AMBIENT, addr Light_Ambient
                        invoke  glLightfv, GL_LIGHT0, GL_POSITION, addr Light_Position
                        invoke  glLightf, GL_LIGHT0, GL_QUADRATIC_ATTENUATION, CFLT(0.02)
                        invoke  glEnable, GL_LIGHT0

                        invoke  glEnable, GL_DEPTH_TEST

                        ; Draw scene here
                        invoke  glPushMatrix
                                invoke  glTranslatef, CFLT(0.0), CFLT(0.0), CFLT(-3.0)
                                invoke  glRotatef, RotX, CFLT(0.0), CFLT(1.0), CFLT(0.0)
                                invoke  glRotatef, RotY, CFLT(1.0), CFLT(0.0), CFLT(0.0)
                                invoke  glRotatef, RotZ, CFLT(0.0), CFLT(0.0), CFLT(1.0)

                                ; GL_SMOOTH is the default model
                                invoke  glShadeModel, GL_SMOOTH
                                invoke  glViewport, -200, 90, SCREEN_WIDTH, SCREEN_HEIGHT
                                invoke  glCallList, lst_Sphere

                                invoke  glShadeModel, GL_FLAT
                                invoke  glViewport, 200, -90, SCREEN_WIDTH, SCREEN_HEIGHT
                                invoke  glCallList, lst_Sphere

                        invoke  glPopMatrix

                        invoke  glViewport, 0, 0, SCREEN_WIDTH, SCREEN_HEIGHT
                        ret
Draw                    endp

end start
