; ------------------------------------------------------
; Display BMP
; Copyright (c) 2005-2016, Franck Charlet
; All rights reserved.
; ------------------------------------------------------
; buildblock RELEASE
;       CAPT %5\Release.bat
; buildblockend
; buildblock DEBUG
;       CAPT %5\Debug.bat
; buildblockend

; ------------------------------------------------------
; Constants
SCREEN_WIDTH            equ     800
SCREEN_HEIGHT           equ     600
SCREEN_BPP              equ     32

; ------------------------------------------------------
; Includes
                        include ..\Common_Src\FrameWork.asm
                        include ..\Common_Src\Bmp.asm
                        include ..\Common_Src\Textures.asm
                        include ..\Common_Src\Ortho_Matrices.asm

; ------------------------------------------------------
; Variables
Texture1                BMP     <>
Texture1_Id             dd      0

; ------------------------------------------------------
; Name: Initialize()
; Desc: Perform the various initializations
Initialize              proc

                        invoke  glClearDepth, CDBL(1.0)
                        invoke  glHint, GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST
                        invoke  glClearColor, 0, 0, 0, CFLT(1.0)
                        invoke  glEnable, GL_NORMALIZE
                        invoke  glEnable, GL_CULL_FACE

                        invoke  Load_BMP, CSTR("..\..\Media\masm32.bmp"), addr Texture1, -1
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't load texture file")
                                mov     eax, FALSE
                                ret
                        .endif
                        
                        invoke  Init_Textures_Context
                        
                        invoke  Create_2D_Texture, Texture1.Datas, Texture1._Width, TRUE, GL_RGBA, GL_RGBA
                        mov     Texture1_Id, eax
                        .if     eax == FALSE
                                invoke  Set_Error_Msg, CSTR("Can't create texture")
                                mov     eax, FALSE
                                ret
                        .endif

                        mov     eax,TRUE
                        ret
Initialize              endp

; ------------------------------------------------------
; Name: Deinitialize()
; Desc: Free allocated resources
Deinitialize            proc
                        invoke  Destroy_Texture, Texture1_Id
                        invoke  Unload_BMP, addr Texture1
                        ret
Deinitialize            endp

; ------------------------------------------------------
; Name: Update()
; Desc: Update the scene
Update                  proc    FrameRate:real4

                        ; Update scene here

                        invoke  DInput_Get_Key, DIK_ESCAPE
                        test    eax, eax
                        jz      Esc_Pressed
                        invoke  Terminate_Application
Esc_Pressed:            ret
Update                  endp

; ------------------------------------------------------
; Name: Draw()
; Desc: Draw the scene
Draw                    proc
                        invoke  glClear, GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT or GL_STENCIL_BUFFER_BIT

                        ; Draw scene here
                        invoke  Enter_2D_Mode, INT2FLT(SCREEN_WIDTH), INT2FLT(SCREEN_HEIGHT)
                                invoke  glColor4f, CFLT(1.0), CFLT(1.0), CFLT(1.0), CFLT(1.0)

                                ; Center it in the window
                                mov     ecx, Texture1._Width
                                mov     eax, SCREEN_WIDTH
                                sub     eax, ecx
                                shr     eax, 1
                                mov     ebx, SCREEN_HEIGHT
                                sub     ebx, ecx
                                shr     ebx, 1
                                invoke  Draw_2D_Quad, INT2FLT(eax), INT2FLT(ebx), INT2FLT(ecx), Texture1_Id

                        invoke  Leave_2d_Mode

                        ret
Draw                    endp

end start
