{ pdemo2.pas - A Turbo Pascal TriLZ demp program

  Use as:

  pdemo2 infile

  Where:

  infile    is the name of the M*.TXT file to be displayed.

}

uses lzcomp, crt;

var
	InLength, OutLength : word;
    InBufferPtr, OutBufferPtr : BufferTypePtr;

Function ReadBuffer(var Buffer; Size : word) : word; far;
var
	r : word;

begin
	if InLength = 0 then
    begin
    	ReadBuffer := 0;
        exit;
    end;
    if Size > InLength then
    	r := InLength
    else
    	r := Size;
    move(InBufferPtr^, Buffer, r);
    InLength := InLength - r;
    InBufferPtr := @InBufferPtr^[r];
    ReadBuffer := r
end;

Function WriteBuffer(var Buffer; Size : word) : word; far;
begin
	move(Buffer, OutBufferPtr^, Size);
    OutLength := OutLength + Size;
    OutBufferPtr := @OutBufferPtr^[Size];
	WriteBuffer := Size;
end;

var
	i, CompressedFlag : integer;
    BufferLength, cb : word;
    InBuffer, OutBuffer, Buffer : BufferTypePtr;
    txtFile : file;

begin
	LZInFunction := @ReadBuffer;
    LZOutFunction := @WriteBuffer;

    writeln('Read M*.TXT Demo Program (Pascal Version)');
    writeln('');
    if paramcount = 0 then
    begin
    	writeln('Use as:');
        writeln('');
        writeln('PDEMO2 infile');
        writeln('');
        writeln('Where:');
        writeln('');
        writeln('infile    is the name of the M*.TXT file to be displayed.');
        writeln('');
        halt(1);
    end;

    New(InBuffer);
    New(OutBuffer);
    New(Buffer);

    assign(txtfile, paramstr(1));
    reset(txtfile, 1);

    while not eof(txtfile) do
    begin
    	blockread(txtfile, InLength, sizeof(InLength), cb);
        blockread(txtfile, CompressedFlag, sizeof(CompressedFlag), cb);
        blockread(txtfile, InBuffer^, InLength, cb);
        if CompressedFlag = 1 then
        begin
        	OutLength := 0;
            InBufferPtr := InBuffer;
            OutBufferPtr := OutBuffer;
            Uncompress(Buffer^);
        end
        else
        begin
        	move(InBuffer^, OutBuffer^, InLength);
            OutLength := InLength;
        end;
        for i := 0 to OutLength - 1 do
        begin
        	if OutBuffer^[i] <> 0 then
            	Write(char(OutBuffer^[i]))
            else
            	Writeln('');
        end;
        Writeln('');
        Writeln('');
        while not keypressed do ;
        case readkey of
        	#0:
            	readkey;
            #27:
            begin
               	close(txtFile);
                exit;
            end
        end;
    end;
    close(txtFile);
end.


