{ pdemo1.pas - A Turbo Pascal TriLZ demo program

  Use as:

  pdemo1 infile

  Where:

  infile	is the name of the file to be compressed and uncompressed.

  The compressed file will be named *.TLZ and the uncompressed file will
  be named *.BAK, which will be identical to the original file, infile.
}

uses lzcomp; { Be sure to tell it we need LZCOMP.TPU }

var
	result : longint;
    buffer : BufferTypePtr;
	infile, outfile : File;

Function WriteBuffer(var buffer; size : word) : word; far;
var
	cb : word;

begin
	blockwrite(outfile, buffer, size, cb);
    WriteBuffer := cb;
end;

Function ReadBuffer(var buffer; size : word) : word; far;
var
	cb : word;
begin
	blockread(infile, buffer, size, cb);
    ReadBuffer := cb;
end;

var
	i : integer;
    originalsize : longint;
    filename, tlzfile, bakfile : string;

begin
    LZInFunction := @ReadBuffer; { Set the address of the LZ in function }
    LZOutFunction := @WriteBuffer; { Set the address of the LZ out function }

    writeln('TriLZ Demo Program (Pascal Version)');
    writeln('');
    if paramcount = 0 then
    begin
    	writeln('Use as:');
        writeln('');
        writeln('PDEMO1 infile');
		writeln('');
        writeln('Where:');
        writeln('');
        writeln('infile    is the name of the file to be compressed.');
        writeln('');
    	halt(1);
    end;

    filename := paramstr(1);
    for i := 1 to length(filename) do
    	filename[i] := upcase(filename[i]);

    if pos('.', filename) = 0 then
    begin
    	tlzfile := filename + '.TLZ';
        bakfile := filename + '.BAK';
    end
    else
    begin
    	tlzfile := copy(filename, 1, pos('.', filename)) + 'TLZ';
        bakfile := copy(filename, 1, pos('.', filename)) + 'BAK';
    end;

    New(buffer);

    Writeln('Compressing: ', filename);

	Assign(infile, filename);
    Reset(infile, 1);
    originalsize := filesize(infile);

    Assign(outfile, tlzfile);
    rewrite(outfile, 1);

    result := Compress(buffer^);

    close(outfile);
    close(infile);

    writeln('');
    writeln('Original File Size  : ', originalsize);
    writeln('Compressed File Size: ', result);
    writeln('Percent Compression : ', 100 - (result / originalsize * 100):1:1,'%');
	writeln('');

    writeln('Uncompressing: ', tlzfile);

    Assign(infile, tlzfile);
    reset(infile, 1);
    assign(outfile, bakfile);
    rewrite(outfile, 1);

     result := Uncompress(buffer^);

    close(outfile);
    close(infile);

    writeln('');
end.