/*
 cdemo2.c - A C TriLZ demo program

 Use as:

 cdemo2 infile

 Where:

 infile    is the name of the M*.TXT file to be displayed.

 This program must be compiled using the large memory model!
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include "compress.h"

unsigned InLength, OutLength;
unsigned char *InBufferPtr, *OutBufferPtr;

unsigned pascal ReadBuffer(unsigned char *Buffer, unsigned Size)
{
	unsigned Read;

	if (!InLength)
		return 0;
	if (Size > InLength)
		Read = InLength;
	else
		Read = Size;
	memmove(Buffer, InBufferPtr, Read);
	InLength -= Read;
	InBufferPtr += Read;
	return Read;
}

unsigned pascal WriteBuffer(unsigned char *Buffer, unsigned Size)
{
	memmove(OutBufferPtr, Buffer, Size);
	OutLength += Size;
	OutBufferPtr += Size;
	return Size;
}

void main(int argc, char*argv[])
{
	int i, CompressedFlag;
	unsigned Length;
	unsigned char *InBuffer, *OutBuffer, *Buffer;
	FILE *File;

	printf("Read M*.TXT Demo Program (C Version)\n\n");
	if (argc == 1) {
		printf("Use as:\n\n");
		printf("CDEMO2 infile\n\n");
		printf("Where:\n\n");
		printf("infile    is the name of the M*.TXT file to be displayed.\n\n");
		exit(1);
	}

	InBuffer = (unsigned char *)malloc(40000U);
	OutBuffer = (unsigned char *)malloc(40000U);
	Buffer = (unsigned char *)malloc(40000U);

	if ((File = fopen(argv[1], "rb")) == NULL) {
		printf("Unable to open: %s\n", argv[1]);
		exit(1);
	}

	while (!feof(File)) {
		fread(&InLength, sizeof(InLength), 1, File);
		fread(&CompressedFlag, sizeof(CompressedFlag), 1, File);
		fread(InBuffer, InLength, 1, File);
		if (CompressedFlag) {
			OutLength = 0;
			InBufferPtr = InBuffer;
			OutBufferPtr = OutBuffer;
			Uncompress(Buffer);
		}
		else {
			memmove(OutBuffer, InBuffer, InLength);
			OutLength = InLength;
		}
		for (i = 0; i < OutLength; i++) {
			if (OutBuffer[i])
				putch(OutBuffer[i]);
			else
				printf("\n");
		}
		printf("\n\n");
		while (!kbhit()) ;
		switch (getch()) {
			case 0:
				getch();
				break;
			case 27:
				fclose(File);
				exit(0);
		}
	}
	fclose(File);
	exit(0);
}

