REM Remember that you need to check errorlevels in descending order.  A
REM typical batch file to run CountEm in your event might look like this:

@ECHO OFF
C:
CD\PCB

COUNTEM

        if errorlevel   16      goto    MEM
        if errorlevel   15      goto    MEM
        if errorlevel   14      goto    OPEN
        if errorlevel   13      goto    OPEN
        if errorlevel   12      goto    OPEN
        if errorlevel   11      goto    WRITE
        if errorlevel   10      goto    BADREG
        if errorlevel    9      goto    SEEK
        if errorlevel    8      goto    MEM
        if errorlevel    7      goto    DIRS
        if errorlevel    6      goto    CONF
        if errorlevel    5      goto    READ
        if errorlevel    4      goto    CLOSE
        if errorlevel    3      goto    OPEN
        if errorlevel    2      goto    OPEN
        if errorlevel    1      goto    WIND
        if errorlevel    0      goto    NORM

:OPEN
    ECHO CountEm unable to OPEN a file! > COUNTEM.LOG
    goto END

:CLOSE
    ECHO CountEm was unable to CLOSE a file! > COUNTEM.LOG
    goto END

:READ
    ECHO CountEm was unable to READ a file! > COUNTEM.LOG
    goto END

:CONF
    ECHO CountEm reported TOO MANY CONFERENCES! > COUNTEM.LOG
    goto END

:DIRS
    ECHO CountEm reported TOO MANY DIRECTORIES! > COUNTEM.LOG
    goto END

:MEM
    ECHO CountEm reported MEMORY ALLOCATION ERROR! > COUNTEM.LOG
    goto END

:BADREG
    ECHO CountEm reported BAD REGISTRATION NUMBER! > COUNTEM.LOG
    goto END

:SEEK
    ECHO CountEm reported SEEK ERROR! > COUNTEM.LOG
    goto END

:WIND
    ECHO CountEm reported WINDOWING ERROR! > COUNTEM.LOG
    goto END

:NORM
    ECHO CountEm processing finished normally > COUNTEM.LOG

:END
