/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.math;

import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.VectorUtil;

public class Quaternion {
    private float x;
    private float y;
    private float z;
    private float w;
    public static final float ALLOWED_DEVIANCE = 1.0E-6f;

    public Quaternion() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
    }

    public Quaternion(Quaternion quaternion) {
        this.set(quaternion);
    }

    public Quaternion(float f, float f2, float f3, float f4) {
        this.set(f, f2, f3, f4);
    }

    public final float magnitudeSquared() {
        return this.w * this.w + this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final float magnitude() {
        float f = this.magnitudeSquared();
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            return 0.0f;
        }
        if (FloatUtil.isEqual(1.0f, f, 1.1920929E-7f)) {
            return 1.0f;
        }
        return FloatUtil.sqrt(f);
    }

    public final float getW() {
        return this.w;
    }

    public final void setW(float f) {
        this.w = f;
    }

    public final float getX() {
        return this.x;
    }

    public final void setX(float f) {
        this.x = f;
    }

    public final float getY() {
        return this.y;
    }

    public final void setY(float f) {
        this.y = f;
    }

    public final float getZ() {
        return this.z;
    }

    public final void setZ(float f) {
        this.z = f;
    }

    public final float dot(float f, float f2, float f3, float f4) {
        return this.x * f + this.y * f2 + this.z * f3 + this.w * f4;
    }

    public final float dot(Quaternion quaternion) {
        return this.dot(quaternion.getX(), quaternion.getY(), quaternion.getZ(), quaternion.getW());
    }

    public final boolean isIdentity() {
        return FloatUtil.isEqual(1.0f, this.w, 1.1920929E-7f) && VectorUtil.isZero(this.x, this.y, this.z, 1.1920929E-7f);
    }

    public final Quaternion setIdentity() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
        return this;
    }

    public final Quaternion normalize() {
        float f = this.magnitude();
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            this.setIdentity();
        } else {
            float f2 = 1.0f / f;
            this.w *= f2;
            this.x *= f2;
            this.y *= f2;
            this.z *= f2;
        }
        return this;
    }

    public Quaternion conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public final Quaternion invert() {
        float f = this.magnitudeSquared();
        if (FloatUtil.isEqual(1.0f, f, 1.1920929E-7f)) {
            this.conjugate();
        } else {
            float f2 = 1.0f / f;
            this.w *= f2;
            this.x = -this.x * f2;
            this.y = -this.y * f2;
            this.z = -this.z * f2;
        }
        return this;
    }

    public final Quaternion set(Quaternion quaternion) {
        this.x = quaternion.x;
        this.y = quaternion.y;
        this.z = quaternion.z;
        this.w = quaternion.w;
        return this;
    }

    public final Quaternion set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
        return this;
    }

    public final Quaternion add(Quaternion quaternion) {
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
        this.w += quaternion.w;
        return this;
    }

    public final Quaternion subtract(Quaternion quaternion) {
        this.x -= quaternion.x;
        this.y -= quaternion.y;
        this.z -= quaternion.z;
        this.w -= quaternion.w;
        return this;
    }

    public final Quaternion mult(Quaternion quaternion) {
        return this.set(this.w * quaternion.x + this.x * quaternion.w + this.y * quaternion.z - this.z * quaternion.y, this.w * quaternion.y - this.x * quaternion.z + this.y * quaternion.w + this.z * quaternion.x, this.w * quaternion.z + this.x * quaternion.y - this.y * quaternion.x + this.z * quaternion.w, this.w * quaternion.w - this.x * quaternion.x - this.y * quaternion.y - this.z * quaternion.z);
    }

    public final Quaternion scale(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
        return this;
    }

    public Quaternion rotateByAngleNormalAxis(float f, float f2, float f3, float f4) {
        if (VectorUtil.isZero(f2, f3, f4, 1.1920929E-7f)) {
            return this;
        }
        float f5 = 0.5f * f;
        float f6 = FloatUtil.sin(f5);
        float f7 = FloatUtil.cos(f5);
        float f8 = f6 * f2;
        float f9 = f6 * f3;
        float f10 = f6 * f4;
        return this.set(this.x * f7 + this.y * f10 - this.z * f9 + this.w * f8, -this.x * f10 + this.y * f7 + this.z * f8 + this.w * f9, this.x * f9 - this.y * f8 + this.z * f7 + this.w * f10, -this.x * f8 - this.y * f9 - this.z * f10 + this.w * f7);
    }

    public Quaternion rotateByAngleX(float f) {
        float f2 = 0.5f * f;
        float f3 = FloatUtil.sin(f2);
        float f4 = FloatUtil.cos(f2);
        return this.set(this.x * f4 + this.w * f3, this.y * f4 + this.z * f3, -this.y * f3 + this.z * f4, -this.x * f3 + this.w * f4);
    }

    public Quaternion rotateByAngleY(float f) {
        float f2 = 0.5f * f;
        float f3 = FloatUtil.sin(f2);
        float f4 = FloatUtil.cos(f2);
        return this.set(this.x * f4 - this.z * f3, this.y * f4 + this.w * f3, this.x * f3 + this.z * f4, -this.y * f3 + this.w * f4);
    }

    public Quaternion rotateByAngleZ(float f) {
        float f2 = 0.5f * f;
        float f3 = FloatUtil.sin(f2);
        float f4 = FloatUtil.cos(f2);
        return this.set(this.x * f4 + this.y * f3, -this.x * f3 + this.y * f4, this.z * f4 + this.w * f3, -this.z * f3 + this.w * f4);
    }

    public final Quaternion rotateByEuler(float[] fArray) {
        return this.rotateByEuler(fArray[0], fArray[1], fArray[2]);
    }

    public final Quaternion rotateByEuler(float f, float f2, float f3) {
        if (VectorUtil.isZero(f, f2, f3, 1.1920929E-7f)) {
            return this;
        }
        return this.rotateByAngleY(f2).rotateByAngleZ(f3).rotateByAngleX(f).normalize();
    }

    public final float[] rotateVector(float[] fArray, int n, float[] fArray2, int n2) {
        if (VectorUtil.isVec3Zero(fArray2, n2, 1.1920929E-7f)) {
            fArray[0 + n] = 0.0f;
            fArray[1 + n] = 0.0f;
            fArray[2 + n] = 0.0f;
        } else {
            float f = fArray2[0 + n2];
            float f2 = fArray2[1 + n2];
            float f3 = fArray2[2 + n2];
            float f4 = this.x * this.x;
            float f5 = this.y * this.y;
            float f6 = this.z * this.z;
            float f7 = this.w * this.w;
            fArray[0 + n] = f7 * f + f4 * f - f6 * f - f5 * f + 2.0f * (this.y * this.w * f3 - this.z * this.w * f2 + this.y * this.x * f2 + this.z * this.x * f3);
            fArray[1 + n] = f5 * f2 - f6 * f2 + f7 * f2 - f4 * f2 + 2.0f * (this.x * this.y * f + this.z * this.y * f3 + this.w * this.z * f - this.x * this.w * f3);
            fArray[2 + n] = f6 * f3 - f5 * f3 - f4 * f3 + f7 * f3 + 2.0f * (this.x * this.z * f + this.y * this.z * f2 - this.w * this.y * f + this.w * this.x * f2);
        }
        return fArray;
    }

    public final Quaternion setSlerp(Quaternion quaternion, Quaternion quaternion2, float f) {
        if (f == 0.0f) {
            this.set(quaternion);
        } else if (f == 1.0f) {
            this.set(quaternion2);
        } else {
            float f2;
            float f3;
            float f4 = quaternion2.x;
            float f5 = quaternion2.y;
            float f6 = quaternion2.z;
            float f7 = quaternion2.w;
            float f8 = quaternion.x * f4 + quaternion.y * f5 + quaternion.z * f6 + quaternion.w * f7;
            if (f8 >= 0.95f) {
                f3 = 1.0f - f;
                f2 = f;
            } else if (f8 <= -0.99f) {
                f3 = 0.5f;
                f2 = 0.5f;
            } else {
                if (f8 <= -1.1920929E-7f) {
                    f4 *= -1.0f;
                    f5 *= -1.0f;
                    f6 *= -1.0f;
                    f7 *= -1.0f;
                    f8 *= -1.0f;
                }
                float f9 = FloatUtil.acos(f8);
                float f10 = FloatUtil.sqrt(1.0f - f8 * f8);
                if (Math.abs(f10) < 0.001f) {
                    f3 = 0.5f;
                    f2 = 0.5f;
                } else {
                    f3 = FloatUtil.sin((1.0f - f) * f9) / f10;
                    f2 = FloatUtil.sin(f * f9) / f10;
                }
            }
            this.x = quaternion.x * f3 + f4 * f2;
            this.y = quaternion.y * f3 + f5 * f2;
            this.z = quaternion.z * f3 + f6 * f2;
            this.w = quaternion.w * f3 + f7 * f2;
        }
        return this;
    }

    public Quaternion setLookAt(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5) {
        VectorUtil.normalizeVec3(fArray5, fArray);
        VectorUtil.normalizeVec3(fArray4, fArray2);
        VectorUtil.crossVec3(fArray3, fArray4, fArray5);
        VectorUtil.normalizeVec3(fArray3);
        VectorUtil.crossVec3(fArray4, fArray5, fArray3);
        VectorUtil.normalizeVec3(fArray4);
        return this.setFromAxes(fArray3, fArray4, fArray5).normalize();
    }

    public final Quaternion setFromVectors(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        float f = VectorUtil.normVec3(fArray) * VectorUtil.normVec3(fArray2);
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            return this.setIdentity();
        }
        float f2 = VectorUtil.dotVec3(fArray, fArray2) / f;
        float f3 = FloatUtil.acos(Math.max(-1.0f, Math.min(f2, 1.0f)));
        VectorUtil.crossVec3(fArray3, fArray, fArray2);
        if (f2 < 0.0f && FloatUtil.isZero(VectorUtil.normVec3(fArray3), 1.1920929E-7f)) {
            int n = Math.abs(fArray[0]) > Math.abs(fArray[1]) ? (Math.abs(fArray[0]) > Math.abs(fArray[2]) ? 0 : 2) : (Math.abs(fArray[1]) > Math.abs(fArray[2]) ? 1 : 2);
            fArray3[n] = -fArray[(n + 1) % 3];
            fArray3[(n + 1) % 3] = fArray[n];
            fArray3[(n + 2) % 3] = 0.0f;
        }
        return this.setFromAngleAxis(f3, fArray3, fArray4);
    }

    public final Quaternion setFromNormalVectors(float[] fArray, float[] fArray2, float[] fArray3) {
        float f = VectorUtil.normVec3(fArray) * VectorUtil.normVec3(fArray2);
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            return this.setIdentity();
        }
        float f2 = VectorUtil.dotVec3(fArray, fArray2) / f;
        float f3 = FloatUtil.acos(Math.max(-1.0f, Math.min(f2, 1.0f)));
        VectorUtil.crossVec3(fArray3, fArray, fArray2);
        if (f2 < 0.0f && FloatUtil.isZero(VectorUtil.normVec3(fArray3), 1.1920929E-7f)) {
            int n = Math.abs(fArray[0]) > Math.abs(fArray[1]) ? (Math.abs(fArray[0]) > Math.abs(fArray[2]) ? 0 : 2) : (Math.abs(fArray[1]) > Math.abs(fArray[2]) ? 1 : 2);
            fArray3[n] = -fArray[(n + 1) % 3];
            fArray3[(n + 1) % 3] = fArray[n];
            fArray3[(n + 2) % 3] = 0.0f;
        }
        return this.setFromAngleNormalAxis(f3, fArray3);
    }

    public final Quaternion setFromAngleAxis(float f, float[] fArray, float[] fArray2) {
        VectorUtil.normalizeVec3(fArray2, fArray);
        return this.setFromAngleNormalAxis(f, fArray2);
    }

    public final Quaternion setFromAngleNormalAxis(float f, float[] fArray) {
        if (VectorUtil.isVec3Zero(fArray, 0, 1.1920929E-7f)) {
            this.setIdentity();
        } else {
            float f2 = f * 0.5f;
            float f3 = FloatUtil.sin(f2);
            this.x = fArray[0] * f3;
            this.y = fArray[1] * f3;
            this.z = fArray[2] * f3;
            this.w = FloatUtil.cos(f2);
        }
        return this;
    }

    public final float toAngleAxis(float[] fArray) {
        float f;
        float f2 = this.x * this.x + this.y * this.y + this.z * this.z;
        if (FloatUtil.isZero(f2, 1.1920929E-7f)) {
            f = 0.0f;
            fArray[0] = 1.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
        } else {
            f = FloatUtil.acos(this.w) * 2.0f;
            float f3 = 1.0f / FloatUtil.sqrt(f2);
            fArray[0] = this.x * f3;
            fArray[1] = this.y * f3;
            fArray[2] = this.z * f3;
        }
        return f;
    }

    public final Quaternion setFromEuler(float[] fArray) {
        return this.setFromEuler(fArray[0], fArray[1], fArray[2]);
    }

    public final Quaternion setFromEuler(float f, float f2, float f3) {
        if (VectorUtil.isZero(f, f2, f3, 1.1920929E-7f)) {
            return this.setIdentity();
        }
        float f4 = f2 * 0.5f;
        float f5 = FloatUtil.sin(f4);
        float f6 = FloatUtil.cos(f4);
        f4 = f3 * 0.5f;
        float f7 = FloatUtil.sin(f4);
        float f8 = FloatUtil.cos(f4);
        f4 = f * 0.5f;
        float f9 = FloatUtil.sin(f4);
        float f10 = FloatUtil.cos(f4);
        float f11 = f6 * f8;
        float f12 = f5 * f7;
        float f13 = f6 * f7;
        float f14 = f5 * f8;
        this.w = f11 * f10 - f12 * f9;
        this.x = f11 * f9 + f12 * f10;
        this.y = f14 * f10 + f13 * f9;
        this.z = f13 * f10 - f14 * f9;
        return this.normalize();
    }

    public float[] toEuler(float[] fArray) {
        float f = this.x * this.y + this.z * this.w;
        float f2 = this.x * this.x;
        float f3 = this.y * this.y;
        float f4 = this.z * this.z;
        float f5 = this.w * this.w;
        float f6 = f2 + f3 + f4 + f5;
        if (f > 0.499f * f6) {
            fArray[0] = 0.0f;
            fArray[1] = 2.0f * FloatUtil.atan2(this.x, this.w);
            fArray[2] = 1.5707964f;
        } else if (f < -0.499f * f6) {
            fArray[0] = 0.0f;
            fArray[1] = -2.0f * FloatUtil.atan2(this.x, this.w);
            fArray[2] = -1.5707964f;
        } else {
            fArray[0] = FloatUtil.atan2(2.0f * this.x * this.w - 2.0f * this.y * this.z, -f2 + f3 - f4 + f5);
            fArray[1] = FloatUtil.atan2(2.0f * this.y * this.w - 2.0f * this.x * this.z, f2 - f3 - f4 + f5);
            fArray[2] = FloatUtil.asin(2.0f * f / f6);
        }
        return fArray;
    }

    public final Quaternion setFromMatrix(float[] fArray, int n) {
        return this.setFromMatrix(fArray[0 + n], fArray[4 + n], fArray[8 + n], fArray[1 + n], fArray[5 + n], fArray[9 + n], fArray[2 + n], fArray[6 + n], fArray[10 + n]);
    }

    public Quaternion setFromMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f + f5 + f9 + 1.0f;
        if (f10 > 0.0f) {
            float f11 = 0.5f / FloatUtil.sqrt(f10);
            this.w = 0.25f / f11;
            this.x = (f8 - f6) * f11;
            this.y = (f3 - f7) * f11;
            this.z = (f4 - f2) * f11;
        } else if (f > f5 && f > f9) {
            float f12 = 0.5f / FloatUtil.sqrt(1.0f + f - f5 - f9);
            this.w = (f8 - f6) * f12;
            this.x = 0.25f / f12;
            this.y = (f4 + f2) * f12;
            this.z = (f3 + f7) * f12;
        } else if (f5 > f9) {
            float f13 = 0.5f / FloatUtil.sqrt(1.0f + f5 - f - f9);
            this.w = (f3 - f7) * f13;
            this.x = (f7 + f2) * f13;
            this.y = 0.25f / f13;
            this.z = (f8 + f6) * f13;
        } else {
            float f14 = 0.5f / FloatUtil.sqrt(1.0f + f9 - f - f5);
            this.w = (f4 - f2) * f14;
            this.x = (f3 + f7) * f14;
            this.y = (f8 + f6) * f14;
            this.z = 0.25f / f14;
        }
        return this;
    }

    public final float[] toMatrix(float[] fArray, int n) {
        float f = this.magnitudeSquared();
        if (FloatUtil.isZero(f, 1.1920929E-7f)) {
            return FloatUtil.makeIdentity(fArray, n);
        }
        float f2 = FloatUtil.isEqual(1.0f, f, 1.1920929E-7f) ? 2.0f : 2.0f / f;
        float f3 = f2 * this.x;
        float f4 = f2 * this.y;
        float f5 = f2 * this.z;
        float f6 = this.x * f3;
        float f7 = this.x * f4;
        float f8 = this.x * f5;
        float f9 = f3 * this.w;
        float f10 = this.y * f4;
        float f11 = this.y * f5;
        float f12 = f4 * this.w;
        float f13 = this.z * f5;
        float f14 = f5 * this.w;
        fArray[0 + n] = 1.0f - (f10 + f13);
        fArray[4 + n] = f7 - f14;
        fArray[8 + n] = f8 + f12;
        fArray[12 + n] = 0.0f;
        fArray[1 + n] = f7 + f14;
        fArray[5 + n] = 1.0f - (f6 + f13);
        fArray[9 + n] = f11 - f9;
        fArray[13 + n] = 0.0f;
        fArray[2 + n] = f8 - f12;
        fArray[6 + n] = f11 + f9;
        fArray[10 + n] = 1.0f - (f6 + f10);
        fArray[14 + n] = 0.0f;
        fArray[3 + n] = 0.0f;
        fArray[7 + n] = 0.0f;
        fArray[11 + n] = 0.0f;
        fArray[15 + n] = 1.0f;
        return fArray;
    }

    public float[] copyMatrixColumn(int n, float[] fArray, int n2) {
        float f = this.magnitudeSquared();
        float f2 = FloatUtil.isZero(f, 1.1920929E-7f) ? 0.0f : (FloatUtil.isEqual(1.0f, f, 1.1920929E-7f) ? 2.0f : 2.0f / f);
        float f3 = this.x * f2;
        float f4 = this.y * f2;
        float f5 = this.z * f2;
        float f6 = this.x * f3;
        float f7 = this.x * f4;
        float f8 = this.x * f5;
        float f9 = this.w * f3;
        float f10 = this.y * f4;
        float f11 = this.y * f5;
        float f12 = this.w * f4;
        float f13 = this.z * f5;
        float f14 = this.w * f5;
        switch (n) {
            case 0: {
                fArray[0 + n2] = 1.0f - (f10 + f13);
                fArray[1 + n2] = f7 + f14;
                fArray[2 + n2] = f8 - f12;
                break;
            }
            case 1: {
                fArray[0 + n2] = f7 - f14;
                fArray[1 + n2] = 1.0f - (f6 + f13);
                fArray[2 + n2] = f11 + f9;
                break;
            }
            case 2: {
                fArray[0 + n2] = f8 + f12;
                fArray[1 + n2] = f11 - f9;
                fArray[2 + n2] = 1.0f - (f6 + f10);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column index. " + n);
            }
        }
        return fArray;
    }

    public final Quaternion setFromAxes(float[] fArray, float[] fArray2, float[] fArray3) {
        return this.setFromMatrix(fArray[0], fArray2[0], fArray3[0], fArray[1], fArray2[1], fArray3[1], fArray[2], fArray2[2], fArray3[2]);
    }

    public void toAxes(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        this.toMatrix(fArray4, 0);
        FloatUtil.copyMatrixColumn(fArray4, 0, 2, fArray3, 0);
        FloatUtil.copyMatrixColumn(fArray4, 0, 1, fArray2, 0);
        FloatUtil.copyMatrixColumn(fArray4, 0, 0, fArray, 0);
    }

    public final boolean isRotationMatrix3f(float[] fArray) {
        if (FloatUtil.abs(fArray[0] * fArray[3] + fArray[3] * fArray[4] + fArray[6] * fArray[7]) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[0] * fArray[2] + fArray[3] * fArray[5] + fArray[6] * fArray[8]) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[1] * fArray[2] + fArray[4] * fArray[5] + fArray[7] * fArray[8]) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[0] * fArray[0] + fArray[3] * fArray[3] + fArray[6] * fArray[6] - 1.0f) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[1] * fArray[1] + fArray[4] * fArray[4] + fArray[7] * fArray[7] - 1.0f) > 0.01f) {
            return false;
        }
        if (FloatUtil.abs(fArray[2] * fArray[2] + fArray[5] * fArray[5] + fArray[8] * fArray[8] - 1.0f) > 0.01f) {
            return false;
        }
        return FloatUtil.abs(this.determinant3f(fArray) - 1.0f) < 0.01f;
    }

    private final float determinant3f(float[] fArray) {
        return fArray[0] * fArray[4] * fArray[8] + fArray[3] * fArray[7] * fArray[2] + fArray[6] * fArray[1] * fArray[5] - fArray[0] * fArray[7] * fArray[5] - fArray[3] * fArray[1] * fArray[8] - fArray[6] * fArray[4] * fArray[2];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Quaternion)) {
            return false;
        }
        Quaternion quaternion = (Quaternion)object;
        return Math.abs(this.x - quaternion.getX()) <= 1.0E-6f && Math.abs(this.y - quaternion.getY()) <= 1.0E-6f && Math.abs(this.z - quaternion.getZ()) <= 1.0E-6f && Math.abs(this.w - quaternion.getW()) <= 1.0E-6f;
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }

    public String toString() {
        return "Quaternion[x " + this.x + ", y " + this.y + ", z " + this.z + ", w " + this.w + "]";
    }
}

