/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import hypermedia.net.UDP;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;
import processing.data.JSONArray;
import processing.data.JSONObject;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PShader;

public class Instanssi2023
extends PApplet {
    Moonlander moonlander;
    PShape horn;
    PShape star;
    PShape spitor;
    PImage img_animals;
    PShader feedback;
    PShader raymarch;
    PImage screenShot;
    PGraphics pg;
    PImage[] sprites;
    UDP myClient;
    boolean simulation = true;
    boolean isPlayer = true;
    String[] texts = new String[]{"the Summer of 2001", "IVORY", "INSTANSSI", "2023", "the warm rain", "touching my lips", "the smell of grass", "the heat of the sun", "thank you for the memories"};
    ArrayList<Byte> lampdata;
    Minim minim;
    AudioPlayer player;
    TreeMap<String, SyncParameter> parameters = new TreeMap();
    JSONObject json;
    double recordTimer = 0.0;
    boolean isgoing = false;
    boolean asked = false;
    int valoupdate = 0;

    public void startLamp() {
        this.lampdata = new ArrayList();
        this.lampdata.add((byte)1);
        this.lampdata.add((byte)0);
        this.lampdata.add((byte)101);
        this.lampdata.add((byte)112);
        this.lampdata.add((byte)101);
        this.lampdata.add((byte)108);
        this.lampdata.add((byte)105);
        this.lampdata.add((byte)0);
    }

    public void endLamp() {
        if (!this.simulation) {
            byte[] arr = new byte[this.lampdata.size()];
            int i = 0;
            while (i < this.lampdata.size()) {
                arr[i] = this.lampdata.get(i);
                ++i;
            }
            this.myClient.send(arr, "10.10.69.2", 9909);
        }
    }

    public void setLamp(int lampNum, int r, int g, int b) {
        if (!this.simulation) {
            this.lampdata.add((byte)1);
            this.lampdata.add((byte)lampNum);
            this.lampdata.add((byte)0);
            this.lampdata.add((byte)r);
            this.lampdata.add((byte)g);
            this.lampdata.add((byte)b);
        }
    }

    public double getValueFromRocket(String variableName) {
        if (!this.isPlayer) {
            float time = (float)this.moonlander.getCurrentTime();
            float value = (float)this.moonlander.getValue(variableName);
            if (this.parameters.containsKey(variableName)) {
                SyncParameter syncParam = this.parameters.get(variableName);
                if (!syncParam.data.containsKey(Float.valueOf(time))) {
                    syncParam.data.put(Float.valueOf(time), Float.valueOf(value));
                }
            } else {
                this.parameters.put(variableName, new SyncParameter(variableName));
            }
            return value;
        }
        SyncParameter syncParam = this.parameters.get(variableName);
        float currentTime = (float)this.player.position() / 1000.0f;
        for (Map.Entry<Float, Float> frame : syncParam.data.entrySet()) {
            if (!(frame.getKey().floatValue() >= currentTime)) continue;
            float currentValue = frame.getValue().floatValue();
            return currentValue;
        }
        return 0.0;
    }

    public static TreeMap sortbykey(Map map) {
        TreeMap sorted = new TreeMap();
        sorted.putAll(map);
        return sorted;
    }

    public void stop() {
        this.json = new JSONObject();
        JSONArray jsonParameters = new JSONArray();
        int i = 0;
        for (Map.Entry<String, SyncParameter> parameter : this.parameters.entrySet()) {
            String parameterName = parameter.getKey();
            SyncParameter syncParam = parameter.getValue();
            JSONObject sync = new JSONObject();
            JSONArray syncArray = new JSONArray();
            TreeMap sorted = Instanssi2023.sortbykey(syncParam.data);
            int j = 0;
            for (Map.Entry synkki : sorted.entrySet()) {
                JSONObject syncData = new JSONObject();
                float time = ((Float)synkki.getKey()).floatValue();
                float value = ((Float)synkki.getValue()).floatValue();
                syncData.setFloat("Time", time);
                syncData.setFloat("Value", value);
                syncArray.setJSONObject(j++, syncData);
            }
            sync.setString("Name", parameterName);
            sync.setJSONArray("SyncArray", syncArray);
            jsonParameters.setJSONObject(i++, sync);
        }
        this.json.setJSONArray("Parameters", jsonParameters);
        this.saveJSONObject(this.json, "sync.json");
    }

    public void setup() {
        this.noCursor();
        PFont font = this.createFont("SF_Square_Head.ttf", 48.0f);
        this.feedback = this.loadShader("feedback.glsl");
        this.raymarch = this.loadShader("raymarch.glsl");
        this.img_animals = this.loadImage("animals.png");
        this.sprites = new PImage[7];
        int i = 0;
        while (i < 7) {
            this.sprites[i] = this.loadImage("sprite" + i + ".png");
            ++i;
        }
        this.horn = this.loadShape("torvi.obj");
        this.star = this.loadShape("star.obj");
        this.spitor = this.loadShape("spirtor.obj");
        if (!this.isPlayer) {
            this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"music.mp3", (int)125, (int)8);
            this.moonlander.start();
        } else {
            this.minim = new Minim((Object)this);
            this.player = this.minim.loadFile("music.mp3");
            this.json = this.loadJSONObject("sync.json");
            JSONArray jsonParameters = this.json.getJSONArray("Parameters");
            int i2 = 0;
            while (i2 < jsonParameters.size()) {
                JSONObject parameter = jsonParameters.getJSONObject(i2);
                String name = parameter.getString("Name");
                JSONArray syncArray = parameter.getJSONArray("SyncArray");
                SyncParameter syncParam = new SyncParameter(name);
                int j = 0;
                while (j < syncArray.size()) {
                    JSONObject jsonData = syncArray.getJSONObject(j);
                    float time = jsonData.getFloat("Time");
                    float value = jsonData.getFloat("Value");
                    syncParam.data.put(Float.valueOf(time), Float.valueOf(value));
                    ++j;
                }
                this.parameters.put(name, syncParam);
                ++i2;
            }
            this.player.pause();
        }
        this.pg = this.createGraphics(1280, 720, "processing.opengl.PGraphics3D");
        this.size(this.displayWidth, this.displayHeight, "processing.opengl.PGraphics3D");
        this.frameRate(60.0f);
        this.hint(8);
        ((PGraphicsOpenGL)this.g).textureSampling(3);
        this.textFont(font);
        this.textAlign(3, 3);
    }

    public void drawStar() {
        float x = (float)(this.pg.width / 2) + (float)this.getValueFromRocket("Trumpet Pos X");
        float y = (float)(this.pg.height / 2) + (float)this.getValueFromRocket("Trumpet Pos Y");
        float z = (float)this.getValueFromRocket("Trumpet Pos Z");
        float rotx = (float)this.getValueFromRocket("Trumpet Rot X");
        float roty = (float)this.getValueFromRocket("Trumpet Rot Y");
        float rotz = (float)this.getValueFromRocket("Trumpet Rot Z");
        boolean wireframe = this.getValueFromRocket("Trumpet Wireframe") > 0.0;
        float r = (float)this.getValueFromRocket("Trumpet R");
        float g = (float)this.getValueFromRocket("Trumpet G");
        float b = (float)this.getValueFromRocket("Trumpet B");
        if (wireframe) {
            this.pg.pushMatrix();
            this.pg.translate(x, y, z);
            this.pg.rotateX(Instanssi2023.radians((float)rotx));
            this.pg.rotateY(Instanssi2023.radians((float)roty));
            this.pg.rotateZ(Instanssi2023.radians((float)rotz));
            this.pg.noFill();
            this.pg.stroke(r, g, b);
            this.pg.scale((float)this.getValueFromRocket("Trumpet Size"));
            this.pg.strokeWeight(1.0f / (float)this.getValueFromRocket("Trumpet Size"));
            this.pg.beginShape();
            int children = this.star.getChildCount();
            int i = 0;
            while (i < children) {
                PShape child = this.star.getChild(i);
                int total = child.getVertexCount();
                int j = 0;
                while (j < total) {
                    PVector v = child.getVertex(j);
                    this.pg.vertex(v.x, v.y, v.z);
                    ++j;
                }
                ++i;
            }
            this.pg.endShape();
            this.pg.popMatrix();
        } else {
            this.pg.directionalLight(r * 2.0f, g * 2.0f, b * 2.0f, 0.0f, 0.0f, -1.0f);
            this.pg.pushMatrix();
            this.pg.translate(x, y, z);
            this.pg.rotateX(Instanssi2023.radians((float)rotx));
            this.pg.rotateY(Instanssi2023.radians((float)roty));
            this.pg.rotateZ(Instanssi2023.radians((float)rotz));
            this.pg.noFill();
            this.pg.strokeWeight(0.07f);
            this.pg.stroke(r, g, b);
            this.pg.scale((float)this.getValueFromRocket("Trumpet Size"));
            this.pg.fill(r, g, b);
            this.pg.shape(this.star);
            this.pg.popMatrix();
        }
    }

    public void drawSpirtor() {
        float x = (float)(this.pg.width / 2) + (float)this.getValueFromRocket("Trumpet Pos X");
        float y = (float)(this.pg.height / 2) + (float)this.getValueFromRocket("Trumpet Pos Y");
        float z = (float)this.getValueFromRocket("Trumpet Pos Z");
        float rotx = (float)this.getValueFromRocket("Trumpet Rot X");
        float roty = (float)this.getValueFromRocket("Trumpet Rot Y");
        float rotz = (float)this.getValueFromRocket("Trumpet Rot Z");
        boolean wireframe = this.getValueFromRocket("Trumpet Wireframe") > 0.0;
        float r = (float)this.getValueFromRocket("Trumpet R");
        float g = (float)this.getValueFromRocket("Trumpet G");
        float b = (float)this.getValueFromRocket("Trumpet B");
        if (wireframe) {
            this.pg.pushMatrix();
            this.pg.translate(x, y, z);
            this.pg.rotateX(Instanssi2023.radians((float)rotx));
            this.pg.rotateY(Instanssi2023.radians((float)roty));
            this.pg.rotateZ(Instanssi2023.radians((float)rotz));
            this.pg.noFill();
            this.pg.stroke(r, g, b);
            this.pg.scale((float)this.getValueFromRocket("Trumpet Size"));
            this.pg.strokeWeight(1.0f / (float)this.getValueFromRocket("Trumpet Size"));
            this.pg.beginShape();
            int children = this.spitor.getChildCount();
            int i = 0;
            while (i < children) {
                PShape child = this.spitor.getChild(i);
                int total = child.getVertexCount();
                int j = 0;
                while (j < total) {
                    PVector v = child.getVertex(j);
                    this.pg.vertex(v.x, v.y, v.z);
                    ++j;
                }
                ++i;
            }
            this.pg.endShape();
            this.pg.popMatrix();
        } else {
            this.pg.directionalLight(r * 2.0f, g * 2.0f, b * 2.0f, 0.0f, 0.0f, -1.0f);
            this.pg.pushMatrix();
            this.pg.translate(x, y, z);
            this.pg.rotateX(Instanssi2023.radians((float)rotx));
            this.pg.rotateY(Instanssi2023.radians((float)roty));
            this.pg.rotateZ(Instanssi2023.radians((float)rotz));
            this.pg.noFill();
            this.pg.strokeWeight(0.07f);
            this.pg.stroke(r, g, b);
            this.pg.scale((float)this.getValueFromRocket("Trumpet Size"));
            this.pg.fill(r, g, b);
            this.pg.shape(this.spitor);
            this.pg.popMatrix();
        }
    }

    public void drawHorn() {
        float x = (float)(this.pg.width / 2) + (float)this.getValueFromRocket("Trumpet Pos X");
        float y = (float)(this.pg.height / 2) + (float)this.getValueFromRocket("Trumpet Pos Y");
        float z = (float)this.getValueFromRocket("Trumpet Pos Z");
        float rotx = (float)this.getValueFromRocket("Trumpet Rot X");
        float roty = (float)this.getValueFromRocket("Trumpet Rot Y");
        float rotz = (float)this.getValueFromRocket("Trumpet Rot Z");
        boolean wireframe = this.getValueFromRocket("Trumpet Wireframe") > 0.0;
        float r = (float)this.getValueFromRocket("Trumpet R");
        float g = (float)this.getValueFromRocket("Trumpet G");
        float b = (float)this.getValueFromRocket("Trumpet B");
        if (wireframe) {
            this.pg.pushMatrix();
            this.pg.translate(x, y, z);
            this.pg.rotateX(Instanssi2023.radians((float)rotx));
            this.pg.rotateY(Instanssi2023.radians((float)roty));
            this.pg.rotateZ(Instanssi2023.radians((float)rotz));
            this.pg.noFill();
            this.pg.stroke(r, g, b);
            this.pg.scale((float)this.getValueFromRocket("Trumpet Size"));
            this.pg.strokeWeight(1.0f / (float)this.getValueFromRocket("Trumpet Size"));
            this.pg.beginShape();
            int children = this.horn.getChildCount();
            int i = 0;
            while (i < children) {
                PShape child = this.horn.getChild(i);
                int total = child.getVertexCount();
                int j = 0;
                while (j < total) {
                    PVector v = child.getVertex(j);
                    this.pg.vertex(v.x, v.y, v.z);
                    ++j;
                }
                ++i;
            }
            this.pg.endShape();
            this.pg.popMatrix();
        } else {
            this.pg.directionalLight(r * 2.0f, g * 2.0f, b * 2.0f, 0.0f, 0.0f, -1.0f);
            this.pg.pushMatrix();
            this.pg.translate(x, y, z);
            this.pg.rotateX(Instanssi2023.radians((float)rotx));
            this.pg.rotateY(Instanssi2023.radians((float)roty));
            this.pg.rotateZ(Instanssi2023.radians((float)rotz));
            this.pg.noFill();
            this.pg.strokeWeight(0.07f);
            this.pg.stroke(r, g, b);
            this.pg.scale((float)this.getValueFromRocket("Trumpet Size"));
            this.pg.fill(r, g, b);
            this.pg.shape(this.horn);
            this.pg.popMatrix();
        }
    }

    public void drawCube() {
        float x = (float)(this.pg.width / 2) + (float)this.getValueFromRocket("Cube Pos X");
        float y = (float)(this.pg.height / 2) + (float)this.getValueFromRocket("Cube Pos Y");
        float z = (float)this.getValueFromRocket("Cube Pos Z");
        float rotx = (float)this.getValueFromRocket("Cube Rot X");
        float roty = (float)this.getValueFromRocket("Cube Rot Y");
        float rotz = (float)this.getValueFromRocket("Cube Rot Z");
        float r = (float)this.getValueFromRocket("Cube R");
        float g = (float)this.getValueFromRocket("Cube G");
        float b = (float)this.getValueFromRocket("Cube B");
        float bSize = (float)this.getValueFromRocket("Cube Size");
        float weight = (float)this.getValueFromRocket("Cube Stroke");
        float cubeFill = (float)this.getValueFromRocket("Cube Fill");
        float fr = (float)this.getValueFromRocket("Cube Fill R");
        float fg = (float)this.getValueFromRocket("Cube Fill G");
        float fb = (float)this.getValueFromRocket("Cube Fill B");
        this.pg.pushMatrix();
        this.pg.translate(x, y, z);
        this.pg.rotateX(Instanssi2023.radians((float)rotx));
        this.pg.rotateY(Instanssi2023.radians((float)roty));
        this.pg.rotateZ(Instanssi2023.radians((float)rotz));
        this.pg.rectMode(3);
        this.pg.stroke(r, g, b);
        if (cubeFill < 1.0f) {
            this.pg.noFill();
        } else {
            this.pg.fill(fr, fg, fb);
        }
        this.pg.strokeWeight(weight);
        this.pg.box(bSize);
        this.pg.popMatrix();
    }

    public void keyPressed() {
        if (this.asked) {
            return;
        }
        if (this.key == '\uffff') {
            if (this.keyCode == 38) {
                this.asked = true;
            } else if (this.keyCode == 40) {
                this.simulation = false;
                this.myClient = new UDP((Object)this, 9909);
                this.asked = true;
            }
        }
    }

    public void draw() {
        if (!this.asked) {
            this.background(0);
            this.text("at home press UP", this.width / 2, 100.0f);
            this.text("at Instanssi press DOWN", this.width / 2, 300.0f);
            this.text("autostart at: " + (int)(20.0 - this.recordTimer), this.width / 2, 600.0f);
            this.recordTimer += (double)0.01f;
            if (this.recordTimer > 20.0) {
                this.asked = true;
            }
            return;
        }
        if (!this.isPlayer) {
            this.moonlander.update();
        }
        if (this.isPlayer && Instanssi2023.second() > 1 && !this.isgoing) {
            this.player.play();
            this.isgoing = true;
        }
        this.pg.beginDraw();
        this.pg.background((float)this.getValueFromRocket("Background R"), (float)this.getValueFromRocket("Background G"), (float)this.getValueFromRocket("Background B"));
        this.drawCube();
        int framei = (int)this.getValueFromRocket("Animal Frame");
        if (framei == 0) {
            this.drawHorn();
        }
        if (framei == 1) {
            this.drawStar();
        }
        if (framei == 2) {
            this.drawSpirtor();
        }
        this.pg.noSmooth();
        this.pg.directionalLight(255.0f, 255.0f, 255.0f, 0.0f, 0.0f, -1.0f);
        this.pg.filter(this.feedback);
        this.pg.resetShader();
        this.pg.endDraw();
        this.image((PImage)this.pg, 0.0f, 0.0f, this.width, this.height);
        int fi = (int)this.getValueFromRocket("Text Index");
        int fl = (int)this.getValueFromRocket("Text Length");
        float fx = (float)this.getValueFromRocket("Text Pos X");
        float fy = (float)this.getValueFromRocket("Text Pos Y");
        this.fill(32);
        this.text(this.texts[fi % this.texts.length].substring(0, fl), (float)(this.width / 2) - fx, (float)(this.height / 2) - fy);
        this.fill(255);
        this.text(this.texts[fi % this.texts.length].substring(0, fl), (float)(this.width / 2) - fx, (float)(this.height / 2) - fy + 2.0f);
        PImage prevFrame = this.pg.get();
        this.feedback.set("prevFrame", prevFrame);
        this.feedback.set("blur", (float)this.getValueFromRocket("Blur"));
        this.feedback.set("blurScale", (float)this.getValueFromRocket("Blur Scale"));
        this.startLamp();
        int lamps0 = (int)this.getValueFromRocket("LampsStart");
        int lamps1 = (int)this.getValueFromRocket("LampsEnd");
        int LampR = (int)this.getValueFromRocket("LampsR");
        int LampG = (int)this.getValueFromRocket("LampsG");
        int LampB = (int)this.getValueFromRocket("LampsB");
        int i = lamps0;
        while (i < lamps1) {
            this.setLamp(i, LampR, LampG, LampB);
            ++i;
        }
        this.endLamp();
        if (!this.isPlayer) {
            if (this.moonlander.getCurrentRow() > 2198.0) {
                this.stop();
                this.exit();
            }
        } else if (this.player.length() - this.player.position() <= 16000) {
            this.exit();
        }
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
        this.noSmooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Instanssi2023"};
        if (passedArgs != null) {
            PApplet.main((String[])Instanssi2023.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class SyncParameter {
        String Name;
        TreeMap<Float, Float> data;

        public SyncParameter(String n) {
            this.Name = n;
            this.data = new TreeMap();
        }
    }
}

