'use strict'

entityRegistry['module']['tunnel'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'basePosition', displayName: 'Base Position', type: 'float3', defaultValue: [0, 0, 0]},
        { paramName: 'distance', displayName: 'Distance', type: 'float', defaultValue: 0},
        { paramName: 'distanceStep', displayName: 'Distance Step', type: 'float', defaultValue: 20},
        { paramName: 'baseRotation', displayName: 'Base Rotation', type: 'angle', defaultValue: 0},
        { paramName: 'alternateRotation', displayName: 'Alternate Rotation', type: 'boolean', defaultValue: false},
        { paramName: 'ringSize', displayName: 'Ring Size', type: 'float', defaultValue: 10},
        { paramName: 'numShapes', displayName: 'Num Shapes', type: 'int', defaultValue: 5, uiOptions: { min: 0 }},
        { paramName: 'numShapesPerRing', displayName: 'ShapesPerRing', type: 'int', defaultValue: 5, uiOptions: { min: 0 }},
        { paramName: 'model', displayName: 'Model', type: 'model', defaultValue: ''},
        { paramName: 'overrideMaterial', displayName: 'Override Material', type: 'boolean', defaultValue: false},
        { paramName: 'diffuse1', displayName: 'Diffuse Color 1', type: 'color', defaultValue: [1, 1, 1]},
        { paramName: 'emissive1', displayName: 'Emissive Color 1', type: 'color', defaultValue: [0, 0, 0]},
        { paramName: 'diffuse2', displayName: 'Diffuse Color 2', type: 'color', defaultValue: [1, 1, 1]},
        { paramName: 'emissive2', displayName: 'Emissive Color 2', type: 'color', defaultValue: [0, 0, 0]},
        { paramName: 'translation', displayName: 'Translation', type: 'float3', defaultValue: [0, 0, 0]},
        { paramName: 'rotation', displayName: 'Rotation', type: 'angle3', defaultValue: [0, 0, 0]},
        { paramName: 'scale1', displayName: 'Scale 1', type: 'float3', defaultValue: [1, 1, 1]},
        { paramName: 'scale2', displayName: 'Scale 2', type: 'float3', defaultValue: [1, 1, 1]},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                basePosition,
                distance,
                distanceStep,
                baseRotation,
                alternateRotation,
                ringSize,
                numShapes,
                numShapesPerRing,
                model,
                overrideMaterial,
                diffuse1,
                emissive1,
                diffuse2,
                emissive2,
                translation,
                rotation,
                scale1,
                scale2,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const colorId1 = overrideMaterial ? renderer.getPaletteId(diffuse1, emissive1) : undefined
            const colorId2 = overrideMaterial ? renderer.getPaletteId(diffuse2, emissive2) : undefined

            const startRing = Math.floor(distance / distanceStep)
            const distanceRemainder = distance % distanceStep

            const oddBaseRotation = baseRotation
            const evenBaseRotation = -baseRotation

            let objectMat = m4.translation(0, ringSize, 0)
            objectMat = m4.xRotate(objectMat, rotation[0])
            objectMat = m4.yRotate(objectMat, rotation[1])
            objectMat = m4.zRotate(objectMat, rotation[2])
            objectMat = m4.translate(objectMat, translation[0], translation[1], translation[2])
            
            const scaleMat1 = m4.scaling(scale1[0], scale1[1], scale1[2])
            const scaleMat2 = m4.scaling(scale2[0], scale2[1], scale2[2])

            for (let ring = 0; ring < numShapes; ++ring) {
                const worldMat = m4.translation(basePosition[0], basePosition[1], basePosition[2] + distanceRemainder - distanceStep*ring)
                for (let spoke = 0; spoke < numShapesPerRing; ++spoke) {
                    const worldRotation = (alternateRotation && ((startRing + ring) & 1)) ? oddBaseRotation : evenBaseRotation
                    const objectRotationMat = m4.zRotation(worldRotation + spoke * Math.PI*2 / numShapesPerRing)
                    const objectWorldMat = m4.multiply(worldMat, m4.multiply(objectRotationMat, m4.multiply(objectMat, ((startRing + ring) & 1) ? scaleMat1 : scaleMat2)))
                    const colorId = ((startRing + ring) & 1) ? colorId1 : colorId2
                    renderer.drawModel(model, objectWorldMat, colorBuffer, depthBuffer, brightnessBuffer, colorId)
                }
            }
        }
    }
}
