'use strict'

entityRegistry['module']['threeDeeModel'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'model', displayName: 'Model', type: 'model', defaultValue: ''},
        { paramName: 'position', displayName: 'Position', type: 'float3', defaultValue: [0, 0, 0]},
        { paramName: 'rotation', displayName: 'Rotation', type: 'angle3', defaultValue: [0, 0, 0]},
        { paramName: 'scale', displayName: 'Scale', type: 'float3', defaultValue: [1, 1, 1]},
        { paramName: 'overrideMaterial', displayName: 'Override Material', type: 'boolean', defaultValue: false},
        { paramName: 'diffuse', displayName: 'Diffuse', type: 'color', defaultValue: [1, 1, 1]},
        { paramName: 'emissive', displayName: 'Emissive', type: 'color', defaultValue: [0, 0, 0]},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                model,
                position,
                rotation,
                scale,
                overrideMaterial,
                diffuse,
                emissive,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const xRotationMat = m4.xRotation(rotation[0])
            const yRotationMat = m4.yRotation(rotation[1])
            const zRotationMat = m4.zRotation(rotation[2])

            const scaleMat = m4.scaling(scale[0], scale[1], scale[2])
            const translationMat = m4.translation(position[0], position[1], position[2])
            const modelMat = m4.multiply(translationMat, m4.multiply(scaleMat, m4.multiply(m4.multiply(zRotationMat, yRotationMat), xRotationMat)))

            const colorOverride = overrideMaterial ? renderer.getPaletteId(diffuse, emissive) : undefined
            renderer.drawModel(model, modelMat, colorBuffer, depthBuffer, brightnessBuffer, colorOverride)
        }
    }
}
