'use strict'

entityRegistry['module']['threeDeeArrowWriter'] = {
    init: (staticConfig) => {
        const {
            seed,
            segments,
            numArrows
        } = { ...staticConfig }

        const targetPoints = [
            [-25,0,0],
            [-25,0,0],

            [-6.5,-4,0],
            [-3.5,+4.5,0],
            // [-1,-2.5,0],
            [0,-3.5,0],
            // [+1,-2.5,0],
            [+3.5,+4.5,0],
            [+6.5,-4,0],

            [25,0,0],
            [25,0,0],
        ]

        const rng = new Math.seedrandom(seed)
        const arrows = []
        // let up = [0,0,1]
        // const fwd = m4.normalize([1,-1,0])
        // const right = m4.cross(fwd, up)
        // up = m4.cross(right,fwd)
        for (let i = 0; i < numArrows; ++i) {
            const points = []
            let tp = 0
            targetPoints.forEach((targetPoint) => {
                const adjustedTargetPoint = [targetPoint[0],-targetPoint[1],targetPoint[2]]
                const offsetScale = (tp>=2 && tp <= targetPoints.length-3) ? .5 : 8
                const offset = m4.multiplyVector(randomNormal(rng), offsetScale)
                const finalPoint = m4.addVectors(adjustedTargetPoint, offset)
                // const offsetScale = Math.min(j * 1.5, 5)
                // const rightOff = (rng()*2-1) * offsetScale * .95
                // const upOff = (rng()*2-1) * offsetScale * .95
                // const fwdOff = (rng()*2-1) * offsetScale * 0.1
                // let p = m4.multiplyVector(fwd, j*20)
                // p = m4.addVectors(p, m4.multiplyVector(right, rightOff))
                // p = m4.addVectors(p, m4.multiplyVector(up, upOff))
                // p = m4.addVectors(p, m4.multiplyVector(fwd, fwdOff))
                points.push(finalPoint)
                tp++
            })
            const splinePoints = pathToSpline(points, segments)
            arrows.push(new ArrowModel(splinePoints))
        }

        return {
            arrows,
            frameCount: (targetPoints.length-3) * segments,
        }
    },
    staticConfig: [
        { paramName: 'seed', displayName: 'Seed', type: 'string', defaultValue: 'seed', triggerInit: true },
        { paramName: 'segments', displayName: 'Segments', type: 'int', defaultValue: 50, triggerInit: true },
        { paramName: 'numArrows', displayName: 'Arrows', type: 'int', defaultValue: 10, triggerInit: true },
    ],
    dynamicConfig: [
        { paramName: 'position', displayName: 'Position', type: 'float3', defaultValue: [0, 0, 0]},
        { paramName: 'rotation', displayName: 'Rotation', type: 'angle3', defaultValue: [0, 0, 0]},
        { paramName: 'scale', displayName: 'Scale', type: 'float', defaultValue: 1},
        { paramName: 'animation', displayName: 'Animation', type: 'float', defaultValue: 0},
        { paramName: 'length', displayName: 'Length', type: 'float', defaultValue: 20},
        { paramName: 'arrowWidth', displayName: 'Arrow Width', type: 'float', defaultValue: 1},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                position,
                rotation,
                scale,
                animation,
                length,
                arrowWidth,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const xRotationMat = m4.xRotation(rotation[0])
            const yRotationMat = m4.yRotation(rotation[1])
            const zRotationMat = m4.zRotation(rotation[2])
            const rotationMat = m4.multiply(m4.multiply(zRotationMat, yRotationMat), xRotationMat)
            const scaleMat = m4.scaling(scale, scale, scale)
            const translationMat = m4.translation(position[0], position[1], position[2])
            const worldMat = m4.multiply(translationMat, m4.multiply(rotationMat, scaleMat))

            let c = 0
            self.arrows.forEach(arrow => {
                const animationBase = (animation+c*.02)
                if (animationBase > 0 && animationBase < 1) {
                    const animationPos = animationBase * (self.frameCount-3)
                    arrow.reset()
                    const start = Math.max(0, animationPos-length)
                    arrow.addObject(c, Math.max(start-10, 0), Math.max(start-5, 0),
                        (a,t) => .2*arrowWidth,//Math.sin(c+t*84)*.1+.12,
                        (a,t) => .2*arrowWidth,//Math.sin(c+t*54)*.1+.12,
                    )
                    arrow.addObject(c, start, animationPos,
                        (a,t) => .2*arrowWidth,
                        (a,t) => .2*arrowWidth,
                        true, .4*arrowWidth, .4*arrowWidth, .5
                    )
                    renderer.drawModel(arrow.getModel(), worldMat, colorBuffer, depthBuffer, brightnessBuffer)
                }
                c++
            })
        }
    }
}
