'use strict'

entityRegistry['module']['radial'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'position', displayName: 'Position', type: 'float2', defaultValue: [0, 0]},
        { paramName: 'rotation', displayName: 'Rotation', type: 'float', defaultValue: 0},
        { paramName: 'color', displayName: 'Color', type: 'color', defaultValue: [1, 0, 0]},
        { paramName: 'numStripes', displayName: 'Stripe Count', type: 'int', defaultValue: 16},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                position,
                rotation,
                color,
                numStripes
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const xOff = Math.floor(colorBuffer.width/2 + position[0])
            const yOff = Math.floor(colorBuffer.height/2 + position[1])
            const rotationValue = degToRad(rotation) / Math.PI*2
            const colorId = renderer.getPaletteId([0, 0, 0], color, [0, 0, 0])

            let writeIndex = 0
            const repeatScaler = 1 / Math.PI*2 * numStripes/2
            for (let y = 0; y < colorBuffer.height; ++y) {
                const sy = y - yOff
                for (let x = 0; x < colorBuffer.width; ++x) {
                    const sx = x - xOff
                    const angle = Math.atan2(sx, sy) * repeatScaler + rotationValue
                    colorBuffer.data[writeIndex++] = (Math.floor(angle) & 1) ? colorId : 0
                }
            }

        }
    }
}
