'use strict'

entityRegistry['module']['group'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
        { paramName: 'modules', displayName: 'Modules', type: 'entityArray', defaultValue: [], triggerInit: false },
        { paramName: 'enableTime', displayName: 'Enable Time', type: 'boolean', defaultValue: false, triggerInit: false },
        { paramName: 'loopLength', displayName: 'Loop Length', type: 'float', defaultValue: 1, triggerInit: false },
        { paramName: 'loopStyle', displayName: 'Loop Style', type: 'string', defaultValue: 'none', uiOptions: { options: [{text:'None', value:'none'}, {text:'Forward', value:'forward'}, {text:'Ping Pong', value:'pingPong'}] }},
    ],
    dynamicConfig: [
        { paramName: 'time', displayName: 'Time', type: 'float', defaultValue: 0},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                enableTime,
                time,
                loopLength,
                loopStyle,
            } = { ...config }

            moduleRunStringsIndent++

            if (enableTime) {
                frameTime = time
            }

            if (loopStyle === 'none') {
            } else if (loopStyle === 'forward') {
                frameTime = frameTime % loopLength
            } else {
                frameTime = frameTime % (loopLength*2)
                if (frameTime > loopLength) {
                    frameTime = loopLength*2 - frameTime
                }
            }

            config.modules.forEach(moduleId => {
                const perfStartTime = window.performance.now()

                const eah = EntityAccessHelper.fromUuid(moduleId)

                const entityFrameTime = frameTime - eah.staticConfig.start
                if (eah.staticConfig.enabled && entityFrameTime >= 0 && entityFrameTime < eah.staticConfig.duration) {
                    const modulesRunStringsIndex = modulesRunStrings.length
                    modulesRunStrings.push(null)

                    try {
                        eah.actions.render(
                            eah.self,
                            entityFrameTime,
                            eah.combinedConfigs(entityFrameTime),
                            ctx)
                    } catch (e) {
                        console.log(`Rendering failed for: ${moduleId}, ${eah.type}:${eah.subType}, '${e}'`)
                    }

                    const perfEndTime = window.performance.now()
                    const perfDuration = perfEndTime - perfStartTime
                    modulesRunStrings[modulesRunStringsIndex] = [moduleRunStringsIndent, eah.name, perfDuration, moduleId]
                }
            })

            moduleRunStringsIndent--
        }
    }
}
