'use strict'

entityRegistry['module']['chevrons'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'position', displayName: 'Position', type: 'float', defaultValue: 0.35},
        { paramName: 'height', displayName: 'Height', type: 'float', defaultValue: 0.35, uiOptions: { min: 0 }},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                position,
                height,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const color1 = renderer.getPaletteId([0, 0, 0], [0.1, 0.1, 0.1])
            const color2 = renderer.getPaletteId([0, 0, 0], [.9, .7, .1])

            const midLine = Math.floor(position * colorBuffer.height)
            const totalHeight = Math.floor(height * colorBuffer.height)
            const halfHeight = totalHeight / 2
            const startLine = midLine - halfHeight
            const stripeWidth = 80

            for (let y = 0; y < halfHeight; ++y) {
                let index1 = (startLine + y) * colorBuffer.width
                let index2 = (startLine + totalHeight - y - 1) * colorBuffer.width
                let chevronPos = y + frameTime * 30 + 100000
                for (let x = 0; x < colorBuffer.width; ++x) {
                    const v = (chevronPos / stripeWidth) % 1
                    const color = v < 0.5 ? color1 : color2 
                    colorBuffer.data[index1++] = color
                    colorBuffer.data[index2++] = color
                    chevronPos += .99 * stripeWidth
                }
            }
        }
    }
}
