'user sctrict'

let devServerLastSendTime = 0
let devServerSendCount = 0
let devServerLastReceiveTime = 0
let devServerReceiveCount = 0

function devserverInit () {
    let reloadBlocksNoPlay = false
    const reloadTime = parseFloat(sessionStorage.getItem('reloadTime'))
    if (!Number.isNaN(reloadTime)) {
        transport.seekExact(parseFloat(reloadTime))
        const reloadPlayState = sessionStorage.getItem('reloadPlayState')
        if (reloadPlayState === 'true') {
            transport.setIsPlaying(true)
            reloadBlocksNoPlay = true
        }
    }
    sessionStorage.setItem('reloadTime', null)
    sessionStorage.setItem('reloadPlayState', null)

    console.log('Initialising devserver..')
    devserverState = 'open'
    devserverSocket = null
    devserverUpdate()

    return reloadBlocksNoPlay
}


let devserverState, devserverSocket


function devserverUpdate () {
    switch (devserverState) {
        case 'open':
            devserverSocket = new WebSocket('ws://localhost:8086')
            devserverState = 'opening'
            devserverSocket.addEventListener('open', (e) => {
                console.log('Connected to devserver!')
                devserverState = 'opened'
            })
            devserverSocket.addEventListener('close', (e) => {
                if (devserverState === 'opened') {
                    console.log('Disconnected from devserver!')
                }
                devserverState = 'closed'
            })
            devserverSocket.addEventListener('error', (e) => {
                devserverState = 'closed'
            })
            devserverSocket.addEventListener('message', (e) => {
                devServerLastReceiveTime = window.performance.now()
                devServerReceiveCount++
                const message = JSON.parse(e.data)
                if (message.type === 'reloadAll') {
                    console.log('[DEVSERVER] Hot reload all..')
                    sessionStorage.setItem('reloadTime', transport.getCurrentTime())
                    sessionStorage.setItem('reloadPlayState', transport.getIsPlaying())
                    window.location.reload()
                } else if (message.type === 'reloadEntities') {
                    console.log('[DEVSERVER] Hot reload entities..')
                    entities = message.data
                    Object.values(entities).forEach(entity => EntityAccessHelper.fromEntity(entity).init())
                    requestUpdate()
                } else if (message.type === 'loadEntity') {
                    const entityType = message.data.type
                    const entitySubType = message.data.subType
                    console.log(`[DEVSERVER] Hot reload entity '${entityType}.${entitySubType}'..`)
                    const savedEntity = entityRegistry[entityType][entitySubType]
                    try {
                        Function(message.data.file)()
                        const entityDef = entityRegistry[entityType][entitySubType]
                        Object.values(entities)
                            .filter(entity => entity.type === entityType && entity.subType === entitySubType)
                            .forEach(entity => EntityAccessHelper.fromEntity(entity).init())
                        requestUpdate()
                    }
                    catch (e) {
                        console.log(`[DEVSERVER] Failed to reload -> ${e}`)
                        entityRegistry[entityType][entitySubType] = savedEntity
                    }
                } else if (message.type === 'command') {
                    deserializeCommand(message.data).do(entities, false)
                } else if (message.type === 'seekPlayHead') {
                    transport.seekExact(message.data.position)
                } else {
                    console.log('[DEVSERVER] Unknown message from devServer:', message.type)
                }
            })
            break

        case 'opening':
        case 'opened':
            break
    
        case 'closed':
            devserverSocket.close()
            delete devserverSocket
            devserverState = 'open'
            break
    }

    setTimeout(devserverUpdate, 2000)
}

function devserverSend (data) {
    devserverSocket.send(JSON.stringify(data))
    devServerLastSendTime = window.performance.now()
    devServerSendCount++
}