import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class sketch_1dshooter extends PApplet {

Level level;

ArrayList<Enemy> enemies;
ArrayList<Bullet> bullets = new ArrayList<Bullet>();
ArrayList<Splat> splats = new ArrayList<Splat>();
Gate gate;
float transition =1f;
float flash = 0f;
boolean dead = false;
boolean showmap = false;

float playerx =5f,playery = 58f;
float dirx;
float diry;
float rot=PI;
public void setup() {
  //size(1920,1080,P2D);
  noCursor();
  
  stroke(255);
  colorMode(HSB);
  loadLevel(0);
}

public void restart() {
  loadLevel(0);
  health = 100;
  dead = false;
}

public boolean checkCollision(float px, float py) {
  int pxlx = PApplet.parseInt(floor(px)); int pxly =PApplet.parseInt(floor(py));
    int pxl = pxly*64+pxlx;
    if(pxl <0 || pxl>=level.map.pixels.length) return true;
    if(level.map.pixels[pxl]!=color(0)) { return true;}
    for(int e = 0; e<enemies.size(); e++) {
      if( enemies.get(e).hit(pxlx,pxly)) {
        return true;
      }
    }
   return false; 
}

float minimapscale = 4;
public void drawminimap() {
  float offx = 806, offy = top+160;
  image(level.map,offx,offy,64*minimapscale,64*minimapscale);
  //fill(255,0,0);
  fill(128,255,128);
  //text(playerx+":"+playery+" "+dirx+":"+diry,100,10);
  rect(offx+playerx*minimapscale,offy+playery*minimapscale,minimapscale,minimapscale);
  fill(255,255,128);
  for(Enemy e : enemies) {
    rect(offx+e.x*minimapscale,offy+e.y*minimapscale,minimapscale,minimapscale);
  }
  fill(200,255,128);
  for(Bullet e : bullets) {
    rect(offx+e.x*minimapscale,offy+e.y*minimapscale,minimapscale,minimapscale);
  }
  fill(200,255,255);
  rect(offx+level.gate.x,offy+level.gate.x,minimapscale,minimapscale);
  stroke(200,255,255);
  line(offx+playerx, offy+playery,offx+playerx+dirx*5, offy+playery+diry*5);
  noStroke();
}

float rotspeed = PI/2f;
float speed = 1.5f;
float bulletspeed = 3f;
float top= 520;
float t =0; float lt =0; float delta;
float aggro = 5f; float enyspeed = .25f;

float health = 100;
public void draw() {
  lt=t; t= millis()/1000f;
  delta = t-lt;
  firedelay -=delta;
  background(0);
  dirx = sin(rot);
  diry = cos(rot);
  if(kdw) {
      if(!checkCollision(playerx+dirx*speed,playery+diry*speed)) {
        playery+=diry*speed*delta;
        playerx+=dirx*speed*delta;
      } 
    } else if (kds) {
      if(!checkCollision(playerx-dirx*speed,playery-diry*speed)) {
      playery-=diry*speed*delta;
      playerx-=dirx*speed*delta;
      }
    }
    if (kda) {
      rot+=rotspeed*delta;
    } else if (kdd) {
      rot-=rotspeed*delta;
    } 
  
   ArrayList livebullets = new ArrayList<Bullet>();
  for(int bl = 0; bl<bullets.size(); bl++) {
    Bullet b = bullets.get(bl);
    b.x = b.x+b.dx*bulletspeed*delta;
    b.y = b.y+b.dy*bulletspeed*delta;
    boolean hashit = false;
    if(b.enemybullet) {
      if(playerx<b.x+.2f&&playerx>b.x-.2f&&playery<b.y+.2f&&playery>b.y-.2f) {
        health-=b.dmg;
        hashit = true;
        flash = .2f;
      }
    } else {
    for(int e = 0; e<enemies.size(); e++) {
      if(!b.enemybullet && enemies.get(e).hit(b.x,b.y)) {
        enemies.get(e).damage(b.dmg);
        hashit = true;
        if(enemies.get(e).health<=0)splats.add(new Splat(b.x,b.y,.4f));
        else splats.add(new Splat(b.x,b.y));
      }
    }
    }
    int pxlx = PApplet.parseInt(floor(b.x)); int pxly =PApplet.parseInt(floor(b.y));
    int pxl = pxly*64+pxlx;
    if(pxl <0 || pxl>=level.map.pixels.length) continue;
    if(level.map.pixels[pxl]!=color(0)) { continue;}
    if(!hashit)livebullets.add(b);
  }
  bullets = livebullets;
   ArrayList<Enemy> liveEnemies = new ArrayList<Enemy>();
  for(int e = 0; e<enemies.size(); e++) {
    Enemy eny  =enemies.get(e);
    float enyd =distance(playerx,playery,eny.x,eny.y);
    if(enyd<aggro) {
      float etx = (playerx-eny.x)/enyd;
      float ety = (playery-eny.y)/enyd;
      eny.x+=etx*enyspeed*delta;
      eny.y+=ety*enyspeed*delta;
      if(eny.firedelay <=0) {bullets.add(new Bullet(eny.x,eny.y,etx,ety,10,true)); eny.firedelay = 3.5f;}
    }
    eny.firedelay-=delta;
    if(eny.health > 0) {
      liveEnemies.add(enemies.get(e));
    }
  }
  enemies = liveEnemies;
   ArrayList<Splat> livesplats = new ArrayList<Splat>();
  for(int e = 0; e<splats.size(); e++) {
    if(splats.get(e).lifetime > 0) {
      splats.get(e).lifetime-=delta;
      livesplats.add(splats.get(e));
    }
  }
  float gd = distance(playerx,playery,level.gate.x,level.gate.y);
  if(gd<2f) {
    transition = 1f;
    loadLevel(level.gate.target);
  }
  if(health<=0) {
    dead = true;
    transition = 1f;
  }
  splats = livesplats;
  dirx = sin(rot);
  diry = cos(rot);
  if(showmap)drawminimap();
  //stroke(255);
  noStroke();
  if(transition>0) {
    transition-=delta;
    for(int i = 1; i<=64; i++) {
      int shading = color(dead?0:66,255,PApplet.parseInt(255*transition));
      fill(shading);
      rect(i*40,top, 40,40);
    }
  } else {
    for(int i = 1; i<=64; i++) {
      float cdirx = sin(rot-PI/2f*i/64f+PI/4f-PI/12f);
      float cdiry = cos(rot-PI/2f*i/64f+PI/4f-PI/12f);
      int shading = trace(playerx,playery,cdirx,cdiry);
      fill(shading);
      
      rect(i*40,top, 40,40);
    }
    if(flash>0) {
      flash-=delta;
      fill(color(0,255,255,(flash/.2f)*255));
      rect(40,top,1940,40);
    }
  }
  fill(0,255,health/100f*255);
  rect(0,top,40,40);
}

float firedelay = 0f;

boolean kdw,kds,kda,kdd;
public void keyPressed() {
    if (keyCode == ESC) {
      exit();
    } else if (key == 'w' ||( key==CODED && keyCode == UP)) { kdw = true;
    }  else if (key == 's' ||( key==CODED && keyCode == UP)) { kds = true;
    }  else if (key == 'a' ||( key==CODED && keyCode == UP)) { kda = true;
    }  else if (key == 'd' ||( key==CODED && keyCode == UP)) { kdd = true;
    }  else if (key==' ' && firedelay <=0f) {
      bullets.add(new Bullet(playerx,playery,dirx,diry,50,false)); firedelay = 1f;
    }  else if (key == 'l') {
      showmap=!showmap;
    }  else if (key == 'r') {
      restart();
    }
   
}
public void keyReleased() {
    if (key == 'w' ||( key==CODED && keyCode == UP)) { kdw = false;
    }  else if (key == 's' ||( key==CODED && keyCode == UP)) { kds = false;
    }  else if (key == 'a' ||( key==CODED && keyCode == UP)) { kda = false;
    }  else if (key == 'd' ||( key==CODED && keyCode == UP)) { kdd = false;
    }
   
}

public int trace(float ox, float oy, float dx, float dy) {
  int q = 0;
  for(int i = 0; i<80; i++) {
    float px = ox,py = oy; px+=dx*i*.2f; py+=dy*i*.2f;
    
    
    int pxl = PApplet.parseInt(floor(py))*64+PApplet.parseInt(floor(px));
    if(pxl <0 || pxl>=level.map.pixels.length) break;
    int bright=PApplet.parseInt((80f-i)/80f*255);
    int c=level.map.pixels[pxl];
    q=color(hue(c),saturation(c),bright);
    if(level.map.pixels[pxl]!=color(0)) { break;}
    boolean hit = false;
    for(int e = 0; e<enemies.size(); e++) {
      if( enemies.get(e).hit(px,py)) {
        q=color(20,255,bright);  hit = true;
      }
    }
    for(int e = 0; e<bullets.size(); e++) {
      if( bullets.get(e).rayhit(px,py)) {
        q=color(128,255,bright); hit = true;
      }
    }
    for(int e = 0; e<splats.size(); e++) {
      if( splats.get(e).rayhit(px,py)) {
        q=color(0,255,bright); hit = true;
      }
    }
    if(px<gate.x+.3f&&px>gate.x-.3f&&py<gate.y+.3f&&py>gate.y-.3f) {
      q=color(200,255,bright); hit = true;
    }
    if(hit) return q;
  }
  return q;
}

public float distance(float ax, float ay, float bx, float by) {
  float a = ax-bx;
  float b = ay-by;
  return sqrt(a*a+b*b);
}

public void loadLevel(int id) {
  level = new Level(id);
  enemies = level.enemys;
  bullets.clear();
  splats.clear();
  gate = level.gate;
  playerx = level.spawnx;
  playery =level.spawny;
}
class Enemy {
  public float x;
  public float y;
  int health = 100;
  float size = .2f;
  float firedelay = 0f;
  public Enemy(float x, float y) {this.x = x; this.y = y; }
  
  public boolean hit(float px, float py) {
    if(px<x+size&&px>x-size&&py<y+size&&py>y-size) return true;
    return false;
  }
  
  
  public void damage(int dmg) {
    health -= dmg;
  }
}

class Bullet {
  float size = .07f;
  public float x; public float y; public float dx; public float dy;
  public int dmg = 50;
  public boolean enemybullet = false;
  
  public Bullet(float bx, float by, float bdx, float bdy, int dg, boolean eb) { x=bx; y=by; dx = bdx; dy = bdy; dmg = dg; enemybullet = eb;}
  
  public boolean rayhit(float px, float py) {
    if(px<x+size&&px>x-size&&py<y+size&&py>y-size) return true;
    return false;
  }
}

class Splat {
  public float lifetime = .25f;
  public float x, y;
  float size = .1f;
  public Splat(float sx, float sy) { x= sx; y= sy; }
  public Splat(float sx, float sy, float sz) { x= sx; y= sy; size = sz; }
  
  public boolean rayhit(float px, float py) {
    if(px<x+size&&px>x-size&&py<y+size&&py>y-size) return true;
    return false;
  }
}

class Gate {
 float x, y;
 int target;
 public Gate(float px, float py, int tgt) {
   x=px; y=py; target = tgt;
 }
}
class Level {
  int id;
  ArrayList<Enemy> enemys;
  PImage map;
  Gate gate;
  float spawnx, spawny;
  public Level(int id) {
    enemys = new ArrayList<Enemy>();
    loadMap(id);
    String[] lines = loadStrings("levels/map"+id+".txt");
    for(String l : lines) {
      //println(l);
      if(l.startsWith("gate:")) {
        String[] pars = l.substring(5).split(":");
        float gx = parseFloat(pars[0]);
        float gy = parseFloat(pars[1]);
        int tgt = parseInt(pars[2]);
        //println(gx+":"+gy+":"+tgt);
        gate = new Gate(gx,gy,tgt);
      } else if(l.startsWith("spwn:")) {
        String[] pars = l.substring(5).split(":");
        spawnx = parseFloat(pars[0]);
        spawny = parseFloat(pars[1]);
        
        
      } else {
        String[] pars = l.split(":");
        float ex = parseFloat(pars[0]);
        float ey = parseFloat(pars[1]);
        //println(ex+":"+ey);
        enemys.add(new Enemy(ex,ey));
      }
    }
  }
  
  public void loadMap(int mapid) {
  map= loadImage("levels/map"+mapid+".png");
  map.loadPixels();
}
}
  public void settings() {  fullScreen(); }
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--present", "--window-color=#000000", "--hide-stop", "sketch_1dshooter" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
