Level level;

ArrayList<Enemy> enemies;
ArrayList<Bullet> bullets = new ArrayList<Bullet>();
ArrayList<Splat> splats = new ArrayList<Splat>();
Gate gate;
float transition =1f;
float flash = 0f;
boolean dead = false;
boolean showmap = false;

float playerx =5f,playery = 58f;
float dirx;
float diry;
float rot=PI;
void setup() {
  //size(1920,1080,P2D);
  noCursor();
  fullScreen();
  stroke(255);
  colorMode(HSB);
  loadLevel(0);
}

void restart() {
  loadLevel(0);
  health = 100;
  dead = false;
}

boolean checkCollision(float px, float py) {
  int pxlx = int(floor(px)); int pxly =int(floor(py));
    int pxl = pxly*64+pxlx;
    if(pxl <0 || pxl>=level.map.pixels.length) return true;
    if(level.map.pixels[pxl]!=color(0)) { return true;}
    for(int e = 0; e<enemies.size(); e++) {
      if( enemies.get(e).hit(pxlx,pxly)) {
        return true;
      }
    }
   return false; 
}

float minimapscale = 4;
void drawminimap() {
  float offx = 806, offy = top+160;
  image(level.map,offx,offy,64*minimapscale,64*minimapscale);
  //fill(255,0,0);
  fill(128,255,128);
  //text(playerx+":"+playery+" "+dirx+":"+diry,100,10);
  rect(offx+playerx*minimapscale,offy+playery*minimapscale,minimapscale,minimapscale);
  fill(255,255,128);
  for(Enemy e : enemies) {
    rect(offx+e.x*minimapscale,offy+e.y*minimapscale,minimapscale,minimapscale);
  }
  fill(200,255,128);
  for(Bullet e : bullets) {
    rect(offx+e.x*minimapscale,offy+e.y*minimapscale,minimapscale,minimapscale);
  }
  fill(200,255,255);
  rect(offx+level.gate.x,offy+level.gate.x,minimapscale,minimapscale);
  stroke(200,255,255);
  line(offx+playerx, offy+playery,offx+playerx+dirx*5, offy+playery+diry*5);
  noStroke();
}

float rotspeed = PI/2f;
float speed = 1.5f;
float bulletspeed = 3f;
float top= 520;
float t =0; float lt =0; float delta;
float aggro = 5f; float enyspeed = .25f;

float health = 100;
void draw() {
  lt=t; t= millis()/1000f;
  delta = t-lt;
  firedelay -=delta;
  background(0);
  dirx = sin(rot);
  diry = cos(rot);
  if(kdw) {
      if(!checkCollision(playerx+dirx*speed,playery+diry*speed)) {
        playery+=diry*speed*delta;
        playerx+=dirx*speed*delta;
      } 
    } else if (kds) {
      if(!checkCollision(playerx-dirx*speed,playery-diry*speed)) {
      playery-=diry*speed*delta;
      playerx-=dirx*speed*delta;
      }
    }
    if (kda) {
      rot+=rotspeed*delta;
    } else if (kdd) {
      rot-=rotspeed*delta;
    } 
  
   ArrayList livebullets = new ArrayList<Bullet>();
  for(int bl = 0; bl<bullets.size(); bl++) {
    Bullet b = bullets.get(bl);
    b.x = b.x+b.dx*bulletspeed*delta;
    b.y = b.y+b.dy*bulletspeed*delta;
    boolean hashit = false;
    if(b.enemybullet) {
      if(playerx<b.x+.2&&playerx>b.x-.2&&playery<b.y+.2&&playery>b.y-.2) {
        health-=b.dmg;
        hashit = true;
        flash = .2f;
      }
    } else {
    for(int e = 0; e<enemies.size(); e++) {
      if(!b.enemybullet && enemies.get(e).hit(b.x,b.y)) {
        enemies.get(e).damage(b.dmg);
        hashit = true;
        if(enemies.get(e).health<=0)splats.add(new Splat(b.x,b.y,.4));
        else splats.add(new Splat(b.x,b.y));
      }
    }
    }
    int pxlx = int(floor(b.x)); int pxly =int(floor(b.y));
    int pxl = pxly*64+pxlx;
    if(pxl <0 || pxl>=level.map.pixels.length) continue;
    if(level.map.pixels[pxl]!=color(0)) { continue;}
    if(!hashit)livebullets.add(b);
  }
  bullets = livebullets;
   ArrayList<Enemy> liveEnemies = new ArrayList<Enemy>();
  for(int e = 0; e<enemies.size(); e++) {
    Enemy eny  =enemies.get(e);
    float enyd =distance(playerx,playery,eny.x,eny.y);
    if(enyd<aggro) {
      float etx = (playerx-eny.x)/enyd;
      float ety = (playery-eny.y)/enyd;
      eny.x+=etx*enyspeed*delta;
      eny.y+=ety*enyspeed*delta;
      if(eny.firedelay <=0) {bullets.add(new Bullet(eny.x,eny.y,etx,ety,10,true)); eny.firedelay = 3.5f;}
    }
    eny.firedelay-=delta;
    if(eny.health > 0) {
      liveEnemies.add(enemies.get(e));
    }
  }
  enemies = liveEnemies;
   ArrayList<Splat> livesplats = new ArrayList<Splat>();
  for(int e = 0; e<splats.size(); e++) {
    if(splats.get(e).lifetime > 0) {
      splats.get(e).lifetime-=delta;
      livesplats.add(splats.get(e));
    }
  }
  float gd = distance(playerx,playery,level.gate.x,level.gate.y);
  if(gd<2f) {
    transition = 1f;
    loadLevel(level.gate.target);
  }
  if(health<=0) {
    dead = true;
    transition = 1f;
  }
  splats = livesplats;
  dirx = sin(rot);
  diry = cos(rot);
  if(showmap)drawminimap();
  //stroke(255);
  noStroke();
  if(transition>0) {
    transition-=delta;
    for(int i = 1; i<=64; i++) {
      int shading = color(dead?0:66,255,int(255*transition));
      fill(shading);
      rect(i*40,top, 40,40);
    }
  } else {
    for(int i = 1; i<=64; i++) {
      float cdirx = sin(rot-PI/2f*i/64f+PI/4f-PI/12f);
      float cdiry = cos(rot-PI/2f*i/64f+PI/4f-PI/12f);
      int shading = trace(playerx,playery,cdirx,cdiry);
      fill(shading);
      
      rect(i*40,top, 40,40);
    }
    if(flash>0) {
      flash-=delta;
      fill(color(0,255,255,(flash/.2f)*255));
      rect(40,top,1940,40);
    }
  }
  fill(0,255,health/100f*255);
  rect(0,top,40,40);
}

float firedelay = 0f;

boolean kdw,kds,kda,kdd;
void keyPressed() {
    if (keyCode == ESC) {
      exit();
    } else if (key == 'w' ||( key==CODED && keyCode == UP)) { kdw = true;
    }  else if (key == 's' ||( key==CODED && keyCode == UP)) { kds = true;
    }  else if (key == 'a' ||( key==CODED && keyCode == UP)) { kda = true;
    }  else if (key == 'd' ||( key==CODED && keyCode == UP)) { kdd = true;
    }  else if (key==' ' && firedelay <=0f) {
      bullets.add(new Bullet(playerx,playery,dirx,diry,50,false)); firedelay = 1f;
    }  else if (key == 'l') {
      showmap=!showmap;
    }  else if (key == 'r') {
      restart();
    }
   
}
void keyReleased() {
    if (key == 'w' ||( key==CODED && keyCode == UP)) { kdw = false;
    }  else if (key == 's' ||( key==CODED && keyCode == UP)) { kds = false;
    }  else if (key == 'a' ||( key==CODED && keyCode == UP)) { kda = false;
    }  else if (key == 'd' ||( key==CODED && keyCode == UP)) { kdd = false;
    }
   
}

int trace(float ox, float oy, float dx, float dy) {
  int q = 0;
  for(int i = 0; i<80; i++) {
    float px = ox,py = oy; px+=dx*i*.2; py+=dy*i*.2;
    
    
    int pxl = int(floor(py))*64+int(floor(px));
    if(pxl <0 || pxl>=level.map.pixels.length) break;
    int bright=int((80f-i)/80f*255);
    color c=level.map.pixels[pxl];
    q=color(hue(c),saturation(c),bright);
    if(level.map.pixels[pxl]!=color(0)) { break;}
    boolean hit = false;
    for(int e = 0; e<enemies.size(); e++) {
      if( enemies.get(e).hit(px,py)) {
        q=color(20,255,bright);  hit = true;
      }
    }
    for(int e = 0; e<bullets.size(); e++) {
      if( bullets.get(e).rayhit(px,py)) {
        q=color(128,255,bright); hit = true;
      }
    }
    for(int e = 0; e<splats.size(); e++) {
      if( splats.get(e).rayhit(px,py)) {
        q=color(0,255,bright); hit = true;
      }
    }
    if(px<gate.x+.3&&px>gate.x-.3&&py<gate.y+.3&&py>gate.y-.3) {
      q=color(200,255,bright); hit = true;
    }
    if(hit) return q;
  }
  return q;
}

float distance(float ax, float ay, float bx, float by) {
  float a = ax-bx;
  float b = ay-by;
  return sqrt(a*a+b*b);
}

void loadLevel(int id) {
  level = new Level(id);
  enemies = level.enemys;
  bullets.clear();
  splats.clear();
  gate = level.gate;
  playerx = level.spawnx;
  playery =level.spawny;
}