/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PVector;
import processing.sound.SoundFile;

public class motkyla
extends PApplet {
    SoundFile file;
    float yoff = 0.0f;
    float theta;
    PFont f;
    float xt = 1990.0f;
    MetaBall[] balls;
    PImage img;
    final int NUM_BALLS = 4;
    final float MIN_SIZE = 8.0f;
    final float MAX_SIZE = 20.0f;
    final int NUM_BANDS = 4;
    float BAND;
    int HALF_W;
    int HALF_H;

    public void setup() {
        this.f = this.createFont("Georgia", 32.0f, false);
        this.balls = new MetaBall[4];
        this.img = this.createImage(this.width, this.height, 4);
        this.img.loadPixels();
        this.HALF_W = this.width / 2;
        this.HALF_H = this.height / 2;
        this.BAND = 63.75f;
        int i = 0;
        while (i < 4) {
            this.balls[i] = new MetaBall(this.random(8.0f, 12.0f));
            ++i;
        }
        this.file = new SoundFile((PApplet)this, "motkyla.mp3");
        this.file.play();
    }

    public float colorLookup(float i) {
        return (float)motkyla.floor((float)(i / 255.0f * 4.0f)) * this.BAND;
    }

    public void draw() {
        this.millis();
        this.background(51);
        int i = 0;
        while (i < 4) {
            this.balls[i].update();
            ++i;
        }
        this.fill(255);
        this.stroke(0);
        this.textFont(this.f, 200.0f);
        this.beginShape();
        float xoff = 0.0f;
        float x = 0.0f;
        while (x <= (float)this.width) {
            float y = motkyla.map((float)this.noise(xoff, this.yoff), (float)0.0f, (float)1.0f, (float)170.0f, (float)300.0f);
            this.vertex(x, y);
            xoff += 0.02f;
            x += 20.0f;
        }
        this.yoff += 0.02f;
        this.vertex(this.width, this.height);
        this.vertex(0.0f, this.height);
        this.text("M\u00f6tkyl\u00e4 bubbling under by Teletubbarna! Made for Chimpbembly 2016 Summer M\u00f6tkyl\u00e4 Competition! Please enjoy your beverages and watch some m\u00f6tkyl\u00e4s bubbling under! Greets goes to everyone at the party and especially YOU for watching this shit!", this.xt, 210.0f);
        this.xt -= 16.0f;
        this.endShape(2);
        if (this.xt < -29700.0f) {
            this.exit();
        }
        int i2 = 0;
        while (i2 < this.height * this.width) {
            float col = 0.0f;
            int m = 0;
            while (m < 4) {
                int y = motkyla.floor((float)(i2 / this.width + 150));
                int x2 = i2 % this.width;
                float xx = ((MetaBall)this.balls[m]).pos.x + (float)this.HALF_W - (float)x2;
                float yy = ((MetaBall)this.balls[m]).pos.y + (float)this.HALF_H - (float)y;
                col += this.balls[m].radius / motkyla.sqrt((float)(xx * xx + yy * yy));
                ++m;
            }
            this.img.pixels[i2] = this.color(255.0f - this.colorLookup(255.0f * col), 100.0f);
            ++i2;
        }
        this.img.updatePixels();
        this.image(this.img, 0.0f, 270.0f);
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"motkyla"};
        if (passedArgs != null) {
            PApplet.main((String[])motkyla.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class MetaBall {
        private PVector pos;
        private float radius;
        private PVector dir;

        MetaBall(float r) {
            this.dir = new PVector(motkyla.this.random(-1.0f, 1.0f), motkyla.this.random(-1.0f, 1.0f));
            this.dir.normalize();
            this.pos = new PVector(0.0f, 0.0f);
            this.radius = r;
        }

        public void update() {
            this.pos.add(this.dir);
            if (motkyla.abs((float)this.pos.x) > (float)(motkyla.this.width / 4)) {
                this.dir.x *= -1.0f;
            }
            if (motkyla.abs((float)this.pos.y) > (float)(motkyla.this.height / 6)) {
                this.dir.y *= -1.0f;
            }
        }
    }
}

