/*
 * Decompiled with CFR 0.152.
 */
package com.petterroea.neural;

import com.petterroea.neural.INode;
import java.util.LinkedList;

public class InputNode
implements INode {
    private float value = 0.0f;
    private String name = "UNKNOWN";
    private LinkedList<INode> outputs = new LinkedList();

    public InputNode(float value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setInput(float value) {
        this.value = value;
    }

    @Override
    public boolean canConnectInput() {
        return false;
    }

    @Override
    public void connectInput(INode n) {
    }

    @Override
    public boolean canSimulate() {
        return true;
    }

    @Override
    public void simulate() {
        for (INode output : this.outputs) {
            if (!output.canSimulate()) continue;
            output.simulate();
        }
    }

    @Override
    public void connectOutput(INode n) {
        this.outputs.add(n);
    }

    @Override
    public boolean canConnectOutput() {
        return true;
    }

    @Override
    public float getOutput() {
        return this.value;
    }

    @Override
    public boolean hasSimulated() {
        return true;
    }

    @Override
    public void reset() {
    }

    @Override
    public void disconnectInput(INode n) {
    }

    @Override
    public void disconnectOutput(INode n) {
        this.outputs.remove(n);
    }

    @Override
    public int getNeededInputs() {
        return 0;
    }

    @Override
    public int getNeededOutputs() {
        return this.outputs.size() > 0 ? 0 : 1;
    }
}

