/*
 * Decompiled with CFR 0.152.
 */
package com.petterroea.neural;

import com.petterroea.neural.INode;
import java.util.LinkedList;

public class DivisionNode
implements INode {
    private LinkedList<INode> inputs = new LinkedList();
    private LinkedList<INode> outputs = new LinkedList();
    private boolean hasSimulated = false;
    private float value = 0.0f;

    @Override
    public boolean canConnectInput() {
        return this.inputs.size() < 2;
    }

    @Override
    public void connectInput(INode n) {
        if (this.inputs.size() < 2) {
            this.inputs.add(n);
        }
    }

    @Override
    public void disconnectInput(INode n) {
        this.inputs.remove(n);
    }

    @Override
    public int getNeededInputs() {
        return 2 - this.inputs.size();
    }

    @Override
    public boolean canSimulate() {
        for (INode node : this.inputs) {
            if (node.hasSimulated()) continue;
            return false;
        }
        return this.inputs.size() == 2 && !this.hasSimulated();
    }

    @Override
    public void simulate() {
        if (this.canSimulate()) {
            float nevnerOutput = this.inputs.get(1).getOutput();
            this.value = this.inputs.get(0).getOutput() / (nevnerOutput == 0.0f ? 1.0f : nevnerOutput);
            this.hasSimulated = true;
            for (INode outputNode : this.outputs) {
                if (!outputNode.canSimulate()) continue;
                outputNode.simulate();
            }
        }
    }

    @Override
    public boolean hasSimulated() {
        return this.hasSimulated;
    }

    @Override
    public void connectOutput(INode n) {
        this.outputs.add(n);
    }

    @Override
    public boolean canConnectOutput() {
        return true;
    }

    @Override
    public void disconnectOutput(INode n) {
        this.outputs.remove(n);
    }

    @Override
    public float getOutput() {
        return this.value;
    }

    @Override
    public int getNeededOutputs() {
        return this.outputs.size() > 0 ? 0 : 1;
    }

    @Override
    public void reset() {
        this.hasSimulated = false;
    }
}

