//Globals:
var spritesheet = null;
var counter = 0;
var bubbles = [];
var bubblesToBurst = 0;
var burstBubbles = [];
var ctx, can;
var backgroundImage;
var bursting = false;
var burstCounter = 0;

var canvas = {
	init: function() {
		can = document.getElementById("myCanvas");
		ctx = can.getContext("2d");
		can.height = 300;
		can.width = 400;

		spritesheet = new Image();
		spritesheet.src = 'bubble.png';

		burstImage = new Image();
		burstImage.src = 'icon.png';

		backgroundImage = new Image();
		backgroundImage.src = 'background.png';

		for (var i = 0; i < 15; i++) {
			var bubble = canvas.makeBubble();
			bubbles.push(bubble);
		};

		for (var i = 0; i < 20; i++) {
			var bubble = canvas.makeBurstBubble();
			burstBubbles.push(bubble);
		};

		can.addEventListener('mousedown', function(evt) {
			canvas.mouseClicked(can, evt, ctx);
		}, false);

		canvas.update();
	},

	update: function() {
		var bubbleLength = bubbles.length;
		for (var i = 0; i < bubbleLength; i++) {
			if (bubbles[i].y > -10) {
				bubbles[i].y -= bubbles[i].speed;
			} else {
				bubbles[i].y = 400;
			}
		};
		canvas.draw();

		if (bursting) {
			canvas.burstAnimation();
		}
		requestAnimationFrame(canvas.update);
	},

	draw: function() {
		ctx.clearRect(0, 0, can.width, can.height);

		ctx.drawImage(backgroundImage, 0, 0);

		var bubbleLength = bubbles.length;
		for (var i = 0; i < bubbleLength; i++) {
			ctx.drawImage(spritesheet, bubbles[i].x - 25, bubbles[i].y - 25);
		};
	},

	makeBubble: function(ctx) {
		var newBubble = {
			x: 25 + (Math.random() * 275),
			y: 400,
			speed: Math.random() * 3
		};
		return newBubble;
	},

	makeBurstBubble: function(ctx) {
		var newBubble = {
			x: 25 + (Math.random() * 275),
			y: 400,
			xVel: 0,
			yVel: 0
		};
		return newBubble;
	},

	burstAnimation: function() {
		for (var i = 0; i < burstLength; i++) {
			burstBubbles[i].x += burstBubbles[i].xVel;
			burstBubbles[i].y += burstBubbles[i].yVel;
			ctx.drawImage(burstImage, burstBubbles[i].x - 25, burstBubbles[i].y - 25);
		};

		if (burstCounter-- < 1) {
			bursting = false;
		}
	},

	mouseClicked: function(can, evt, ctx) {
		var rect = can.getBoundingClientRect();
		var x = evt.clientX - rect.left;
		var y = evt.clientY - rect.top;

		var bubbleLength = bubbles.length;
		for (var i = 0; i < bubbleLength; i++) {
			var hittingBubble = y < bubbles[i].y + 25 && y > bubbles[i].y - 25 && x < bubbles[i].x + 25 && x > bubbles[i].x - 25;
			if (hittingBubble) {
				bubbles[i].y = 400;

				//Making the burst
				burstLength = burstBubbles.length;
				var burstX = 0;
				var burstY = 0;
				for (var i = 0; i < burstLength; i++) {
					if (i < 5) {
						burstX = +1 + Math.random() * 4;
						burstY = +1 + Math.random() * 4;
					} else if (i < 10) {
						burstX = -1 - Math.random() * 4;
						burstY = -1 - Math.random() * 4;
					} else if (i < 15) {
						burstX = -1 - Math.random() * 4;
						burstY = +1 + Math.random() * 4;
					} else {
						burstX = +1 + Math.random() * 4;
						burstY = -1 - Math.random() * 4;
					}
					burstBubbles[i].xVel = burstX;
					burstBubbles[i].yVel = burstY;
					burstBubbles[i].x = x;
					burstBubbles[i].y = y;
					bursting = true;
					burstCounter = 60;
				};
			}
		};
	}
};

document.addEventListener('DOMContentLoaded', function() {
	canvas.init();
});