/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioEffect;
import ddf.minim.AudioListener;
import ddf.minim.Minim;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.javasound.FloatSampleBuffer;
import ddf.minim.spi.AudioStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.TargetDataLine;

final class JSAudioInput
extends Thread
implements AudioStream {
    private AudioListener listener;
    private AudioEffect effect;
    private TargetDataLine line;
    private FloatSampleBuffer buffer;
    private int bufferSize;
    private boolean finished;
    private boolean mono;
    private byte[] rawBytes;

    JSAudioInput(TargetDataLine targetDataLine, int n) {
        this.line = targetDataLine;
        this.bufferSize = n;
        this.buffer = new FloatSampleBuffer(targetDataLine.getFormat().getChannels(), n, targetDataLine.getFormat().getSampleRate());
        this.finished = false;
        this.mono = this.buffer.getChannelCount() == 1;
        int n2 = this.buffer.getByteArrayBufferSize(this.line.getFormat());
        Minim.debug((String)("byteBufferSize is " + n2));
        this.rawBytes = new byte[n2];
    }

    @Override
    public void run() {
        this.line.start();
        while (!this.finished) {
            float[] fArray;
            this.line.read(this.rawBytes, 0, this.rawBytes.length);
            this.buffer.setSamplesFromBytes(this.rawBytes, 0, this.line.getFormat(), 0, this.buffer.getSampleCount());
            if (this.mono) {
                fArray = this.buffer.getChannel(0);
                this.effect.process(fArray);
                this.listener.samples(fArray);
            } else {
                fArray = this.buffer.getChannel(0);
                float[] fArray2 = this.buffer.getChannel(1);
                this.effect.process(fArray, fArray2);
                this.listener.samples(fArray, fArray2);
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.line.flush();
        this.line.stop();
        this.line.close();
        this.line = null;
    }

    public void open() {
        this.line.start();
    }

    public void close() {
        this.finished = true;
        this.line.flush();
        this.line.stop();
        this.line.close();
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public AudioFormat getFormat() {
        return this.line.getFormat();
    }

    public void setAudioEffect(AudioEffect audioEffect) {
        this.effect = audioEffect;
    }

    public void setAudioListener(AudioListener audioListener) {
        this.listener = audioListener;
    }

    public Control[] getControls() {
        return this.line.getControls();
    }

    public float[] read() {
        int n = 1;
        byte[] byArray = new byte[this.line.getFormat().getFrameSize()];
        this.line.read(byArray, 0, byArray.length);
        this.buffer.setSamplesFromBytes(byArray, 0, this.line.getFormat(), 0, n);
        float[] fArray = new float[this.buffer.getChannelCount()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.buffer.getChannel(i)[0];
        }
        return fArray;
    }

    public void read(MultiChannelBuffer multiChannelBuffer) {
        int n = this.line.getFormat().getChannels();
        int n2 = multiChannelBuffer.getBufferSize();
        float f = this.line.getFormat().getSampleRate();
        FloatSampleBuffer floatSampleBuffer = new FloatSampleBuffer(n, n2, f);
        byte[] byArray = new byte[floatSampleBuffer.getByteArrayBufferSize(this.line.getFormat())];
        this.line.read(byArray, 0, byArray.length);
        floatSampleBuffer.setSamplesFromBytes(byArray, 0, this.line.getFormat(), 0, n2);
        multiChannelBuffer.setChannelCount(n);
        for (int i = 0; i < floatSampleBuffer.getChannelCount(); ++i) {
            multiChannelBuffer.setChannel(i, floatSampleBuffer.getChannel(i));
        }
    }
}

