/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.Minim;
import ddf.minim.UGen;
import java.util.Arrays;

public class Line
extends UGen {
    private float begAmp;
    private float endAmp;
    private float amp;
    private float lineTime;
    private float timeStepSize;
    private float lineNow;
    private boolean isActivated;

    public Line() {
        this(1.0f, 1.0f, 0.0f);
    }

    public Line(float f) {
        this(f, 1.0f, 0.0f);
    }

    public Line(float f, float f2) {
        this(f, f2, 0.0f);
    }

    public Line(float f, float f2, float f3) {
        this.lineTime = f;
        this.amp = this.begAmp = f2;
        this.endAmp = f3;
        this.lineNow = 0.0f;
        this.isActivated = false;
        Minim.debug(" dampTime = " + this.lineTime + " begAmp = " + this.begAmp + " now = " + this.lineNow);
    }

    public void activate() {
        this.lineNow = 0.0f;
        this.amp = this.begAmp;
        this.isActivated = true;
    }

    public void activate(float f, float f2, float f3) {
        this.begAmp = f2;
        this.endAmp = f3;
        this.lineTime = f;
        this.activate();
    }

    public boolean isAtEnd() {
        return this.lineNow >= this.lineTime;
    }

    public void setEndAmp(float f) {
        this.endAmp = f;
    }

    public void setLineTime(float f) {
        this.lineTime = f;
    }

    @Override
    protected void sampleRateChanged() {
        this.timeStepSize = 1.0f / this.sampleRate();
    }

    @Override
    protected void uGenerate(float[] fArray) {
        if (!this.isActivated) {
            Arrays.fill(fArray, this.begAmp);
        } else if (this.lineNow >= this.lineTime) {
            Arrays.fill(fArray, this.endAmp);
        } else {
            this.amp += (this.endAmp - this.amp) * this.timeStepSize / (this.lineTime - this.lineNow);
            Arrays.fill(fArray, this.amp);
            this.lineNow += this.timeStepSize;
        }
    }
}

