package skyport;

import java.util.HashMap;
import java.util.Map;

import skyport.enums.Tile;
import skyport.enums.WeaponType;

public class WeaponResource {

	private static final WeaponResource instance = new WeaponResource();

	private final Map<WeaponType, Tile> weaponResource;

	private WeaponResource() {
		weaponResource = new HashMap<WeaponType, Tile>();

		weaponResource.put(WeaponType.DROID, Tile.SCRAP);
		weaponResource.put(WeaponType.LASER, Tile.RUBIDIUM);
		weaponResource.put(WeaponType.MORTAR, Tile.EXPLODIUM);
	}

	public Tile getResource(WeaponType weaponType) {
		return weaponResource.get(weaponType);
	}

	public static WeaponResource getInstance() {
		return instance;
	}
}
