package skyport;

import skyport.enums.Tile;
import skyport.enums.TileFactory;
import skyport.json.MapBean;

public class Tilemap {

	private MapBean mapData;
	private Tile[][] tiles;

	public Tilemap() {
		mapData = null;
		tiles = null;
	}

	public void setMapData(final MapBean mapData) {
		this.mapData = mapData;
		tiles = TileFactory.getInstance().convertTo2DTileArray(
				mapData.getData());
	}

	public Tile[][] getTiles() {
		return tiles;
	}

	public int getJLength() {
		return mapData.getJlength();
	}

	public int getKLength() {
		return mapData.getKlength();
	}

	public Tile getTileAt(Coordinate coordinate) {
		if (legalCoordinate(coordinate)) {
			return tiles[coordinate.getX()][coordinate.getY()];
		} else {
			return null;
		}
	}

	public boolean legalCoordinate(Coordinate coordinate) {
		int x = coordinate.getX();
		int y = coordinate.getY();

		return x >= 0 && y >= 0 && x < mapData.getJlength()
				&& y < mapData.getKlength();
	}
}
