/*
 * Decompiled with CFR 0.152.
 */
package skyport;

import java.util.HashMap;
import java.util.Map;
import skyport.WeaponResource;
import skyport.constants.GameConstants;
import skyport.enums.Tile;
import skyport.enums.WeaponType;
import skyport.json.WeaponBean;

public class PlayerResources {
    private Map<Tile, Integer> resourceCount = new HashMap<Tile, Integer>();

    public PlayerResources() {
        Tile[] tileArray = Tile.values();
        int n = tileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Tile tile = tileArray[n2];
            if (tile.isMineable()) {
                this.resourceCount.put(tile, 0);
            }
            ++n2;
        }
    }

    public int getResourceCount(Tile tile) {
        if (tile.isMineable()) {
            return this.resourceCount.get((Object)tile);
        }
        return 0;
    }

    public void incrementResourceCount(Tile tile) {
        if (tile.isMineable()) {
            Integer count = this.resourceCount.get((Object)tile);
            count = count + 1;
            this.resourceCount.put(tile, count);
        }
    }

    public boolean upgradeWeaponIfPossible(WeaponBean weapon) {
        WeaponType type = weapon.getType();
        int level = weapon.getLevel();
        if (level < 1 || level >= 3) {
            return false;
        }
        int resourceNeed = GameConstants.RESOURCES_TO_UPGRADE[level - 1];
        Tile resource = WeaponResource.getInstance().getResource(type);
        Integer count = this.resourceCount.get((Object)resource);
        if (count >= resourceNeed) {
            count = count - resourceNeed;
            this.resourceCount.put(resource, count);
            return true;
        }
        return false;
    }

    public void upgradeWeapon(WeaponBean weapon) {
        WeaponType type = weapon.getType();
        int level = weapon.getLevel();
        if (level < 1 || level >= 3) {
            return;
        }
        int resourceNeed = GameConstants.RESOURCES_TO_UPGRADE[level - 1];
        Tile resource = WeaponResource.getInstance().getResource(type);
        Integer count = this.resourceCount.get((Object)resource);
        count = count - resourceNeed;
        this.resourceCount.put(resource, count);
    }
}

