#ifndef __MAP_H__
#define __MAP_H__

#include <jansson.h>

extern int map_j, map_k, map_size;
extern char *map;

#define map_coords(j, k)     ((k) * map_j + (j))
#define map_j_val(coords)    ((coords) % map_j)
#define map_k_val(coords)    ((coords) / map_j)
#define map_get(j, k)        (map[map_coords(j, k)])
#define map_set(j, k, value) (map[map_coords(j, k)] = (value))

void update_map_from_json(int initial, json_t *json);

#endif
