varying vec4 pos;
varying vec3 normal;
uniform float bulge;

float PI = 3.14159265358979323846264;

void main( void )
{
	normal = gl_NormalMatrix * gl_Normal;
    vec4 vertex = gl_Vertex;
    gl_TexCoord[0] = gl_MultiTexCoord0;
	
    float ty = (gl_TexCoord[0].y * 1.25) - (0.25 / 2.0);
    ty = clamp(ty, 0.0, 1.0);    
    vertex.x *= 1.0 + (bulge * sin(ty * PI));
    vertex.z *= 1.0 + (bulge * sin(ty * PI));
 	gl_Position = gl_ModelViewProjectionMatrix * vertex;
	pos = vertex;	
}