#include version.txt

varying vec4 diffuse;
varying vec4 ambient;
varying vec3 normal;
varying vec3 normallightDir;
varying vec3 normalhalfVector;
varying float dist;
varying vec3 lightDir;
varying vec3 halfVector;

void main() {
	vec3 n;
	vec3 halfV;
	vec3 viewV;
	float NdotL;
	float NdotHV;
	vec4 color = vec4(0.0);
	float att;

	n = normalize(normal);

	NdotL = max(dot(n, normalize(lightDir)), 0.0);
	if (NdotL > 0.0) {

		att = 1.0 / (gl_LightSource[0].constantAttenuation +
				         gl_LightSource[0].linearAttenuation * dist +
				         gl_LightSource[0].quadraticAttenuation * dist * dist);
				         
		color += att * (diffuse * NdotL + ambient);
		
		halfV = normalize(halfVector);

		NdotHV = max(dot(n, halfV), 0.0);
		
		color += att * gl_FrontMaterial.specular * gl_LightSource[0].specular * pow(NdotHV, gl_FrontMaterial.shininess);
	}
	gl_FragColor = color + (gl_FragCoord.z - 0.5);	
//	gl_FragColor = color;	

}