uniform vec4 background_color;
uniform float MaterialIndex;
uniform sampler2D texture;
uniform sampler2D frequency;
uniform vec2 repeat;

varying vec2 Texcoord;
varying vec3 normals;

void main( void )
{
	vec2 tx = Texcoord * repeat;	
	vec4 diffuse = texture2D(texture, tx);
	float mask = texture2D(frequency, Texcoord).r;
	if(diffuse.a == 0.0)
	{
		gl_FragData[0] = vec4(background_color.rgb, MaterialIndex/255.0);
		gl_FragData[1] = vec4(normalize(normals.xyz), 0.0); // normals	
	}
	else
	{
		gl_FragData[0] = vec4(diffuse.rgb * diffuse.a * mask, 4.0 / 255.0);
		gl_FragData[1] = vec4(normalize(normals.xyz), 0.0); // normals
	}
}
