uniform float MaterialIndex;

#ifdef COLOR
uniform vec3 color;
#endif

#ifdef TEXTURE
uniform sampler2D texture;
varying vec2 Texcoord;
uniform vec3 color;
#endif

#ifdef NORMALMAP
uniform sampler2D texture;
uniform sampler2D NormalMap;
varying vec2 Texcoord;
uniform vec3 color;
#endif

varying vec3 normals;
varying vec4 postion;

void main( void )
{
#ifdef COLOR
	gl_FragData[0] = vec4(color, MaterialIndex/255.0);
	gl_FragData[1] = vec4(normalize(normals.xyz), 0.0); // normals
#endif
#ifdef TEXTURE 
	gl_FragData[0] = vec4(texture2D(texture, Texcoord).xyz * color, MaterialIndex/255.0);
	gl_FragData[1] = vec4(normalize(normals.xyz), 0.0); // normals
#endif
#ifdef NORMALMAP 

	vec3 tangent; 
	vec3 binormal; 
	vec3 c1 = cross(normals, vec3(0.0, 0.0, 1.0)); 
	vec3 c2 = cross(normals, vec3(0.0, 1.0, 0.0)); 
	if(length(c1)<length(c2)) tangent = c1;	
	else tangent = c2;	

	tangent = normalize(tangent);
	binormal = cross(normals, tangent); 
	binormal = normalize(binormal);
	mat3 rotmat = mat3(tangent,binormal,normals);
	vec3 bumpNorm = rotmat * ( (texture2D(NormalMap, Texcoord).rgb) * 2.0 - 1.0 );

	gl_FragData[0] = vec4(texture2D(texture, Texcoord).xyz * color, MaterialIndex/255.0);
	gl_FragData[1] = vec4(normalize(bumpNorm.xyz), 0.0); // normals
#endif
}
