
uniform sampler2D diffuseBuffer;
uniform sampler2D depthBuffer;
uniform sampler2D normalBuffer;
uniform sampler2D materialBuffer;
uniform samplerCube cubeMap;

uniform vec2 ProjConst; // Projection constants depth
uniform float lightRadius;
uniform vec3 lightPos;
uniform vec4 color;
uniform vec2 screensize;
//uniform mat3 rotM;

varying vec3 viewRay;
varying mat3 lightRot;

float ReadSurfaceMaterial(in vec2 uv, out vec4 specular)
{
	float matIndex = texture2D(diffuseBuffer, uv).a * 255.0 + 1.0;
	float dx = 1.0 / 8.0;   // width * 2
	float dy = 1.0 / 512.0; // heght * 2
	specular        = texture2D( materialBuffer, vec2(dx * (2.0 * 2.0 - 1.0), dy * (matIndex * 2.0 - 1.0)) );
	float shininess = texture2D( materialBuffer, vec2(dx * (3.0 * 2.0 - 1.0), dy * (matIndex * 2.0 - 1.0)) ).r * 255.0;
	return shininess;
}

void main( void )
{
	vec2 uv = vec2(gl_FragCoord.x / screensize.x, gl_FragCoord.y / screensize.y);
	// color
	vec4 colorPass = texture2D(diffuseBuffer, uv);
	// Normal
	vec4 gnormal = texture2D(normalBuffer, uv);	
	vec3 normal = normalize(gnormal.xyz);
	
	// View position reconstruct
	float depth = texture2D(depthBuffer, uv).r;
	vec3 ray = vec3(viewRay.xy / -viewRay.z, -1.0);
	float linearDepth = ProjConst.y  / (depth - ProjConst.x);
	vec3 point = ray * linearDepth;
	
	// point light normal
	vec3 light_norm = normalize(lightPos - point);
	// Distance from the light center and the current pixel
	float distance = length(lightPos - point);
	// Angle between the point normal and light normal
	float ndl = dot(normal, light_norm);
	vec4 finalcolor = vec4(0.0, 0.0, 0.0, 1.0);
	if(ndl > 0.0)
	{
		vec3 reflectV = 2.0 * normal * ndl + -light_norm; // reflect(normal, light_norm);
		float ldr = max(dot(reflectV, -normalize(point) ), 0.0);
		float ndlm = ndl * (1.0 - (distance / lightRadius));
		// materials
		vec4 specular;
		float shininess = ReadSurfaceMaterial(uv, specular);		
		finalcolor = colorPass * color * ndlm + color * specular * pow(ldr, shininess) * ndlm;
	}
	if(distance > lightRadius) discard; // gl_FragColor = vec4(1.0, 0.0, 0.0, 0.1);  // This SHOULD be culled by stencil passes if used
	else 
	{
		vec4 sc;
		sc = finalcolor * (1.0 - textureCube(cubeMap, lightRot * light_norm).g + 0.25);
		float d = 0.0005;
		sc += finalcolor * (1.0 - textureCube(cubeMap, lightRot * light_norm + vec3(d, d, d) ).g + 0.25);
		sc += finalcolor * (1.0 - textureCube(cubeMap, lightRot * light_norm + vec3(-d, -d, d) ).g + 0.25);
		sc += finalcolor * (1.0 - textureCube(cubeMap, lightRot * light_norm + vec3(-d, d, d) ).g + 0.25);
		sc += finalcolor * (1.0 - textureCube(cubeMap, lightRot * light_norm + vec3(d, -d, d) ).g + 0.25);
		sc += finalcolor * (1.0 - textureCube(cubeMap, lightRot * light_norm + vec3(d, d, -d) ).g + 0.25);
		sc += finalcolor * (1.0 - textureCube(cubeMap, lightRot * light_norm + vec3(-d, -d, -d) ).g + 0.25);
		sc += finalcolor * (1.0 - textureCube(cubeMap, lightRot * light_norm + vec3(-d, d, -d) ).g + 0.25);
		sc += finalcolor * (1.0 - textureCube(cubeMap, lightRot * light_norm + vec3(d, -d, -d) ).g + 0.25);
		gl_FragColor = sc / 9.0;
//		gl_FragColor = sc;
	}
	
}

