uniform sampler2D original;
uniform sampler2D level1;
uniform sampler2D level2;
uniform sampler2D level3;
uniform sampler2D depth_buffer;
uniform float level1_size;
uniform float level2_size;
uniform float level3_size;
uniform float near;
uniform float far;
//uniform float focus_point;
uniform float focus_range;
float blurred_range = 1.0 - focus_range;
float level_range = blurred_range / 3.0;



float mapto(float value) {
  return (1.0 / level_range) * value;
}



vec3 getLevel1Sample() {
  float step = 1.0 / level1_size;
  float halfstep = step / 2.0;
	vec3 l1  = texture2D(level1, gl_TexCoord[0].xy                             ).rgb * (4.0 / 12.0);	
	     l1 += texture2D(level1, gl_TexCoord[0].xy + vec2(      0.0, -halfstep)).rgb * (2.0 / 12.0);
	     l1 += texture2D(level1, gl_TexCoord[0].xy + vec2( halfstep,       0.0)).rgb * (2.0 / 12.0);
	     l1 += texture2D(level1, gl_TexCoord[0].xy + vec2(      0.0,  halfstep)).rgb * (2.0 / 12.0);
	     l1 += texture2D(level1, gl_TexCoord[0].xy + vec2(-halfstep,       0.0)).rgb * (2.0 / 12.0);
  return l1;
//  return l1 / 5.0;
}


vec3 getLevel2Sample() {
  float step = 1.0 / level2_size;    
  float halfstep = step / 2.0;
	vec3 l2  = texture2D(level2, gl_TexCoord[0].xy                             ).rgb * (4.0 / 12.0);
	     l2 += texture2D(level2, gl_TexCoord[0].xy + vec2(      0.0, -halfstep)).rgb * (2.0 / 12.0);
	     l2 += texture2D(level2, gl_TexCoord[0].xy + vec2( halfstep,       0.0)).rgb * (2.0 / 12.0);
	     l2 += texture2D(level2, gl_TexCoord[0].xy + vec2(      0.0,  halfstep)).rgb * (2.0 / 12.0);
	     l2 += texture2D(level2, gl_TexCoord[0].xy + vec2(-halfstep,       0.0)).rgb * (2.0 / 12.0);
  return l2;
//  return l2 / 5.0;
}


vec3 getLevel3Sample() {
  float step = 1.0 / level3_size;
  float halfstep = step / 2.0;  
  
	vec3 l3  = texture2D(level2, gl_TexCoord[0].xy                             ).rgb * (4.0 / 12.0);
	     l3 += texture2D(level2, gl_TexCoord[0].xy + vec2(      0.0, -halfstep)).rgb * (2.0 / 12.0);
	     l3 += texture2D(level2, gl_TexCoord[0].xy + vec2( halfstep,       0.0)).rgb * (2.0 / 12.0);
	     l3 += texture2D(level2, gl_TexCoord[0].xy + vec2(      0.0,  halfstep)).rgb * (2.0 / 12.0);
	     l3 += texture2D(level2, gl_TexCoord[0].xy + vec2(-halfstep,       0.0)).rgb * (2.0 / 12.0);
  return l3;
 
 /*
	vec3 l3  = texture2D(level3, gl_TexCoord[0].xy                             ).rgb * (4.0 / 16.0);
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2(      0.0, -halfstep)).rgb * (2.0 / 16.0);
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2( halfstep,       0.0)).rgb * (2.0 / 16.0);
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2(      0.0,  halfstep)).rgb * (2.0 / 16.0);
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2(-halfstep,       0.0)).rgb * (2.0 / 16.0);
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2(-halfstep, -halfstep)).rgb * (1.0 / 16.0);
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2( halfstep, -halfstep)).rgb * (1.0 / 16.0);
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2( halfstep,  halfstep)).rgb * (1.0 / 16.0);
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2(-halfstep,  halfstep)).rgb * (1.0 / 16.0);
  return l3;
*/  
  /*
	vec3 l3  = texture2D(level3, gl_TexCoord[0].xy                             ).rgb;
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2(      0.0, -halfstep)).rgb;
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2( halfstep,       0.0)).rgb;
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2(      0.0,  halfstep)).rgb;
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2(-halfstep,       0.0)).rgb;
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2(-halfstep, -halfstep)).rgb;
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2( halfstep, -halfstep)).rgb;
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2( halfstep,  halfstep)).rgb;
	     l3 += texture2D(level3, gl_TexCoord[0].xy + vec2(-halfstep,  halfstep)).rgb;
  return l3 / 9.0;
  */
}


void main() {

  float z = texture2D(depth_buffer, gl_TexCoord[0].xy).r;
  float depth = (2.0 * near) / (far + near - z * (far - near));
  depth = clamp(depth, 0.0, 1.0);


  // Level 0 -> 1
  if(depth < focus_range) {  
    vec3 o = texture2D(original, gl_TexCoord[0].xy).rgb;   		    
    gl_FragColor = texture2D(original, gl_TexCoord[0].xy);
  }

  // Level 1 -> 2
  if(depth > focus_range && depth < focus_range + level_range){
    float mixfactor = mapto(depth - focus_range);
    vec3 o = texture2D(original, gl_TexCoord[0].xy).rgb;   		    
    gl_FragColor = vec4(mix(o, getLevel1Sample(), mixfactor),1.0);
  }

  // Level 2 -> 3
  if(depth > focus_range + level_range && depth < focus_range + (level_range * 2.0)) { 
    float mixfactor = mapto(depth - (focus_range + level_range));
    gl_FragColor = vec4(mix(getLevel1Sample(), getLevel2Sample(), mixfactor),1.0);    
  }

  // Level 3
  if(depth > focus_range + (level_range * 2.0)) {
    float mixfactor = mapto(depth - (focus_range + (level_range * 2.0)));
    gl_FragColor = vec4(mix(getLevel2Sample(), getLevel3Sample(), mixfactor),1.0);    
  }
}




/*
focus_range = 0.25;
blurred_range = 1.0 - focus_range = 0.75;
level_range = blurred_range / 3.0 = 0.25;


float mapto(value) {
  return (1.0 / level_range) * value;
}


if(d < focus_range)
  color = original
  
if(d > focus_range && d < focus_range + level_range)
  mixfactor = mapto(d - focus_range);
  color = mix(original, level1, mixfactor);

if(d > focus_range + level_range && d < focus_range + (level_range * 2.0))  
  mixfactor = mapto(d - (focus_range + level_range));
  color = mix(level1, level2, mixfactor);

if(d > focus_range + (level_range * 2.0))  
  mixfactor = mapto(d - (focus_range + (level_range * 2.0)));
  color = mix(level2, level3, mixfactor);

*/