/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct.util;

import com.threed.jpct.util.XMLNode;
import java.util.Vector;

public final class XMLFactory {
    private static XMLFactory instance = null;

    private XMLFactory() {
    }

    public static synchronized XMLFactory getInstance() {
        if (instance == null) {
            instance = new XMLFactory();
        }
        return instance;
    }

    public XMLNode parseXML(String string) {
        Vector vector = this.parseXML(string + " ", 0);
        if (vector != null) {
            return (XMLNode)vector.elementAt(0);
        }
        return null;
    }

    private Vector parseXML(String string, int n) {
        int n2 = 0;
        Vector<XMLNode> vector = null;
        String string2 = null;
        do {
            if ((n2 = this.getNextTag(n2, string)) == -1 || (string2 = this.extractTag(++n2, string)).length() <= 0) continue;
            int n3 = this.getEndTag(n2, -1, string2, string);
            if (n3 != -1) {
                XMLNode xMLNode = new XMLNode();
                xMLNode.setName(string2);
                xMLNode.setLevel(n);
                xMLNode.setAttributes(this.getAttributes(n2, string));
                Vector vector2 = this.parseXML(string.substring(n2 + string2.length(), n3), n + 1);
                if (vector2 != null) {
                    xMLNode.setSubNodes(vector2);
                }
                if (vector2 == null || vector2.size() == 0) {
                    xMLNode.setData(this.grabData(n2, n3, string));
                }
                if (vector == null) {
                    vector = new Vector<XMLNode>(5);
                }
                vector.addElement(xMLNode);
            }
            n2 = n3;
        } while (n2 != -1);
        return vector;
    }

    public void filter(XMLNode xMLNode, XMLNode xMLNode2) {
        this.filter(xMLNode, xMLNode, xMLNode2, xMLNode.getName());
    }

    private void filter(XMLNode xMLNode, XMLNode xMLNode2, XMLNode xMLNode3, String string) {
        Vector vector = xMLNode2.getSubNodes();
        if (vector != null) {
            int n;
            int[] nArray = new int[vector.size()];
            int n2 = 0;
            for (n = 0; n < vector.size(); ++n) {
                XMLNode xMLNode4 = (XMLNode)vector.elementAt(n);
                String string2 = string + "/" + xMLNode4.getName();
                if (this.getMatchingNodes(string2, xMLNode3).size() == 0) {
                    nArray[n2] = n;
                    ++n2;
                    continue;
                }
                this.filter(xMLNode, xMLNode4, xMLNode3, string2);
            }
            for (n = 0; n < n2; ++n) {
                xMLNode2.removeSubNode(nArray[n] - n);
            }
        }
    }

    public Vector getMatchingNodes(String string, XMLNode xMLNode) {
        if (string.charAt(string.length() - 1) != '/') {
            string = string + "/";
        }
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        Vector vector = new Vector();
        this.getMatchingNodes(string, xMLNode, "", vector);
        return vector;
    }

    private void getMatchingNodes(String string, XMLNode xMLNode, String string2, Vector vector) {
        String string3 = string2 + xMLNode.getName() + "/";
        if (!string.equals(string3)) {
            Vector vector2;
            if (string.startsWith(string3) && (vector2 = xMLNode.getSubNodes()) != null) {
                for (int i = 0; i < vector2.size(); ++i) {
                    XMLNode xMLNode2 = (XMLNode)vector2.elementAt(i);
                    this.getMatchingNodes(string, xMLNode2, string3, vector);
                }
            }
        } else {
            vector.addElement(xMLNode);
        }
    }

    private Vector getAttributes(int n, String string) {
        int n2;
        Vector<String[]> vector = new Vector<String[]>(3);
        int n3 = string.indexOf("/>", n);
        int n4 = string.indexOf(">", n);
        if (n3 == -1) {
            n3 = n4;
        } else if (n4 < n3) {
            n3 = n4;
        }
        if (n3 != -1 && (n2 = string.indexOf(" ", n)) != -1 && n2 < n3) {
            String string2 = string.substring(n2, n3) + " ";
            n2 = 0;
            int n5 = 0;
            String string3 = null;
            String string4 = null;
            do {
                int n6;
                if ((n5 = string2.indexOf("=", ++n2)) == -1) continue;
                string3 = string2.substring(n2, n5).trim();
                n2 = string2.indexOf(" ", ++n5);
                if (string2.charAt(n5) == '\"') {
                    n6 = string2.indexOf("\"", n5 + 1);
                    if (n6 != -1 && n6 > n2) {
                        n2 = n6;
                    }
                } else if (string2.charAt(n5) == '\'' && (n6 = string2.indexOf("'", n5 + 1)) != -1 && n6 > n2) {
                    n2 = n6;
                }
                if (n2 == -1 || string3.length() <= 0) continue;
                string4 = string2.substring(n5, n2).trim();
                if (string4.charAt(0) == '\"') {
                    string4 = string4.substring(1);
                } else if (string4.charAt(0) == '\'') {
                    string4 = string4.substring(1);
                }
                if (string4.charAt(string4.length() - 1) == '\"') {
                    string4 = string4.substring(0, string4.length() - 1);
                } else if (string4.charAt(string4.length() - 1) == '\'') {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                vector.addElement(new String[]{string3, string4.trim()});
            } while (n5 != -1 && n2 != -1);
        }
        return vector;
    }

    private int getNextTag(int n, String string) {
        int n2;
        boolean bl = true;
        do {
            int n3;
            char c;
            bl = true;
            n2 = string.indexOf("<", n);
            if (n2 == -1 || (c = string.charAt(n2 + 1)) != '?' && c != '!') continue;
            if (string.indexOf("<![CDATA[", n) != -1) {
                n3 = string.indexOf("]]>", n + 10);
                if (n3 != -1) {
                    n = n3 + 3;
                }
            } else {
                n = n2 + 1;
                n3 = string.indexOf(">", n);
                if (n3 != -1) {
                    n = n3 + 1;
                }
            }
            bl = false;
        } while (n2 != -1 && !bl);
        return n2;
    }

    private String extractTag(int n, String string) {
        int n2 = string.indexOf(">", n);
        String string2 = "";
        if (n2 != -1) {
            char c;
            String string3 = string.substring(n, n2);
            for (int i = 0; i < string3.length() && (c = string3.charAt(i)) != ' ' && c != '/'; ++i) {
                if (c == '<') continue;
                string2 = string2 + c;
            }
        }
        return string2;
    }

    private boolean checkIfWellFormed(String string, int n, int n2, String string2) {
        boolean bl = true;
        int n3 = 0;
        int n4 = 0;
        int n5 = n - 1;
        String string3 = "<" + string;
        int n6 = string3.length();
        do {
            int n7;
            if ((n5 = string2.indexOf(string3, n5)) != -1 && n5 <= n2 && (n7 = string2.charAt(n5 + n6)) != 32 && n7 != 47 && n7 != 62) {
                n5 = -1;
            }
            if (n5 == -1 || n5 > n2) continue;
            n7 = string2.indexOf(">", n5);
            int n8 = string2.indexOf("<", n5 + 1);
            if (n8 == -1) {
                n8 = 999999999;
            }
            if (n7 != -1 && string2.charAt(n7 - 1) == '/' && n8 > n7) {
                ++n3;
                ++n4;
            } else {
                ++n3;
            }
            ++n5;
        } while (n5 <= n2 && n5 != -1);
        n5 = n - 1;
        string3 = "</" + string + ">";
        do {
            if ((n5 = string2.indexOf(string3, n5)) == -1 || n5 > n2) continue;
            ++n4;
            ++n5;
        } while (n5 <= n2 && n5 != -1);
        bl = n4 - n3 == 0;
        return bl;
    }

    private int getEndTag(int n, int n2, String string, String string2) {
        String string3;
        int n3 = n;
        if (n2 == -1) {
            n2 = n;
        }
        int n4 = string2.indexOf(">", n2);
        int n5 = string2.indexOf("<", n2 + 1);
        if (n5 == -1) {
            n5 = 999999999;
        }
        if (n4 != -1 && string2.charAt(n4 - 1) == '/' && n5 > n4) {
            return n4;
        }
        if (n4 != -1 && (n4 = string2.indexOf(string3 = "</" + string + ">", n4)) != -1) {
            boolean bl = this.checkIfWellFormed(string, n3, n4, string2);
            if (bl) {
                return n4;
            }
            return this.getEndTag(n3, n4 + 2, string, string2);
        }
        return -1;
    }

    private String grabData(int n, int n2, String string) {
        int n3 = string.indexOf(">", n);
        if (n3 != -1 && n3 < n2) {
            return string.substring(n3 + 1, n2);
        }
        return null;
    }
}

