/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct.util;

import com.threed.jpct.SimpleVector;
import com.threed.jpct.World;
import java.io.Serializable;

public class Light
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int light = -1;
    private boolean on = false;
    private World world = null;

    public Light(World world) {
        this.world = world;
        this.light = world.addLight(new SimpleVector(), 255.0f, 255.0f, 255.0f);
        this.on = true;
    }

    public void enable() {
        this.on = true;
        this.world.setLightVisibility(this.light, true);
    }

    public void disable() {
        this.on = false;
        this.world.setLightVisibility(this.light, false);
    }

    public boolean isEnabled() {
        return this.on;
    }

    public void setIntensity(SimpleVector simpleVector) {
        this.setIntensity(simpleVector.x, simpleVector.y, simpleVector.z);
    }

    public void setIntensity(float f, float f2, float f3) {
        this.world.setLightIntensity(this.light, f, f2, f3);
    }

    public SimpleVector getIntensity() {
        return this.world.getLightIntensity(this.light);
    }

    public void setAttenuation(float f) {
        this.world.setLightAttenuation(this.light, f);
    }

    public float getAttenuation() {
        return this.world.getLightAttenuation(this.light);
    }

    public void setDiscardDistance(float f) {
        if (f < 0.0f) {
            f = -1.0f;
        }
        this.world.setLightDiscardDistance(this.light, f);
    }

    public float getDiscardDistance() {
        return this.world.getLightDiscardDistance(this.light);
    }

    public void setPosition(SimpleVector simpleVector) {
        this.world.setLightPosition(this.light, simpleVector);
    }

    public SimpleVector getPosition() {
        return this.world.getLightPosition(this.light);
    }

    public void rotate(SimpleVector simpleVector, SimpleVector simpleVector2) {
        SimpleVector simpleVector3 = this.world.getLightPosition(this.light).calcSub(simpleVector2);
        simpleVector3.rotateX(simpleVector.x);
        simpleVector3.rotateY(simpleVector.y);
        simpleVector3.rotateZ(simpleVector.z);
        simpleVector3.add(simpleVector2);
        this.setPosition(simpleVector3);
    }
}

