/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.FrameBuffer;
import com.threed.jpct.Logger;
import com.threed.jpct.VisList;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

class VisListManager
implements Serializable {
    private static final long serialVersionUID = 2L;
    private Hashtable buf2Vis = new Hashtable();
    boolean isDisposed = false;

    VisListManager() {
    }

    void dispose() {
        this.isDisposed = true;
    }

    protected void finalize() {
        this.dispose();
    }

    VisList getVisList(FrameBuffer frameBuffer, VisList visList) {
        if (!Config.shareVisibilityList) {
            Vector<VisList> vector = (Vector<VisList>)this.buf2Vis.get(frameBuffer.getID());
            if (vector == null) {
                frameBuffer.register(this);
                vector = new Vector<VisList>(3);
                vector.addElement(visList);
                this.buf2Vis.put(frameBuffer.getID(), vector);
                visList.lastCycle = frameBuffer.displayCycle;
                return visList;
            }
            VisList visList2 = null;
            for (int i = 0; i < vector.size(); ++i) {
                VisList visList3 = (VisList)vector.elementAt(i);
                if (visList3.lastCycle == frameBuffer.displayCycle) continue;
                visList2 = visList3;
                break;
            }
            if (visList2 == null) {
                visList2 = new VisList(visList.getMaxSize());
                vector.addElement(visList2);
                Logger.log("Additional visibility list (" + vector.size() + ") created with size: " + visList.getMaxSize(), 2);
            }
            visList2.lastCycle = frameBuffer.displayCycle;
            return visList2;
        }
        if (frameBuffer.hasRenderTarget) {
            visList = new VisList(visList.getMaxSize());
        }
        visList.lastCycle = frameBuffer.displayCycle;
        return visList;
    }

    void remove(FrameBuffer frameBuffer) {
        this.buf2Vis.remove(frameBuffer.getID());
        Logger.log("Visibility lists disposed!", 2);
    }
}

