/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.DummyCanvas;
import com.threed.jpct.ITextureEffect;
import com.threed.jpct.IntegerC;
import com.threed.jpct.Logger;
import com.threed.jpct.Projector;
import com.threed.jpct.TextureManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class Texture
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int[] TEXTURE_SIZES = new int[]{8, 16, 32, 64, 128, 256, 512, 1024, 2048};
    private static final float SIZE_OFFSET = 1.0E-14f;
    private static final Component tracky = new DummyCanvas();
    public static final int DEFAULT_BPP = 24;
    public static final int DEFAULT_WIDTH = 256;
    public static final int DEFAULT_HEIGHT = 256;
    int width;
    int height;
    int[] texels;
    int[] alpha;
    int intSize;
    float xend;
    float yend;
    boolean isBumpmap;
    byte shifter;
    boolean isUnicolor = false;
    boolean repeat = true;
    boolean bilinear = true;
    boolean mipmap = true;
    Projector projector = null;
    Projector projectorBuffer = null;
    boolean enabled = true;
    boolean isShadowMap = false;
    float xDiv = 1.0f;
    float yDiv = 1.0f;
    Texture[] mipMaps = null;
    private boolean isLoaded;
    private int[] storeTexels = null;
    private ITextureEffect myEffect = null;
    private long usageCnt = 0L;
    private boolean isConverted = false;
    private int openGLID = 0;
    private int markerGL = 0;
    private int lastRenderer = -1;
    private int lastRendererMarker = -1;
    private Hashtable glIDs = new Hashtable();
    private Hashtable marker = new Hashtable();
    private boolean deletePixels = true;
    static int MARKER_NOTHING = 0;
    static int MARKER_DELETE_AND_UPLOAD = 1;

    Texture() {
        this.width = 256;
        this.height = 256;
        this.isBumpmap = true;
        this.isLoaded = true;
        int n = this.width * this.height + this.width + 1;
        this.texels = new int[n];
        this.xend = (float)this.width - 1.0E-14f;
        this.yend = (float)this.height - 1.0E-14f;
        this.shifter = (byte)8;
        this.isConverted = false;
        this.resetIDs();
        for (int i = 0; i < n; ++i) {
            this.texels[i] = 0xFFFFFF;
        }
    }

    public Texture(String string) {
        this.loadTexture(null, string, null, null);
        this.isBumpmap = false;
        this.isConverted = false;
    }

    public Texture(String string, boolean bl) {
        this.loadTexture(null, string, null, null, bl);
        this.isBumpmap = false;
        this.isConverted = false;
    }

    public Texture(URL uRL, String string) {
        this.loadTexture(uRL, string, null, null);
        this.isBumpmap = false;
        this.isConverted = false;
    }

    public Texture(URL uRL, String string, boolean bl) {
        this.loadTexture(uRL, string, null, null, bl);
        this.isBumpmap = false;
        this.isConverted = false;
    }

    public Texture(InputStream inputStream) {
        this.loadTexture(null, null, inputStream, null);
        this.isBumpmap = false;
        this.isConverted = false;
    }

    public Texture(InputStream inputStream, boolean bl) {
        this.loadTexture(null, null, inputStream, null, bl);
        this.isBumpmap = false;
        this.isConverted = false;
    }

    public Texture(Image image) {
        this.loadTexture(null, "from Image", null, image);
        this.isBumpmap = false;
        this.isConverted = false;
    }

    public Texture(Image image, boolean bl) {
        this.loadTexture(null, "from Image", null, image, bl);
        this.isBumpmap = false;
        this.isConverted = false;
    }

    public Texture(int n, int n2) {
        this(n, n2, Color.black);
    }

    public Texture(int n, int n2, int n3) {
        this(n, n2, Color.black);
        int n4 = this.texels.length;
        this.alpha = new int[n4];
        int n5 = (n3 & 0xFF) << 24;
        for (int i = 0; i < n4; ++i) {
            this.alpha[i] = n5;
        }
    }

    public Texture(int n, int n2, Color color) {
        this(Texture.createIntArray(n, n2, color), Texture.adjustSize(n), Texture.adjustSize(n2), false);
    }

    private static int[] createIntArray(int n, int n2, Color color) {
        if (color == null) {
            return null;
        }
        int n3 = Texture.adjustSize(n);
        int n4 = Texture.adjustSize(n2);
        int[] nArray = new int[n3 * n4];
        int n5 = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        if (n5 != 0) {
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = n5;
            }
        }
        return nArray;
    }

    public void add(Texture texture, float f) {
        if (texture.getArraySize() != this.getArraySize()) {
            Logger.log("Texture sizes don't match", 0);
            return;
        }
        int[] nArray = texture.texels;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = this.texels[i];
            int n3 = n2 >> 24;
            int n4 = (n2 & 0xFF0000) >> 16;
            int n5 = (n2 & 0xFF00) >> 8;
            int n6 = n2 & 0xFF;
            int n7 = n >> 24;
            int n8 = (n & 0xFF0000) >> 16;
            int n9 = (n & 0xFF00) >> 8;
            int n10 = n & 0xFF;
            n3 = this.clip(n3 + (int)((float)n7 * f));
            n4 = this.clip(n4 + (int)((float)n8 * f));
            n5 = this.clip(n5 + (int)((float)n9 * f));
            n6 = this.clip(n6 + (int)((float)n10 * f));
            this.texels[i] = n3 << 24 | n4 << 16 | n5 << 8 | n6;
        }
        this.setMarker(MARKER_DELETE_AND_UPLOAD);
    }

    public void setProjector(Projector projector, boolean bl) {
        this.projector = projector;
        if (this.repeat) {
            this.enableGLClamping();
            this.setMipmap(false);
        }
        if (bl) {
            this.setMarker(MARKER_DELETE_AND_UPLOAD);
        }
    }

    Texture(int[] nArray, int n, int n2, boolean bl) {
        if (bl) {
            if (n <= 2048 && n2 <= 2048) {
                this.width = Texture.adjustSize(n);
                this.height = Texture.adjustSize(n2);
                this.texels = new int[this.width * this.height];
                this.refill(nArray, n, n2);
            } else {
                Logger.log("Unsupported bitmap size for OpenGL blitting!", 0);
            }
        } else {
            this.width = n;
            this.height = n2;
            this.texels = nArray;
        }
        this.isLoaded = true;
        this.xend = (float)this.width - 1.0E-14f;
        this.yend = (float)this.height - 1.0E-14f;
        this.resetIDs();
    }

    public void setAsShadowMap(boolean bl) {
        this.isShadowMap = bl;
        this.setMarker(MARKER_DELETE_AND_UPLOAD);
    }

    public boolean isShadowMap() {
        return this.isShadowMap;
    }

    public void setEffect(ITextureEffect iTextureEffect) {
        if (this.storeTexels == null) {
            this.storeTexels = new int[this.texels.length];
            System.arraycopy(this.texels, 0, this.storeTexels, 0, this.texels.length);
        }
        this.myEffect = iTextureEffect;
        this.myEffect.init(this);
    }

    public void removeEffect() {
        this.myEffect = null;
        this.storeTexels = null;
    }

    public void applyEffect() {
        if (this.myEffect != null) {
            this.myEffect.apply(this.texels, this.storeTexels);
            if (this.myEffect.containsAlpha()) {
                int n = this.texels.length;
                if (this.alpha == null) {
                    this.alpha = new int[n];
                }
                int n2 = 0;
                while (n2 < n) {
                    this.alpha[n2] = this.texels[n2] & 0xFF000000;
                    int n3 = n2++;
                    this.texels[n3] = this.texels[n3] & 0xFFFFFF;
                }
            }
            this.setMarker(MARKER_DELETE_AND_UPLOAD);
        } else {
            Logger.log("The texture doesn't have an effect assigned to it!", 0);
        }
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getByteSize() {
        return this.getArraySize();
    }

    public int getArraySize() {
        if (this.texels == null) {
            return 0;
        }
        return this.texels.length;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getLastFrame() {
        return this.usageCnt;
    }

    public void enableGLClamping() {
        this.repeat = false;
        this.setMarker(MARKER_DELETE_AND_UPLOAD);
    }

    public void setGLFiltering(boolean bl) {
        this.bilinear = bl;
        this.setMarker(MARKER_DELETE_AND_UPLOAD);
    }

    public void setGLMipmap(boolean bl) {
        this.setMipmap(bl);
    }

    public void setMipmap(boolean bl) {
        this.mipmap = bl;
        if (!bl) {
            this.mipMaps = null;
        }
        this.setMarker(MARKER_DELETE_AND_UPLOAD);
    }

    public void removeAlpha() {
        this.alpha = new int[this.texels.length];
        int n = 0;
        while (n < this.alpha.length) {
            this.alpha[n] = -16777216;
            int n2 = n++;
            this.texels[n2] = this.texels[n2] & 0xFFFFFF;
        }
        this.setMarker(MARKER_DELETE_AND_UPLOAD);
    }

    public void setAlpha(int n) {
        this.alpha = new int[this.texels.length];
        int n2 = 0;
        while (n2 < this.alpha.length) {
            this.alpha[n2] = n;
            int n3 = n2++;
            this.texels[n3] = this.texels[n3] & 0xFFFFFF;
        }
        this.setMarker(MARKER_DELETE_AND_UPLOAD);
    }

    public void keepPixelData(boolean bl) {
        this.deletePixels = !bl;
    }

    final int getOpenGLID(int n) {
        if (this.isConverted) {
            if (n == this.lastRenderer) {
                return this.openGLID;
            }
            Integer n2 = (Integer)this.glIDs.get(IntegerC.valueOf(n));
            if (n2 != null) {
                this.openGLID = n2;
                this.lastRenderer = n;
                return this.openGLID;
            }
        }
        return 0;
    }

    final void clearIDs(int n) {
        this.openGLID = 0;
        this.markerGL = -999;
        this.lastRenderer = -1;
        this.lastRendererMarker = -1;
        this.glIDs.remove(IntegerC.valueOf(n));
        this.marker.remove(IntegerC.valueOf(n));
    }

    final void setOpenGLID(int n, int n2) {
        this.openGLID = n2;
        if (n2 != 0) {
            this.lastRenderer = n;
            this.glIDs.put(IntegerC.valueOf(n), IntegerC.valueOf(n2));
            this.isConverted = true;
            if (Config.glAvoidTextureCopies && this.myEffect == null && this.deletePixels) {
                this.texels = null;
                this.alpha = null;
            }
        } else {
            this.resetIDs();
        }
    }

    final int getMarker(int n) {
        if (this.markerGL == -999 || this.lastRendererMarker != n) {
            this.lastRendererMarker = n;
            this.markerGL = this.marker.containsKey(IntegerC.valueOf(n)) ? MARKER_NOTHING : MARKER_DELETE_AND_UPLOAD;
        }
        return this.markerGL;
    }

    private final void setMarker(int n) {
        this.setMarker(-1, n);
    }

    final void setMarker(int n, int n2) {
        if (n2 == MARKER_NOTHING) {
            this.marker.put(IntegerC.valueOf(n), Config.booleanValueOf(true));
            this.markerGL = MARKER_NOTHING;
            this.lastRendererMarker = n;
        } else if (n2 == MARKER_DELETE_AND_UPLOAD) {
            this.marker.clear();
            this.mipMaps = null;
            this.markerGL = -999;
            this.lastRendererMarker = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Texture getMipMappedTexture(int n) {
        if (n <= 0 || !this.mipmap || !Config.mipmap) {
            return this;
        }
        if (this.mipMaps == null) {
            Texture texture = this;
            synchronized (texture) {
                if (this.mipMaps == null) {
                    long l = System.currentTimeMillis();
                    int n2 = this.width;
                    int n3 = this.height;
                    int n4 = n2;
                    if (n3 > n2) {
                        n4 = n3;
                    }
                    if (n4 <= 16) {
                        return this;
                    }
                    DirectColorModel directColorModel = null;
                    directColorModel = this.alpha == null ? new DirectColorModel(24, 0xFF0000, 65280, 255) : new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
                    int[] nArray = new int[n2 * n3];
                    for (int i = 0; i < nArray.length; ++i) {
                        int n5 = this.texels[i] & 0xFFFFFF;
                        if (this.alpha != null) {
                            n5 |= this.alpha[i] << 24;
                        }
                        nArray[i] = n5;
                    }
                    MemoryImageSource memoryImageSource = new MemoryImageSource(n2, n3, (ColorModel)directColorModel, nArray, 0, n2);
                    Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
                    int n6 = n2;
                    int n7 = n3;
                    Vector<Texture> vector = new Vector<Texture>();
                    int n8 = 0;
                    while (n2 > 8 || n3 > 8) {
                        n3 /= 2;
                        if ((n2 /= 2) < 8) {
                            n2 = 8;
                        }
                        if (n3 < 8) {
                            n3 = 8;
                        }
                        Image image2 = image.getScaledInstance(n2, n3, 4);
                        Texture texture2 = new Texture(image2, this.alpha != null);
                        texture2.xDiv = (float)n6 / (float)n2;
                        texture2.yDiv = (float)n7 / (float)n3;
                        vector.addElement(texture2);
                        ++n8;
                    }
                    this.mipMaps = new Texture[vector.size()];
                    for (n8 = 0; n8 < this.mipMaps.length; ++n8) {
                        this.mipMaps[n8] = (Texture)vector.elementAt(n8);
                    }
                    Logger.log("Mipmaps created in " + (System.currentTimeMillis() - l) + "ms", 2);
                }
            }
        }
        n = Math.min(this.mipMaps.length, n) - 1;
        return this.mipMaps[n];
    }

    final void updateUsage(long l) {
        this.usageCnt = l;
    }

    final void createBumpmap() {
        if (this != TextureManager.getInstance().getDummyTexture()) {
            if (this.isLoaded) {
                int n = this.intSize + this.width + 1;
                for (int i = 0; i < n; ++i) {
                    this.texels[i] = this.texels[i] & 0xFFFF;
                }
            } else {
                Logger.log("Tried to process a nonexistent texture!", 0);
            }
            this.isBumpmap = true;
        }
    }

    final void refill(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = i * this.width;
            int n4 = n * i;
            for (int j = 0; j < n; ++j) {
                this.texels[n3 + j] = nArray[n4 + j];
            }
        }
        this.isConverted = false;
    }

    private void loadTexture(URL uRL, String string, InputStream inputStream, Image image) {
        this.loadTexture(uRL, string, inputStream, image, false);
    }

    private void loadTexture(URL uRL, String string, InputStream inputStream, Image image, boolean bl) {
        block36: {
            int n;
            block35: {
                this.isLoaded = false;
                if (string == null) {
                    string = "from InputStream";
                }
                Logger.log("Loading Texture..." + string, 2);
                try {
                    int n2;
                    Image image2 = null;
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    if (image == null) {
                        if (inputStream == null) {
                            image2 = uRL != null ? toolkit.getImage(new URL(uRL, string)) : toolkit.getImage(string);
                        } else {
                            int n3 = 100000;
                            int n4 = 0;
                            n2 = 0;
                            int n5 = n3;
                            byte[] byArray = new byte[n3];
                            try {
                                while (n4 != -1) {
                                    n4 = inputStream.read(byArray, n2, n5 - n2);
                                    if (n4 == -1 || (n2 += n4) < n5) continue;
                                    byte[] byArray2 = new byte[n5 += 100000];
                                    System.arraycopy(byArray, 0, byArray2, 0, n5 - 100000);
                                    byArray = byArray2;
                                    Logger.log("Expanding buffers..." + n5 + " bytes", 2);
                                }
                                inputStream.close();
                                image2 = toolkit.createImage(byArray, 0, ++n2);
                            }
                            catch (Exception exception) {
                                Logger.log("Couldn't get data from InputStream: " + exception.toString(), 0);
                            }
                        }
                    } else {
                        image2 = image;
                    }
                    Thread.yield();
                    MediaTracker mediaTracker = new MediaTracker(tracky);
                    mediaTracker.addImage(image2, 0);
                    try {
                        mediaTracker.waitForAll();
                    }
                    catch (Exception exception) {
                        Logger.log("Error loading texture: " + exception, 0);
                    }
                    if (image2 != null && image2.getWidth(null) > 0) {
                        int n6 = image2.getHeight(null);
                        this.width = n2 = image2.getWidth(null);
                        this.height = n6;
                        switch (this.width) {
                            case 8192: {
                                this.shifter = (byte)13;
                                break;
                            }
                            case 4096: {
                                this.shifter = (byte)12;
                                break;
                            }
                            case 2048: {
                                this.shifter = (byte)11;
                                break;
                            }
                            case 1024: {
                                this.shifter = (byte)10;
                                break;
                            }
                            case 512: {
                                this.shifter = (byte)9;
                                break;
                            }
                            case 256: {
                                this.shifter = (byte)8;
                                break;
                            }
                            case 128: {
                                this.shifter = (byte)7;
                                break;
                            }
                            case 64: {
                                this.shifter = (byte)6;
                                break;
                            }
                            case 32: {
                                this.shifter = (byte)5;
                                break;
                            }
                            case 16: {
                                this.shifter = (byte)4;
                                break;
                            }
                            case 8: {
                                this.shifter = (byte)3;
                                break;
                            }
                            default: {
                                Logger.log("Unsupported Texture width (" + this.width + ")...resizing to a width of " + 256 + " pixels!", 1);
                                if (n6 != 8 && n6 != 16 && n6 != 32 && n6 != 64 && n6 != 128 && n6 != 256 && n6 != 512 && n6 != 1024 && n6 != 2048 && n6 != 4096 && n6 != 8192) {
                                    this.height = n6 = 256;
                                }
                                image2 = image2.getScaledInstance(256, n6, 4);
                                n2 = 256;
                                this.width = 256;
                                this.shifter = (byte)(Math.log(256.0) / Math.log(2.0));
                            }
                        }
                        if (n6 != 8 && n6 != 16 && n6 != 32 && n6 != 64 && n6 != 128 && n6 != 256 && n6 != 512 && n6 != 1024 && n6 != 2048 && n6 != 4096 && n6 != 8192) {
                            Logger.log("Unsupported Texture height (" + this.height + ")...resizing to a height of " + 256 + " pixels!", 1);
                            image2 = image2.getScaledInstance(n2, 256, 4);
                            this.height = n6 = 256;
                        }
                        this.xend = (float)n2 - 1.0E-14f;
                        this.yend = (float)n6 - 1.0E-14f;
                        this.intSize = this.width * this.height;
                        this.texels = new int[this.intSize + this.width + 1];
                        PixelGrabber pixelGrabber = new PixelGrabber(image2, 0, 0, n2, n6, this.texels, 0, n2);
                        try {
                            pixelGrabber.grabPixels();
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.log("Could not grab pixels from image!", 0);
                        }
                        this.isLoaded = true;
                        break block35;
                    }
                    Logger.log("File '" + (string != null ? string : "unknown") + "' not found - replacement texture used instead!", 0);
                    this.texels = new int[8];
                    this.isLoaded = true;
                    this.intSize = 4;
                    this.width = 2;
                    this.height = 2;
                    this.xend = 2.0f;
                    this.yend = 2.0f;
                    this.shifter = 1;
                }
                catch (MalformedURLException malformedURLException) {
                    Logger.log("File " + string + " not found!", 0);
                }
            }
            if (!this.isLoaded) break block36;
            int n7 = this.intSize + this.width + 1;
            for (n = this.intSize; n < n7; ++n) {
                this.texels[n] = this.texels[n - this.intSize];
            }
            if (!bl) {
                n = 0;
                while (n < n7) {
                    int n8 = n++;
                    this.texels[n8] = this.texels[n8] & 0xFFFFFF;
                }
            } else {
                this.alpha = new int[this.texels.length];
                n = 0;
                while (n < n7) {
                    this.alpha[n] = this.texels[n] & 0xFF000000;
                    int n9 = n++;
                    this.texels[n9] = this.texels[n9] & 0xFFFFFF;
                }
            }
        }
    }

    private static int adjustSize(int n) {
        for (int i = 0; i < TEXTURE_SIZES.length; ++i) {
            if (n > TEXTURE_SIZES[i]) continue;
            return TEXTURE_SIZES[i];
        }
        return n;
    }

    private void resetIDs() {
        this.openGLID = 0;
        this.markerGL = -999;
        this.lastRenderer = -1;
        this.lastRendererMarker = -1;
        this.glIDs.clear();
        this.marker.clear();
    }

    static Texture createSingleColoredTexture(Color color) {
        int[] nArray = new int[256];
        int n = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
        for (int i = 0; i < 256; ++i) {
            nArray[i] = n;
        }
        Texture texture = new Texture(nArray, 16, 16, false);
        texture.isUnicolor = true;
        return texture;
    }

    private int clip(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        return n;
    }
}

