/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.Logger;
import com.threed.jpct.Object3D;
import com.threed.jpct.SimpleVector;
import com.threed.jpct.Vectors;
import java.io.Serializable;

public final class Portals
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PORTAL_NOTDEFINITE = 99999999;
    public static final int SECTOR_UNDEFINED = 0;
    int anzPortals = 0;
    int anzSectors;
    int viewSector;
    int[] visSectors;
    int anzVisSectors = 0;
    Object3D portalsObj = new Object3D(Config.maxPortalCoords * Config.maxPortals);
    float[] lowx;
    float[] lowy;
    float[] highx;
    float[] highy;
    float[][] bounding;
    int[] fromSector;
    int[] toSector;
    int[][] coords = new int[Config.maxPortals][Config.maxPortalCoords];
    int[] coordCount = new int[Config.maxPortals];
    private float[] boundingCenterX;
    private float[] boundingCenterY;
    private float[] boundingCenterZ;
    private float[] boundingWidthX;
    private float[] boundingWidthY;
    private float[] boundingWidthZ;
    private int maxPortals;
    private int used = 0;
    private int[] curSectors;
    private int[] onlyPortal;
    private boolean[] isVisible;
    private int[] portalsUsed;
    private transient float x1;
    private transient float x2;
    private transient float x3;
    private transient float x4;
    private transient float x5;
    private transient float x6;
    private transient float x7;
    private transient float y1;
    private transient float y2;
    private transient float y3;
    private transient float y4;
    private transient float y5;
    private transient float y6;
    private transient float y7;
    private transient float z1;
    private transient float z2;
    private transient float z3;
    private transient float z4;
    private transient float z5;
    private transient float z6;
    private transient float z7;
    private transient float x8;
    private transient float y8;
    private transient float z8;

    Portals() {
        this.fromSector = new int[Config.maxPortals];
        this.toSector = new int[Config.maxPortals];
        this.portalsUsed = new int[Config.maxPortals >> 1];
        this.isVisible = new boolean[Config.maxPortals >> 1];
        this.visSectors = new int[Config.maxPortals >> 1];
        this.onlyPortal = new int[Config.maxPortals >> 1];
        this.lowx = new float[Config.maxPortals];
        this.lowy = new float[Config.maxPortals];
        this.highx = new float[Config.maxPortals];
        this.highy = new float[Config.maxPortals];
        this.curSectors = new int[Config.maxPortals];
        this.maxPortals = Config.maxPortals;
        this.bounding = new float[Config.maxPortals][6];
        this.boundingCenterX = new float[Config.maxPortals];
        this.boundingCenterY = new float[Config.maxPortals];
        this.boundingCenterZ = new float[Config.maxPortals];
        this.boundingWidthX = new float[Config.maxPortals];
        this.boundingWidthY = new float[Config.maxPortals];
        this.boundingWidthZ = new float[Config.maxPortals];
        for (int i = 0; i < this.anzPortals; ++i) {
            this.coordCount[i] = 0;
        }
    }

    public void startNewPortal() {
        if (this.anzPortals == this.maxPortals) {
            Logger.log("Maximum number of Portals reached: " + this.anzPortals, 1);
        }
    }

    public void addPortalCoord(SimpleVector simpleVector) {
        this.addPortalCoord(simpleVector.x, simpleVector.y, simpleVector.z);
    }

    public void addPortalCoord(float f, float f2, float f3) {
        int n = this.portalsObj.objVectors.checkCoords(f, f2, f3, -1);
        if (n == -1) {
            n = this.portalsObj.objMesh.anzCoords++;
            this.portalsObj.objMesh.xOrg[n] = f;
            this.portalsObj.objVectors.vertexSector[n] = -1;
            this.portalsObj.objMesh.yOrg[n] = f2;
            this.portalsObj.objMesh.zOrg[n] = f3;
        }
        this.addCoord(n);
    }

    public void setPortalAttributes(int n, int n2) {
        this.fromSector[this.anzPortals] = n;
        this.toSector[this.anzPortals] = n2;
    }

    public void completePortal() {
        if (this.anzPortals < this.maxPortals) {
            ++this.anzPortals;
        } else {
            Logger.log("Warning: Maximum number of Portals reached: " + this.anzPortals, 1);
        }
    }

    public void setAABoundingBox(int n, float f, float f2, float f3, float f4, float f5, float f6) {
        this.bounding[n][0] = f;
        this.bounding[n][1] = f4;
        this.bounding[n][2] = f2;
        this.bounding[n][3] = f5;
        this.bounding[n][4] = f3;
        this.bounding[n][5] = f6;
        this.boundingCenterX[n] = f + (f4 - f) / 2.0f;
        this.boundingCenterY[n] = f2 + (f5 - f3) / 2.0f;
        this.boundingCenterZ[n] = f3 + (f6 - f3) / 2.0f;
        this.boundingWidthX[n] = Math.abs(f4 - f);
        this.boundingWidthY[n] = Math.abs(f5 - f2);
        this.boundingWidthZ[n] = Math.abs(f6 - f3);
    }

    int[] detectAllCoveredSectors(int[] nArray, float[] fArray, float[] fArray2, float[] fArray3) {
        int n = 0;
        this.x1 = fArray[0];
        this.y1 = fArray2[0];
        this.z1 = fArray3[0];
        this.x2 = fArray[1];
        this.y2 = fArray2[1];
        this.z2 = fArray3[1];
        this.x3 = fArray[2];
        this.y3 = fArray2[2];
        this.z3 = fArray3[2];
        this.x4 = fArray[3];
        this.y4 = fArray2[3];
        this.z4 = fArray3[3];
        this.x5 = fArray[4];
        this.y5 = fArray2[4];
        this.z5 = fArray3[4];
        this.x6 = fArray[5];
        this.y6 = fArray2[5];
        this.z6 = fArray3[5];
        this.x7 = fArray[6];
        this.y7 = fArray2[6];
        this.z7 = fArray3[6];
        this.x8 = fArray[7];
        this.y8 = fArray2[7];
        this.z8 = fArray3[7];
        for (int i = 0; i < this.anzVisSectors; ++i) {
            int n2 = this.visSectors[i];
            float f = this.bounding[n2][0];
            boolean bl = false;
            if (this.x1 < f && this.x2 < f && this.x3 < f && this.x4 < f && this.x5 < f && this.x6 < f && this.x7 < f && this.x8 < f) {
                bl = true;
            } else {
                f = this.bounding[n2][1];
                if (this.x1 > f && this.x2 > f && this.x3 > f && this.x4 > f && this.x5 > f && this.x6 > f && this.x7 > f && this.x8 > f) {
                    bl = true;
                } else {
                    f = this.bounding[n2][2];
                    if (this.y1 < f && this.y2 < f && this.y3 < f && this.y4 < f && this.y5 < f && this.y6 < f && this.y7 < f && this.y8 < f) {
                        bl = true;
                    } else {
                        f = this.bounding[n2][3];
                        if (this.y1 > f && this.y2 > f && this.y3 > f && this.y4 > f && this.y5 > f && this.y6 > f && this.y7 > f && this.y8 > f) {
                            bl = true;
                        } else {
                            f = this.bounding[n2][4];
                            if (this.z1 < f && this.z2 < f && this.z3 < f && this.z4 < f && this.z5 < f && this.z6 < f && this.z7 < f && this.z8 < f) {
                                bl = true;
                            } else {
                                f = this.bounding[n2][5];
                                if (this.z1 > f && this.z2 > f && this.z3 > f && this.z4 > f && this.z5 > f && this.z6 > f && this.z7 > f && this.z8 > f) {
                                    bl = true;
                                }
                            }
                        }
                    }
                }
            }
            if (bl) continue;
            nArray[++n] = n2;
        }
        nArray[0] = n;
        return nArray;
    }

    void calcAABoundingBox(Object3D object3D) {
        this.anzSectors = 0;
        int n = 0;
        int n2 = object3D.objMesh.anzCoords;
        for (int i = 1; i < this.maxPortals; ++i) {
            float f = 1.0E11f;
            float f2 = -1.0E11f;
            float f3 = 1.0E11f;
            float f4 = -1.0E11f;
            float f5 = 1.0E11f;
            float f6 = -1.0E11f;
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                if (object3D.objVectors.vertexSector[j] != i) continue;
                n = i;
                bl = true;
                float f7 = object3D.objMesh.xOrg[j];
                float f8 = object3D.objMesh.yOrg[j];
                float f9 = object3D.objMesh.zOrg[j];
                if (f7 < f) {
                    f = f7;
                }
                if (f7 > f2) {
                    f2 = f7;
                }
                if (f8 < f3) {
                    f3 = f8;
                }
                if (f8 > f4) {
                    f4 = f8;
                }
                if (f9 < f5) {
                    f5 = f9;
                }
                if (!(f9 > f6)) continue;
                f6 = f9;
            }
            if (!bl) continue;
            this.setAABoundingBox(i, f, f3, f5, f2, f4, f6);
        }
        this.anzSectors = n;
    }

    boolean testObbAgainstPortals(Object3D object3D, float f, float f2, float f3, float f4) {
        Vectors vectors = object3D.objVectors;
        float f5 = f + f * 2.0f * Config.viewportOffsetX;
        float f6 = f2 + f2 * 2.0f * Config.viewportOffsetY;
        boolean bl = false;
        int n = object3D.objMesh.obbEnd + 1 - object3D.objMesh.obbStart;
        if (Config.useBB && object3D.hasBoundingBox && Config.useFrustumCulling) {
            int n2 = object3D.clipAtPortal;
            boolean bl2 = object3D.oneSectorOnly;
            int n3 = 0;
            int n4 = this.used;
            if (n2 != -1 && bl2) {
                n3 = n2;
                n4 = n2 + 1;
            }
            for (int i = n3; i < n4; ++i) {
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                boolean bl3 = true;
                for (int j = object3D.objMesh.obbStart; j <= object3D.objMesh.obbEnd; ++j) {
                    float f7;
                    float f8;
                    float f9;
                    int n10;
                    float f10 = 1.0f / vectors.zTr[j];
                    float f11 = f3 * (vectors.xTr[j] * f10) + f5;
                    float f12 = f4 * (vectors.yTr[j] * f10) + f6;
                    if (!object3D.dynSectorDetect) {
                        n9 = !object3D.oneSectorOnly && object3D.sector != null ? object3D.sector[j] : object3D.singleSectorNumber;
                    } else if (object3D.sectorCnt == 1) {
                        n9 = object3D.dynSectorList[1];
                    } else {
                        bl3 = false;
                    }
                    if (bl3) {
                        n10 = this.portalsUsed[i];
                        if (this.toSector[n10] != n9 || !this.isVisible[i]) continue;
                        float f13 = this.lowx[n10];
                        f9 = this.highx[n10];
                        f8 = this.lowy[n10];
                        f7 = this.highy[n10];
                        if (f11 < f13) {
                            ++n6;
                        }
                        if (f11 > f9) {
                            ++n5;
                        }
                        if (f12 < f8) {
                            ++n7;
                        }
                        if (!(f12 > f7)) continue;
                        ++n8;
                        continue;
                    }
                    n5 = 0;
                    n6 = 0;
                    n7 = 0;
                    n8 = 0;
                    for (n10 = 1; n10 <= object3D.sectorCnt; ++n10) {
                        int n11 = this.portalsUsed[i];
                        n9 = object3D.dynSectorList[n10];
                        if (this.toSector[n11] != n9 || !this.isVisible[i]) continue;
                        f9 = this.lowx[n11];
                        f8 = this.highx[n11];
                        f7 = this.lowy[n11];
                        float f14 = this.highy[n11];
                        if (f11 < f9) {
                            ++n6;
                        }
                        if (f11 > f8) {
                            ++n5;
                        }
                        if (f12 < f7) {
                            ++n7;
                        }
                        if (!(f12 > f14)) continue;
                        ++n8;
                    }
                }
                if (!bl3) {
                    n *= object3D.sectorCnt;
                }
                if (n6 == n || n5 == n || n7 == n || n8 == n) continue;
                i = n4;
                bl = true;
                break;
            }
        }
        return bl;
    }

    int testAgainstPortals(Object3D object3D, int n, int n2, int n3, int n4) {
        Vectors vectors = object3D.objVectors;
        float f = vectors.sx[n];
        float f2 = vectors.sy[n];
        float f3 = vectors.sx[n2];
        float f4 = vectors.sy[n2];
        float f5 = vectors.sx[n3];
        float f6 = vectors.sy[n3];
        int n5 = 0;
        boolean bl = object3D.oneSectorOnly;
        int n6 = object3D.clipAtPortal;
        if (!object3D.dynSectorDetect) {
            n5 = !object3D.oneSectorOnly && object3D.sector != null ? object3D.sector[n4] : object3D.singleSectorNumber;
        } else {
            if (object3D.sectorCnt == 1) {
                n5 = object3D.dynSectorList[1];
                bl = true;
            } else {
                bl = false;
            }
            n6 = -1;
        }
        int n7 = -1;
        int n8 = 0;
        int n9 = this.used;
        if (n6 != -1 && bl) {
            n8 = n6;
            n9 = n6 + 1;
        }
        if (!object3D.dynSectorDetect || object3D.sectorCnt == 1) {
            for (int i = n8; i < n9; ++i) {
                int n10 = this.portalsUsed[i];
                if (this.toSector[n10] != n5 || !this.isVisible[i]) continue;
                float f7 = this.lowx[n10];
                float f8 = this.highx[n10];
                float f9 = this.lowy[n10];
                float f10 = this.highy[n10];
                boolean bl2 = true;
                if (f < f7 && f3 < f7 && f5 < f7) {
                    bl2 = false;
                }
                if (f > f8 && f3 > f8 && f5 > f8) {
                    bl2 = false;
                }
                if (f2 < f9 && f4 < f9 && f6 < f9) {
                    bl2 = false;
                }
                if (f2 > f10 && f4 > f10 && f6 > f10) {
                    bl2 = false;
                }
                if (!bl2) continue;
                n7 = n10;
                i = this.used;
                break;
            }
        } else {
            block1: for (int i = n8; i < n9; ++i) {
                int n11 = this.portalsUsed[i];
                for (int j = 1; j <= object3D.sectorCnt; ++j) {
                    n5 = object3D.dynSectorList[j];
                    if (this.toSector[n11] != n5 || !this.isVisible[i]) continue;
                    float f11 = this.lowx[n11];
                    float f12 = this.highx[n11];
                    float f13 = this.lowy[n11];
                    float f14 = this.highy[n11];
                    boolean bl3 = true;
                    if (f < f11 && f3 < f11 && f5 < f11) {
                        bl3 = false;
                    }
                    if (f > f12 && f3 > f12 && f5 > f12) {
                        bl3 = false;
                    }
                    if (f2 < f13 && f4 < f13 && f6 < f13) {
                        bl3 = false;
                    }
                    if (f2 > f14 && f4 > f14 && f6 > f14) {
                        bl3 = false;
                    }
                    if (!bl3) continue;
                    n7 = 99999999;
                    i = this.used;
                    j = object3D.sectorCnt + 1;
                    continue block1;
                }
            }
        }
        return n7;
    }

    boolean isSectorVisible(Object3D object3D, int n) {
        boolean bl = false;
        object3D.clipAtPortal = -1;
        if (n != 0) {
            for (int i = 0; i < this.anzVisSectors; ++i) {
                if (this.visSectors[i] != n) continue;
                bl = true;
                object3D.clipAtPortal = this.onlyPortal[i];
                i = this.anzVisSectors;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    int getCurrentSector(Object3D object3D, float f, float f2, float f3) {
        int n;
        if (!object3D.isMainWorld) {
            Logger.log("Passed an Object3D to getCurrentSector that isn't defined as main!", 0);
        }
        float f4 = 1.0E12f;
        this.viewSector = 0;
        int n2 = 0;
        for (n = 1; n <= this.anzSectors; ++n) {
            if (!(f >= this.bounding[n][0] - 10.0f) || !(f <= this.bounding[n][1] + 10.0f) || !(f2 >= this.bounding[n][2] - 10.0f) || !(f2 <= this.bounding[n][3] + 10.0f) || !(f3 >= this.bounding[n][4] - 10.0f) || !(f3 <= this.bounding[n][5] + 10.0f)) continue;
            this.viewSector = n;
            this.curSectors[n2] = n;
            ++n2;
        }
        if (n2 != 1) {
            this.viewSector = 0;
            for (n = 0; n < n2; ++n) {
                int n3 = object3D.sectorStartPoint[this.curSectors[n]];
                int n4 = object3D.sectorEndPoint[this.curSectors[n]] + 1;
                for (int i = n3; i < n4; ++i) {
                    float f5;
                    float f6 = -object3D.objMesh.xOrg[i] + f;
                    float f7 = -object3D.objMesh.yOrg[i] + f2;
                    float f8 = -object3D.objMesh.zOrg[i] + f3;
                    if (!(f6 < Config.sectorRange) || !(f6 > -Config.sectorRange) || !(f7 < Config.sectorRange) || !(f7 > -Config.sectorRange) || !(f8 < Config.sectorRange) || !(f8 > -Config.sectorRange) || !((f5 = f6 * f6 + f7 * f7 + f8 * f8) <= f4)) continue;
                    f4 = f5;
                    this.viewSector = object3D.objVectors.vertexSector[i];
                }
            }
        }
        return this.viewSector;
    }

    void processPortals(float f, float f2, float f3, float f4) {
        this.used = 0;
        int n = ((int)f << 1) - 1;
        int n2 = ((int)f2 << 1) - 1;
        float f5 = f + f * 2.0f * Config.viewportOffsetX;
        float f6 = f2 + f2 * 2.0f * Config.viewportOffsetY;
        Object3D object3D = this.portalsObj;
        for (int i = 0; i < this.anzPortals; ++i) {
            int n3 = this.coords[i][0];
            int n4 = this.coords[i][2];
            float f7 = object3D.objVectors.yTr[n4];
            float f8 = object3D.objVectors.yTr[n3] - f7;
            int n5 = this.coords[i][1];
            float f9 = object3D.objVectors.zTr[n4];
            float f10 = object3D.objVectors.zTr[n5] - f9;
            float f11 = object3D.objVectors.zTr[n3] - f9;
            float f12 = object3D.objVectors.yTr[n5] - f7;
            float f13 = f8 * f10 - f11 * f12;
            float f14 = object3D.objVectors.xTr[n4];
            float f15 = object3D.objVectors.xTr[n5] - f14;
            float f16 = object3D.objVectors.xTr[n3] - f14;
            float f17 = f11 * f15 - f16 * f10;
            float f18 = f16 * f12 - f8 * f15;
            float f19 = f13 * f14 + f17 * f7 + f18 * f9;
            if (!(f19 <= 0.0f)) continue;
            boolean bl = true;
            int n6 = this.coordCount[i];
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            float f20 = 1.0E9f;
            float f21 = -1.0f;
            float f22 = 1.0E9f;
            float f23 = -1.0f;
            float f24 = 0.0f;
            float f25 = 0.0f;
            boolean bl2 = false;
            int n11 = 0;
            int n12 = 0;
            for (int j = 0; j < n6; ++j) {
                int n13 = this.coords[i][j];
                float f26 = object3D.objVectors.zTr[n13];
                if (f26 <= 0.0f) {
                    bl2 = true;
                    ++n12;
                    if (f26 <= -20.0f) {
                        ++n11;
                    }
                }
                if (object3D.objVectors.sz[n13] == -1.01f) {
                    if (f26 <= 0.0f) {
                        f26 = 1.0E-4f;
                    }
                    float f27 = 1.0f / f26;
                    f24 = f3 * (object3D.objVectors.xTr[n13] * f27) + f5;
                    f25 = f4 * (object3D.objVectors.yTr[n13] * f27) + f6;
                    object3D.objVectors.sx[n13] = f24;
                    object3D.objVectors.sy[n13] = f25;
                } else {
                    f24 = object3D.objVectors.sx[n13];
                    f25 = object3D.objVectors.sy[n13];
                }
                if (f24 < 0.0f) {
                    if (!bl2) {
                        ++n7;
                    }
                    f24 = 0.0f;
                } else if (f24 > (float)n) {
                    if (!bl2) {
                        ++n9;
                    }
                    f24 = n;
                }
                if (f25 < 0.0f) {
                    if (!bl2) {
                        ++n8;
                    }
                    f25 = 0.0f;
                } else if (f25 > (float)n2) {
                    if (!bl2) {
                        ++n10;
                    }
                    f25 = n2;
                }
                if (f24 < f20) {
                    f20 = f24;
                }
                if (f24 > f21) {
                    f21 = f24;
                }
                if (f25 < f22) {
                    f22 = f25;
                }
                if (!(f25 > f23)) continue;
                f23 = f25;
            }
            if (bl && n12 < n6 && this.toSector[i] == this.viewSector) {
                this.viewSector = this.fromSector[i];
            }
            boolean bl3 = bl = bl && n7 != n6 && n8 != n6 && n9 != n6 && n10 != n6 && n11 < n6;
            if (!bl) continue;
            this.portalsUsed[this.used] = i;
            this.isVisible[this.used] = false;
            if (bl2) {
                if (!(f21 <= 0.0f || f20 >= (float)n || f23 <= 0.0f || f22 >= (float)n2 || n12 == n6)) {
                    this.lowx[i] = 0.0f;
                    this.lowy[i] = 0.0f;
                    this.highx[i] = n;
                    this.highy[i] = n2;
                    ++this.used;
                }
            } else {
                this.lowx[i] = f20;
                this.lowy[i] = f22;
                this.highx[i] = f21;
                this.highy[i] = f23;
                ++this.used;
            }
            if (this.toSector[i] != this.viewSector) continue;
            this.viewSector = this.fromSector[i];
        }
        this.cullPortal(this.viewSector, -10000.0f, -10000.0f, 10000.0f, 10000.0f, true);
        this.detectVisibleSectors(this.viewSector);
    }

    private void detectVisibleSectors(int n) {
        this.anzVisSectors = 1;
        this.visSectors[0] = n;
        this.onlyPortal[0] = -1;
        for (int i = 0; i < this.used; ++i) {
            int n2 = this.portalsUsed[i];
            if (!this.isVisible[i]) continue;
            int n3 = this.toSector[n2];
            boolean bl = false;
            for (int j = 0; j < this.anzVisSectors; ++j) {
                if (this.visSectors[j] != n3) continue;
                this.onlyPortal[j] = -1;
                j = this.anzVisSectors;
                bl = true;
                break;
            }
            if (bl) continue;
            this.visSectors[this.anzVisSectors] = n3;
            this.onlyPortal[this.anzVisSectors] = i;
            ++this.anzVisSectors;
        }
    }

    private void addCoord(int n) {
        if (this.coordCount[this.anzPortals] < Config.maxPortalCoords) {
            this.coords[this.anzPortals][this.coordCount[this.anzPortals]] = n;
            int n2 = this.anzPortals;
            this.coordCount[n2] = this.coordCount[n2] + 1;
        } else {
            Logger.log("Portal " + this.anzPortals + " too complex!", 0);
        }
    }

    private void cullPortal(int n, float f, float f2, float f3, float f4, boolean bl) {
        for (int i = 0; i < this.used; ++i) {
            int n2 = this.portalsUsed[i];
            if (this.fromSector[n2] != n || this.isVisible[i]) continue;
            float f5 = this.lowx[n2];
            float f6 = this.highx[n2];
            float f7 = this.lowy[n2];
            float f8 = this.highy[n2];
            if (bl) {
                this.isVisible[i] = true;
                this.cullPortal(this.toSector[n2], f5, f7, f6, f8, false);
                continue;
            }
            boolean bl2 = true;
            if (f < f5 && f3 < f5) {
                bl2 = false;
            }
            if (f > f6 && f3 > f6) {
                bl2 = false;
            }
            if (f2 < f7 && f4 < f7) {
                bl2 = false;
            }
            if (f2 > f8 && f4 > f8) {
                bl2 = false;
            }
            if (!bl2) continue;
            this.isVisible[i] = true;
            this.cullPortal(this.toSector[n2], f5, f7, f6, f8, false);
        }
    }
}

