/*
 * Decompiled with CFR 0.152.
 */
package com.threed.jpct;

import com.threed.jpct.Config;
import com.threed.jpct.ISomeImageBuffer;
import com.threed.jpct.Logger;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;

final class MemoryImageBuffer
implements ISomeImageBuffer,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient MemoryImageSource source;
    private int[] pixels;
    private Image output;

    MemoryImageBuffer() {
    }

    public void create(int n, int n2) {
        DirectColorModel directColorModel = null;
        if (!Config.useFramebufferWithAlpha) {
            directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        } else {
            directColorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            Logger.log("Framebuffer supports an alpha channel!", 2);
        }
        this.pixels = new int[n * n2];
        this.source = new MemoryImageSource(n, n2, (ColorModel)directColorModel, this.pixels, 0, n);
        this.source.setAnimated(true);
        this.output = Toolkit.getDefaultToolkit().createImage(this.source);
    }

    public Image getImage() {
        return this.output;
    }

    public MemoryImageSource getSource() {
        return this.source;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public int getType() {
        return 0;
    }
}

