float4x4 matWorldViewProjection;

texture tex0; //texture
texture tex1; //alpha

float2 ps = {1.f/800.f, 1.f/600.f};
float blur = 4.2f;

sampler2D diffuse = 
sampler_state
{
	texture = (tex0);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressV = Wrap; AddressU = Wrap;
};

sampler2D alphamap = 
sampler_state
{
	texture = (tex1);
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear;
	AddressV = Wrap; AddressU = Wrap;
};

void vs_main(in float4 ipos : POSITION,
			 in float2 itex : TEXCOORD0,
			 out float4 opos : POSITION,
			 out float2 otex : TEXCOORD0)
{
	opos = mul(ipos, matWorldViewProjection);
	otex = itex;
	otex.y += 1.f;
}

float4 ps_main(in float2 tex : TEXCOORD0) : COLOR0
{

//	return  tex2D(alphamap,tex);

	float4 a = tex2D(alphamap,tex);
	float4 d = tex2D(diffuse ,tex);	
	return float4(d.rgb, a.a);
}

float4 ps_glow(in float2 tex : TEXCOORD0) : COLOR0
{
/*
	float4 main = tex2D(diffuse, tex);
	//return float4(1.f, 0.f, 0.f, 1.f);
	float bw = (main.r + main.g + main.b)/3.f;
	return float4(bw, bw, bw, bw);
	return main; 
	
	*/
	ps *= blur;
	float4 accum = tex2D(diffuse, float2(tex.x, tex.y)) + 
				   tex2D(diffuse, float2(tex.x+ps.x, tex.y)) +
				   tex2D(diffuse, float2(tex.x-ps.x, tex.y)) +
				   tex2D(diffuse, float2(tex.x, tex.y+ps.y)) +
				   tex2D(diffuse, float2(tex.x, tex.y-ps.y)) +
				   tex2D(diffuse, float2(tex.x+ps.x, tex.y+ps.y)) +
				   tex2D(diffuse, float2(tex.x-ps.x, tex.y-ps.y)) +
				   tex2D(diffuse, float2(tex.x-ps.x, tex.y+ps.y)) +
				   tex2D(diffuse, float2(tex.x+ps.x, tex.y-ps.y));
	float4 ak = accum/9.f;
	float4 main = tex2D(diffuse, tex);
	float bw = (ak.r + ak.g + ak.b)/3.f;
	bw=pow(bw, 3.f);
	return float4(1.f, 1.f, 1.f, bw);
	
	return float4(ak.rgb, min(bw*bw, .5f));
}

technique dass 
{
	pass p0
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_main();
	}
	
	pass Glow
	{
		VertexShader = compile vs_2_0 vs_main();
		PixelShader  = compile ps_2_0 ps_glow();
	}
}

