#pragma once

#include "HIV_proxy.h"
#include <d3d9.h>
#include <d3dx9.h>
#include "HIV_proxy.h"
#include "HIV_camera.h"
#include "HIV_pointsprites.h"
#include "HIV_renderstates.h"
#include "HIV_rendertarget.h"
#include "EFFECT_line.h" 
#include "HIV_fft.h"

extern LPDIRECT3DDEVICE9 device;
#define SHADOWMAPSIZE    1024, 1024
#define RENDERTARGETSIZE 512, 512
#define GBSIZE 100
#define GBSPEED 4.f

PointSprites Flow; 
PointSprites Circles; 
Mesh         GroundPlane; 
Camera		skycamera;
Camera      hore; 

TextureProxy Text;
Mesh         TextPlane; 
//Mesh Circle;
RenderTarget     FullScreenBuffer;
RenderTarget     FullScreenBuffer2;

/************************************/

Mesh MongoObj;
Mesh meshLine;
Mesh meshSphere;
Camera camera2;
/*****************************************/
Mesh             ScreenPlane; 
EffectProxy      Effects;
TextureProxy     Textures;
CubeTextureProxy CubeMaps;
MeshProxy        Meshes;
Camera           camera;
Camera           light; 
RenderTarget     ShadowMap;
RenderTarget     BlurMap;
RenderTarget     FloatMap;
RenderTarget     FloatMap2;
void LoadGlobalsKG()
{

	meshSphere.LoadMeshFromMeshFile("KGINVIT\\3d\\obj2.SCENEGeoSphere01.mesh");
	GenerateGrid(&meshLine, 2, 200);

	BlurMap.CreateRenderTarget(800, 600);
	FloatMap.CreateRenderTarget(400, 300, D3DFMT_A8R8G8B8);
	FloatMap2.CreateRenderTarget(400, 300, D3DFMT_A8R8G8B8);

	Flow.InitPointSprites(6000);
	Circles.InitPointSprites(50);
	
	for(int i=0;i<Flow.particleNumber;i++)
	{
		Flow.particleBuffer[i].pos.x = 1000.f*sinf(i*243);
		Flow.particleBuffer[i].pos.y = 1000.f*sinf(i*2345234);
		Flow.particleBuffer[i].pos.z = 1000.f*sinf(i*8546);

		Flow.particleBuffer[i].normal.x = 123.f*PerlinNoise(51234234*i*i*i*i);
	}

//	GenerateGrid(&Circle, 2, 2, 200.f, 200.f, -100.f, -100.f);

	
	FullScreenBuffer.CreateRenderTarget(640.f, 480.f, D3DFMT_A8R8G8B8);
	FullScreenBuffer2.CreateRenderTarget(640.f, 480.f, D3DFMT_X8R8G8B8);
	GenerateGrid(&GroundPlane, GBSIZE, GBSIZE, 100.f, 100.f, -50.f, -50.f);
	GenerateGrid(&TextPlane, 2, 2, 410, 205, -205.f, -80.f);

	/******************************************************************/
	MongoObj.LoadMeshFromMeshFile("KGINVIT\\3d\\obj1.SCENEGeoSphere01.mesh");
	/******************************************************************/
	GenerateGrid(&ScreenPlane, 2, 2, 640, 480, -320.f, -240.f);
	ShadowMap.CreateRenderTarget(SHADOWMAPSIZE);

	const char* textures[] = {"KGINVIT\\remse.png", "flow01", 
							 // "KGINVIT\\tekst\\tekst2.png", "keyalpha01", //
							//  "KGINVIT\\ground_nm.png", "normalmap1",
							 // "KGINVIT\\CementVeryRough.jpg", "diffuse1",
							  "KGINVIT\\fogmap.png", "fog1",
							//  "KGINVIT\\nightsky.png", "nightsky",
							  "KGINVIT\\overlay02.png", "overlay",
							  "KGINVIT\\colormap.png", "colormap", 
							  "KGINVIT\\circle.png", "circle", 
							  "KGINVIT\\test.png", "test",    //bare en test

							  "KGINVIT\\bg_red.png", "bigred",
							  "KGINVIT\\black.png", "black",
							  "KGINVIT\\line.png", "line",
							  "KGINVIT\\env.png", "env",
							  NULL};

	const char* text[] = {"KGINVIT\\text\\keyboarders.png", "keyboarders",
						  "KGINVIT\\text\\and.png", "and",
						  "KGINVIT\\text\\boozo.png", "boozoholics",
						  "KGINVIT\\text\\invites.png", "invites",
						  "KGINVIT\\text\\you.png", "you",
						  "KGINVIT\\text\\not.png", "you2",
						  "KGINVIT\\text\\kindergarden.png", "kindergarden",
						  "KGINVIT\\text\\play.png", "play",
						  "KGINVIT\\text\\blank.png", "blank",

						  "KGINVIT\\text\\ekindergarden.png", "ekg",
						  "KGINVIT\\text\\ehaga.png", "ehaga",
						  "KGINVIT\\text\\e16.png", "edata",
						  "KGINVIT\\text\\eslogan.png", "eslogan",

						  "KGINVIT\\text\\caudio.png", "caudio",
						  "KGINVIT\\text\\cvisuals.png", "cvisuals",
						  "KGINVIT\\text\\cquisten.png", "cquisten",
						  "KGINVIT\\text\\clugge.png", "clugge",

						  "KGINVIT\\text\\sympathy.png", "sympathy",
		NULL};

	const char* effects[]  = {"KGINVIT\\shaders\\particle1.fx", "particle01", 
							  "KGINVIT\\shaders\\particle2.fx", "particle2",
							  "KGINVIT\\shaders\\ground1.fx", "ground1", 
							  "KGINVIT\\shaders\\ground2.fx", "ground2",
							  "KGINVIT\\shaders\\sky.fx", "sky1",
							  "KGINVIT\\shaders\\texture.fx", "texture", 
							  "KGINVIT\\shaders\\shadows.fx", "shadow", 
							  "KGINVIT\\shaders\\fullscreen.fx", "fullscreen",

							  "KGINVIT\\shaders\\obj.fx", "obj1",
							  "KGINVIT\\shaders\\text.fx", "text",
							  "KGINVIT\\shaders\\line.fx", "Line",

							  "KGINVIT\\shaders\\normal.fx", "normal",
							  "KGINVIT\\shaders\\blur.fx", "blur",
							  NULL};

	const char* cubemaps[] = {"KGINVIT\\OutputCube.dds", "cubemap",

		NULL};

	const char* meshes[] = {"KGINVIT\\hemi.SCENEGeoSphere01.mesh", "hemi",
		NULL};

	Text.LoadTextures(text);
	CubeMaps.LoadCubeTextures(cubemaps);
	Textures.LoadTextures(textures);
	Effects.LoadEffects(effects);
	Meshes.LoadMeshes(meshes);
	return; 
};

///////////////////////////////////////////
void DrawMap(LPDIRECT3DTEXTURE9 tex)
{
	HIVCullModeZ(D3DCULL_NONE, false);
	HIVAlpha(false);
	Effects.SetRef("texture");
	Effects.Get()->SetMatrix("matWorldViewProjection", &GetOrthoProjection(640.f, 480.f));
	Effects.Get()->SetTexture("tex0", tex);
	Effects.BeginEffect(0);
	ScreenPlane.RenderMesh();
	Effects.EndEffect();
};