/*
 * Decompiled with CFR 0.152.
 */
package demox;

public class blend {
    int w;
    int h;
    int[] noisemap;

    public blend(int wi, int he) {
        this.w = wi;
        this.h = he;
    }

    public void fadeToBlack(int amount, int[] dest) {
        if (amount > 0 && amount < 256) {
            for (int i = 0; i < dest.length; ++i) {
                dest[i] = amount * (dest[i] & 0xFF00FF) >> 8 & 0xFF00FF | (dest[i] & 0xFF00) * amount >> 8 & 0xFF00;
            }
        }
    }

    public void fadeToWhite(int amount, int[] dest) {
        if (amount > 0 && amount < 256) {
            for (int i = 0; i < dest.length; ++i) {
                int va = 255 - amount & 0xFF;
                int c = dest[i];
                dest[i] = (amount * (c & 0xFF00FF) >> 8) + (va << 16) + va & 0xFF00FF | ((c & 0xFF00) * amount >> 8) + (va << 8) & 0xFF00;
            }
        }
    }

    public void crossfade(int amount, int[] to, int[] from, int[] dest) {
        int p = amount;
        int p2 = 255 - amount;
        if (amount > 0 && amount < 256) {
            for (int i = 0; i < dest.length; ++i) {
                int c1 = from[i];
                int c2 = to[i];
                dest[i] = (p * (c1 & 0xFF00FF) >> 8 & 0xFF00FF) + (p2 * (c2 & 0xFF00FF) >> 8 & 0xFF00FF) | ((c1 & 0xFF00) * p >> 8 & 0xFF00) + ((c2 & 0xFF00) * p2 >> 8 & 0xFF00);
            }
        }
    }

    public void blendAvg(int[] to, int[] from, int[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            int c1 = from[i];
            int c2 = to[i];
            dest[i] = ((c1 & 0xFF00FF) >> 1 & 0xFF00FF) + ((c2 & 0xFF00FF) >> 1 & 0xFF00FF) | ((c1 & 0xFF00) >> 1 & 0xFF00) + ((c2 & 0xFF00) >> 1 & 0xFF00);
        }
    }

    public void blendAdd(int[] src1, int[] src2, int[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            int c1 = src1[i];
            int c2 = src2[i];
            int r = (c1 >> 16 & 0xFF) + (c2 >> 16 & 0xFF);
            int g = (c1 >> 8 & 0xFF) + (c2 >> 8 & 0xFF);
            int b = (c1 & 0xFF) + (c2 & 0xFF);
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            dest[i] = r << 16 | g << 8 | b;
        }
    }

    public void blendSub(int[] src1, int[] src2, int[] dest) {
        for (int i = 0; i < this.w * this.h; ++i) {
            int c1 = src1[i];
            int c2 = src2[i];
            int r = (c1 >> 16 & 0xFF) - (c2 >> 16 & 0xFF);
            int g = (c1 >> 8 & 0xFF) - (c2 >> 8 & 0xFF);
            int b = (c1 & 0xFF) - (c2 & 0xFF);
            if (r < 0) {
                r = 0;
            }
            if (g < 0) {
                g = 0;
            }
            if (b < 0) {
                b = 0;
            }
            dest[i] = r << 16 | g << 8 | b;
        }
    }

    public void krome(int[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            int r = dest[i] >> 16 & 0xFF;
            int g = dest[i] >> 8 & 0xFF;
            int b = dest[i] & 0xFF;
            if (r > 127) {
                r = 128 - (r - 127);
            }
            if (g > 127) {
                g = 128 - (g - 127);
            }
            if (b > 127) {
                b = 128 - (b - 127);
            }
            dest[i] = r << 17 | g << 9 | b << 1;
        }
    }

    public void overlay(int[] src, int[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            int p = src[i] >> 24 & 0xFF;
            if (p <= 0) continue;
            if (p > 254) {
                dest[i] = src[i];
                continue;
            }
            int p2 = 255 - p;
            int c1 = src[i];
            int c2 = dest[i];
            dest[i] = (p * (c1 & 0xFF00FF) >> 8 & 0xFF00FF) + (p2 * (c2 & 0xFF00FF) >> 8 & 0xFF00FF) | ((c1 & 0xFF00) * p >> 8 & 0xFF00) + ((c2 & 0xFF00) * p2 >> 8 & 0xFF00);
        }
    }

    public void overlay(int s, int[] src, int[] dest) {
        for (int i = 0; i < dest.length; ++i) {
            int p = src[i] >> 24 & 0xFF;
            if (p <= 0) continue;
            if ((p = p * s >> 8) > 254) {
                dest[i] = src[i];
                continue;
            }
            int p2 = 255 - p;
            int c1 = src[i];
            int c2 = dest[i];
            dest[i] = (p * (c1 & 0xFF00FF) >> 8 & 0xFF00FF) + (p2 * (c2 & 0xFF00FF) >> 8 & 0xFF00FF) | ((c1 & 0xFF00) * p >> 8 & 0xFF00) + ((c2 & 0xFF00) * p2 >> 8 & 0xFF00);
        }
    }

    public void initNoise() {
        int col = 0;
        this.noisemap = new int[65536];
        for (int i = 0; i < 65536; ++i) {
            this.noisemap[i] = col = col + (int)(Math.random() * 256.0) >> 1;
        }
    }

    public void noise(int amount2, int[] dest) {
        int amount = amount2 + (int)(Math.random() * 4.0 - 2.0);
        if (amount > 255) {
            amount = 255;
        }
        int p = amount;
        int p2 = 255 - amount;
        int r = (int)(Math.random() * 65535.0) + amount * 232151 & 0xFFFF;
        if (amount > 0 && amount < 256) {
            for (int i = 0; i < dest.length; ++i) {
                int c1 = dest[i];
                int c2 = p * this.noisemap[i + r & 0xFFFF] >> 8;
                dest[i] = (p2 * (c1 & 0xFF00FF) >> 8 & 0xFF00FF) + (c2 << 16 | c2) | ((c1 & 0xFF00) * p2 >> 8 & 0xFF00) + (c2 << 8);
            }
        }
    }

    public void drawImg(int imgw, int imgh, int posx, int posy, int[] img, int[] dest) {
        int ax = imgw;
        int ay = imgh;
        int bx = 0;
        int by = 0;
        if (posx < 0) {
            ax = imgw + posx;
            bx = -posx;
        }
        if (posx > this.w) {
            return;
        }
        if (posy < 0) {
            ay = imgh + posy;
            by = -posy;
        }
        if (posy > this.h) {
            return;
        }
        if (posx + imgw > this.w) {
            ax -= posx + imgw - this.w;
        }
        if (posy + imgh > this.h) {
            ay -= posy + imgh - this.h;
        }
        if (posx < 0) {
            posx = 0;
        }
        if (posy < 0) {
            posy = 0;
        }
        for (int y = 0; y < ay; ++y) {
            int a = (y + posy) * this.w + posx;
            int b = (by + y) * imgw + bx;
            for (int x = 0; x < ax; ++x) {
                dest[a + x] = img[b + x];
            }
        }
    }

    public void drawImgAdd(int imgw, int imgh, int posx, int posy, int[] img, int[] dest) {
        int ax = imgw;
        int ay = imgh;
        int bx = 0;
        int by = 0;
        if (posx < 0) {
            ax = imgw + posx;
            bx = -posx;
        }
        if (posx > this.w) {
            return;
        }
        if (posy < 0) {
            ay = imgh + posy;
            by = -posy;
        }
        if (posy > this.h) {
            return;
        }
        if (posx + imgw > this.w) {
            ax -= posx + imgw - this.w;
        }
        if (posy + imgh > this.h) {
            ay -= posy + imgh - this.h;
        }
        if (posx < 0) {
            posx = 0;
        }
        if (posy < 0) {
            posy = 0;
        }
        for (int y = 0; y < ay; ++y) {
            int a = (y + posy) * this.w + posx;
            int b = (by + y) * imgw + bx;
            for (int x = 0; x < ax; ++x) {
                int c1 = img[b + x] & 0xFFFFFF;
                if (c1 == 0) continue;
                int c2 = dest[a + x];
                int r = (c1 >> 16 & 0xFF) + (c2 >> 16 & 0xFF);
                int g = (c1 >> 8 & 0xFF) + (c2 >> 8 & 0xFF);
                int bb = (c1 & 0xFF) + (c2 & 0xFF);
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (bb > 255) {
                    bb = 255;
                }
                dest[a + x] = r << 16 | g << 8 | bb;
            }
        }
    }
}

