import java.awt.*;
import java.awt.event.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import com.sun.j3d.utils.geometry.*;
import com.sun.j3d.utils.universe.*;

/**
 * Example08 illustrates how to take advantage of some of the
 * utilities offered in Sun's non-standard Java 3D packages.
 * <p>
 * IMPORTANT:  This source code example is offered under the license at:
 * http://wireless.java.sun.com/berkeley_license.html
 *
 * @author Bill Day <bill.day@sun.com>
 * @version 1.2
 * @see com.sun.j3d.utils.geometry.ColorCube
 * @see com.sun.j3d.utils.universe.SimpleUniverse
 * @see java.awt.GraphicsConfiguration
**/

public class Example08 extends Frame {
  /**
   * Instantiates an Example08 object.
  **/
  public static void main(String args[]) {
    new Example08();
  }

  /**
   * The Example08 constructor sets the frame's size, adds the
   * visual components, and then makes them visible to the user.
   * <P>
   * We place a Canvas3D object into the Frame so that Java 3D
   * has the heavyweight component it needs to render 3D
   * graphics into.  We then call methods to construct the
   * View and Content branches of our scene graph.
  **/
  public Example08() {
    //Title our frame and set its size.
    super("Java 3D Example08, Sun Utilities");
    setSize(400,300);

    //Here is our first Java 3d-specific code.  Using Sun's
    //SimpleUniverse utility, we can combine the View and
    //view branch construction into a few simple steps.
    //First, we use SimpleUniverse's static getPreferredConfiguration()
    //method to set up our Canvas3D and add it to our Frame.
    GraphicsConfiguration myGraphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
    Canvas3D myCanvas3D = new Canvas3D(myGraphicsConfiguration);
    add(myCanvas3D,BorderLayout.CENTER);

    //Then, we instantiate a SimpleUniverse using our Canvas3D,
    //create our content branch, and add it into the SimpleUniverse.
    SimpleUniverse myUniverse = new SimpleUniverse(myCanvas3D);
    BranchGroup contentBranchGroup = constructContentBranch();
    myUniverse.addBranchGraph(contentBranchGroup);

    //Turn on the visibility of our frame.
    setVisible(true);

    //We want to be sure we properly dispose of resources
    //this frame is using when the window is closed.  We use
    //an anonymous inner class adapter for this.
    addWindowListener(new WindowAdapter()
      {public void windowClosing(WindowEvent e)
         {dispose(); System.exit(0);}
      }
    );
  }

  /**
   * constructContentBranch() is where we specify the 3D graphics
   * content to be rendered.  We return the content branch group
   * for use with our SimpleUniverse.  We also demonstrate the
   * use of com.sun.j3d.utils.geometry.ColorCube to build more
   * complicated 3D shapes.
   *
  **/
  private BranchGroup constructContentBranch() {
    Font myFont = new Font("TimesRoman",Font.PLAIN,10);
    Font3D myFont3D = new Font3D(myFont,new FontExtrusion());
    Text3D myText3D = new Text3D(myFont3D, "Hello Camp");
    Shape3D myShape3D = new Shape3D(myText3D, new Appearance());
    Shape3D myCube = new ColorCube();

    BranchGroup contentBranchGroup = new BranchGroup();
    Transform3D myTransform3D = new Transform3D();
    myTransform3D.setTranslation(new Vector3f(-1.0f,0.0f,-4.0f));
    myTransform3D.setScale(0.1);
    Transform3D tempTransform3D = new Transform3D();
    tempTransform3D.rotY(Math.PI/4.0d);
    myTransform3D.mul(tempTransform3D);
    TransformGroup contentTransformGroup = new TransformGroup(myTransform3D);

    contentTransformGroup.addChild(myShape3D);
    contentBranchGroup.addChild(contentTransformGroup);

    myTransform3D.setIdentity();
    myTransform3D.setTranslation(new Vector3f(-0.5f,-0.5f,-2.3f));
    myTransform3D.setScale(0.1);
    TransformGroup cubeTransformGroup = new TransformGroup(myTransform3D);

    cubeTransformGroup.addChild(myCube);
    contentBranchGroup.addChild(cubeTransformGroup);

    return(contentBranchGroup);
  }
}
