/*
 * Decompiled with CFR 0.152.
 */
public class Vector {
    protected float[] v = new float[3];

    public Vector() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector(float f, float f2, float f3) {
        this.v[0] = f;
        this.v[1] = f2;
        this.v[2] = f3;
    }

    public final float getLength() {
        return (float)Math.sqrt(Vector.dotProduct(this, this));
    }

    public static final Vector scale(float f, Vector vector) {
        return new Vector(f * vector.v[0], f * vector.v[1], f * vector.v[2]);
    }

    public static final float getAngle(Vector vector, Vector vector2) {
        float f = vector.getLength();
        if (f == 0.0f) {
            return 0.0f;
        }
        float f2 = vector2.getLength();
        if (f2 == 0.0f) {
            return 0.0f;
        }
        return Vector.dotProduct(vector, vector2) / (f * f2);
    }

    public static final Vector add(Vector vector, Vector vector2) {
        return new Vector(vector.v[0] + vector2.v[0], vector.v[1] + vector2.v[1], vector.v[2] + vector2.v[2]);
    }

    public static final Vector sub(Vector vector, Vector vector2) {
        return new Vector(vector.v[0] - vector2.v[0], vector.v[1] - vector2.v[1], vector.v[2] - vector2.v[2]);
    }

    public static final Vector normalize(Vector vector) {
        float f = vector.getLength();
        if (f == 0.0f) {
            return new Vector(0.0f, 0.0f, 0.0f);
        }
        return new Vector(vector.v[0] / f, vector.v[1] / f, vector.v[2] / f);
    }

    public static final float dotProduct(Vector vector, Vector vector2) {
        return vector.v[0] * vector2.v[0] + vector.v[1] * vector2.v[1] + vector.v[2] * vector2.v[2];
    }

    public static final Vector scale(Vector vector, Vector vector2) {
        return new Vector(vector.v[0] * vector2.v[0], vector.v[1] * vector2.v[1], vector.v[2] * vector2.v[2]);
    }

    public static final Vector crossProduct(Vector vector, Vector vector2) {
        return new Vector(vector.v[1] * vector2.v[2] - vector2.v[1] * vector.v[2], -(vector.v[0] * vector2.v[2] - vector2.v[0] * vector.v[2]), vector.v[0] * vector2.v[1] - vector.v[1] * vector2.v[0]);
    }

    public static final float[] getAngle(Vector vector, Vector[] vectorArray) {
        float[] fArray = new float[vectorArray.length];
        for (int i = 0; i < vectorArray.length; ++i) {
            fArray[i] = Vector.getAngle(vector, vectorArray[i]);
        }
        return fArray;
    }

    public static final float[] dotProduct(Vector vector, Vector[] vectorArray) {
        float[] fArray = new float[vectorArray.length];
        for (int i = 0; i < vectorArray.length; ++i) {
            fArray[i] = Vector.dotProduct(vector, vectorArray[i]);
        }
        return fArray;
    }

    public static final Vector[] scale(float f, Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray2[i] = Vector.scale(f, vectorArray[i]);
        }
        return vectorArray2;
    }

    public static final Vector[] scale(float[] fArray, Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray2[i] = Vector.scale(fArray[i], vectorArray[i]);
        }
        return vectorArray2;
    }

    public static final float[] getAngle(Vector[] vectorArray, Vector[] vectorArray2) {
        float[] fArray = new float[vectorArray2.length];
        for (int i = 0; i < vectorArray2.length; ++i) {
            fArray[i] = Vector.getAngle(vectorArray[i], vectorArray2[i]);
        }
        return fArray;
    }

    public static final Vector[] add(Vector vector, Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray2[i] = Vector.add(vector, vectorArray[i]);
        }
        return vectorArray2;
    }

    public static final Vector[] sub(Vector vector, Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray2[i] = Vector.sub(vector, vectorArray[i]);
        }
        return vectorArray2;
    }

    public static final Vector[] normalize(Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray2[i] = Vector.normalize(vectorArray[i]);
        }
        return vectorArray2;
    }

    public static final float[] dotProduct(Vector[] vectorArray, Vector[] vectorArray2) {
        float[] fArray = new float[vectorArray2.length];
        for (int i = 0; i < vectorArray2.length; ++i) {
            fArray[i] = Vector.dotProduct(vectorArray[i], vectorArray2[i]);
        }
        return fArray;
    }

    public static final Vector[] scale(Vector vector, Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray2[i] = Vector.scale(vector, vectorArray[i]);
        }
        return vectorArray2;
    }

    public static final Vector[] crossProduct(Vector vector, Vector[] vectorArray) {
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        for (int i = 0; i < vectorArray.length; ++i) {
            vectorArray2[i] = Vector.crossProduct(vector, vectorArray[i]);
        }
        return vectorArray2;
    }

    public static final Vector[] add(Vector[] vectorArray, Vector[] vectorArray2) {
        Vector[] vectorArray3 = new Vector[vectorArray2.length];
        for (int i = 0; i < vectorArray2.length; ++i) {
            vectorArray3[i] = Vector.add(vectorArray[i], vectorArray2[i]);
        }
        return vectorArray3;
    }

    public static final Vector[] sub(Vector[] vectorArray, Vector[] vectorArray2) {
        Vector[] vectorArray3 = new Vector[vectorArray2.length];
        for (int i = 0; i < vectorArray2.length; ++i) {
            vectorArray3[i] = Vector.sub(vectorArray[i], vectorArray2[i]);
        }
        return vectorArray3;
    }

    public static final Vector[] scale(Vector[] vectorArray, Vector[] vectorArray2) {
        Vector[] vectorArray3 = new Vector[vectorArray2.length];
        for (int i = 0; i < vectorArray2.length; ++i) {
            vectorArray3[i] = Vector.scale(vectorArray[i], vectorArray2[i]);
        }
        return vectorArray3;
    }

    public static final Vector[] crossProduct(Vector[] vectorArray, Vector[] vectorArray2) {
        Vector[] vectorArray3 = new Vector[vectorArray2.length];
        for (int i = 0; i < vectorArray2.length; ++i) {
            vectorArray3[i] = Vector.crossProduct(vectorArray[i], vectorArray2[i]);
        }
        return vectorArray3;
    }
}

