/*
 * Decompiled with CFR 0.152.
 */
public class BumpMapSurface
extends Surface {
    private int cx1;
    private int cy1;
    private int[] text = null;
    private int[] shade = null;
    private int[] lumapx = null;
    private int[] lumapy = null;
    private int[] bumpmap = null;

    private static final int diff(int n, int n2) {
        return (n & 0xFF) + (n >> 8 & 0xFF) + (n >> 16 & 0xFF) - ((n2 & 0xFF) + (n2 >> 8 & 0xFF) + (n2 >> 16 & 0xFF));
    }

    private static final int range(int n, int n2, int n3) {
        if (n >= n2) {
            if (n <= n3) {
                return n;
            }
            return n3;
        }
        return n2;
    }

    public final void render() {
        int n = super.getH();
        int n2 = super.getW();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n - 1) {
            int n5 = 0;
            while (n5 < n2 - 1) {
                int n6 = BumpMapSurface.range(this.lumapx[n3] + n5 - this.cx1, 0, 255);
                int n7 = BumpMapSurface.range(this.lumapy[n3] + n4 - this.cy1, 0, 255);
                int n8 = this.bumpmap[n6 | n7 << 8];
                int n9 = this.text[n3];
                this.buffer[n3] = 0xFF000000 | this.shade[n9 << 8 & 0xFF00 | n8] | this.shade[n9 & 0xFF00 | n8] << 8 | this.shade[n9 >> 8 & 0xFF00 | n8] << 16;
                ++n5;
                ++n3;
            }
            ++n4;
            ++n3;
        }
    }

    public void setLight(int n, int n2) {
        this.cx1 = n;
        this.cy1 = n2;
    }

    private static final void smoothtbl(int[] nArray, int n, int n2) {
        for (int i = 1; i < n2 - 1; ++i) {
            for (int j = 1; j < n - 1; ++j) {
                nArray[j + i * n] = (nArray[j + 1 + i * n] + nArray[j - 1 + i * n] + nArray[j + n + i * n] + nArray[j - n + i * n] + nArray[j + i * n]) / 5;
            }
        }
    }

    public BumpMapSurface(Surface surface, Surface surface2) {
        super(surface.getW(), surface.getH());
        int n;
        int n2;
        this.text = surface.getBuffer();
        int[] nArray = surface2.getBuffer();
        this.lumapx = new int[super.getW() * super.getH()];
        this.lumapy = new int[super.getW() * super.getH()];
        this.bumpmap = new int[65536];
        this.shade = new int[65536];
        int n3 = super.getW() * super.getH();
        int n4 = 0;
        for (n2 = 0; n2 < 256; ++n2) {
            for (n = 0; n < 256; ++n) {
                this.bumpmap[n4++] = BumpMapSurface.range((int)(127.0 - Math.sqrt((128 - n) * (128 - n) + (128 - n2) * (128 - n2))) * 2, 0, 255);
            }
        }
        for (n = 0; n < super.getW(); ++n) {
            this.lumapy[n + super.getW() * (super.getH() - 1)] = 0;
            this.lumapy[n] = 0;
            this.lumapx[n + super.getW() * (super.getH() - 1)] = 0;
            this.lumapx[n] = 0;
        }
        for (n2 = 0; n2 < super.getH(); ++n2) {
            this.lumapy[n2 * super.getW() + (super.getW() - 1)] = 0;
            this.lumapy[n2 * super.getW()] = 0;
            this.lumapx[n2 * super.getW() + (super.getW() - 1)] = 0;
            this.lumapx[n2 * super.getW()] = 0;
        }
        n4 = 0;
        for (n2 = 1; n2 < super.getH() - 1; ++n2) {
            for (n = 1; n < super.getW() - 1; ++n) {
                n4 = n + n2 * super.getW();
                this.lumapx[n4] = BumpMapSurface.range(BumpMapSurface.diff(nArray[n4], nArray[n4 + 1]) + 128, 0, 255);
                this.lumapy[n4] = BumpMapSurface.range(BumpMapSurface.diff(nArray[n4], nArray[n4 + super.getW()]) + 128, 0, 255);
            }
        }
        BumpMapSurface.smoothtbl(this.lumapx, super.getW(), super.getH());
        BumpMapSurface.smoothtbl(this.lumapy, super.getW(), super.getH());
        BumpMapSurface.smoothtbl(this.lumapx, super.getW(), super.getH());
        BumpMapSurface.smoothtbl(this.lumapy, super.getW(), super.getH());
        n4 = 0;
        for (n2 = 0; n2 < 256; ++n2) {
            for (n = 0; n < 256; ++n) {
                this.shade[n4++] = BumpMapSurface.range(n * n2 / 128, 0, 255);
            }
        }
    }

    public BumpMapSurface(Surface surface, Surface surface2, Surface surface3) {
        this(surface, surface2);
        for (int i = 0; i < 65536; ++i) {
            this.bumpmap[i] = BumpMapSurface.diff(surface3.getBuffer()[i], 0) / 3;
        }
    }
}

