struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

float V_Alph : ALPHA;

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float4 PS(VS_OUTPUT In) : COLOR0
{
  float4 color = tex2D(Sampler, In.Tex0);
  color.a = V_Alpha;
  return color;
}

//--------------------------------------------------------------//
// Technique Section for Procedural Graphic Effects 2D
//--------------------------------------------------------------//
technique Additive
{
   pass PassAdditive
   {
      CullMode         = NONE;
  		AlphaBlendEnable = true;
	  	SrcBlend         = srcalpha;
		  DestBlend        = one;

      PixelShader      = compile ps_1_1 PS();
   }
}
